;;; -*- coding: iso-2022-7bit; byte-compile-dynamic: t -*-
;;; mucs.el --- for MULE-UCS configuration

;; Copyright (C) 1997-1999 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:

;;;; 
;; 0.00->NUBATAMA (YUME)
;; 0.50->MYOSHINJI Temple
;; 0.60->ARASHIYAMA
;; 0.70->KITANOTENMANGU Shrine
;; 0.80->JISHOJI Temple
;; 0.90->Mt.DAIMONJI
;; 1.00->SHINNYODO Temple
;; 1.10->SHIGAKOEMICHI Ave.
;; 1.20->Mt.HIEI
;; 1.30->KITAYAMA
;; 1.40->ROKUONJI Temple
;; 1.50->NINNAJI Temple
;; 1.60->HORIKAWA Liver
;; 1.70->NISHIJIN
;; 1.80->IMADEGAWA
;; 1.90->DAIRI
;; 2.00->Kyoto Univ.
(defconst mucs-version "0.63 (HOUKYOUIN:$BJud:1!(B)")

;;
;; For error handling.
;;

(require 'mucs-error)

;;; fundamental data.

(defvar emacs-value-bits 28)
(defvar mucs-code-range-bits 24)
(defvar mucs-data-path "reldata/")
(defvar mucs-invalid-code -1
  "invalid code.  If this value is set, skip operation.")

(defun mucs-require-data (package)
  (or (featurep package)
      (load (expand-file-name (symbol-name package)
			      mucs-data-path)
	    t)
      (require package)))

(defun mucs-require-supplement (package &optional base)
  "require supplement module."
  (or (featurep package)
      (if (or load-in-progress
	      base)
	  (load (expand-file-name 
		 (symbol-name package)
		 (file-name-directory
		  (if (and (boundp 'load-file-name)
			   (stringp 'load-file-name))
		      load-file-name
		    (if base
			(locate-library
			 (symbol-name base))
		      (error "Cannot resolve the location of %s!"
			     package))))))
	(require package))))

(defun mucs-max-code ()
  (1- (lsh 1 mucs-code-range-bits)))

(defun mucs-number-mask ()
  (lognot 0))

;;;
;;; version detection
;;;

(defvar mule-parsed-version
  (and (boundp 'mule-version)
       (string-match "^\\([0-9]+\\)\\.\\([0-9]+\\)" mule-version)
       (cons (string-to-number (match-string 1 mule-version))
	     (string-to-number (match-string 2 mule-version)))))

(defun mule-version-satisfied-p (major minor)
  (and mule-parsed-version
       (or (> (car mule-parsed-version) major)
	   (and (= (car mule-parsed-version) major)
		(>= (cdr mule-parsed-version) minor)))))

;;; Package management.

(defvar mucs-current-package nil)

(defvar mucs-current-type nil
  "MUCS-UCS code generator's internal variable.
This variable specifies the type of data that the current context stores.")

(defmacro mucs-define-package (package &rest form)
  "Enclose a unit of package with this.
By this specification, MULE-UCS may judge
whether generate a new program to prepare.
You should make PACKAGE same of your package name
that you set in `provide' function."
  (if (not (symbolp package))
      (signal 'wrong-type-argument package))
  (setq mucs-current-package package)
  (put mucs-current-package 'mucs-registered-tables nil)
  (put mucs-current-package 'mucs-registered-ccls nil)
  (append
   `(let ((mucs-current-package (quote ,package))))
   form))

;;; Fundamental configuration ends here.

;;;
;;; Mule-UCS conversion engine setup!
;;;  (currently, only CCL)

(cond ((fboundp 'ccl-execute)
       (require 'mucs-ccl))
;      ((fboundp 'cdl-execute)
;       (require 'mucs-cdl))
      (t
       (error "This Emacs does not have Mule-UCS conversion engine!")))


;;
;; "conversion" manager
;;
;; PROPERTY SYMBOL LIST
;;    mucs-conv-type:
;;    mucs-conversion-definition:
;;    mucs-dependent-translation:
;;    mucs-compiled-code(optional):

(defmacro mucs-define-conversion (symbol convtype definition)
  "Define conversion.
SYMBOL is a symbol to identify the defined conversion.
CONVTYPE specifies how this conversion is used; You can specify
either stream(symbol) or (FROM-TYPE . TO-TYPE), and FROM-TYPE and TO-TYPE
are defined MULE-UCS-TYPE.
  If CONVTYPE is stream, this conversion is used for stream, i.e.
this can be used by coding-system.
  If CONVTYPE is (FROM-TYPE . TO-TYPE), this conversion is used for
converting data of FROM-TYPE into data of TO-TYPE.
  DEFINITION specifies the definition of the conversion.

  conversions defined by this function are embedded to .elc file.
Therefore, you can use these without any MULE-UCS modules.

  All arguments are NOT evaluated!"
  (if (not (or (eq convtype 'stream)
	       (consp convtype)
	       (mucs-type-p (car convtype))
	       (mucs-type-p (cdr convtype))))
      (error "Invalid CONVTYPE:%S" convtype))
  (put symbol 'mucs-conv-type convtype)
  `(progn
     (put (quote ,symbol) 'mucs-conv-type (quote ,convtype))
     ,@(mucs-setup-conversion symbol definition)
     (put (quote ,symbol) 'mucs-conversion-program
	  (quote ,(get symbol 'mucs-conversion-program)))
     nil))

(defun mucs-conversion-definition-mag (definition)
  (eval (car definition)))

(defun mucs-conversion-definition-main-prog (definition)
  (nth 1 definition))

(defun mucs-conversion-definition-eof-prog (definition)
  (nth 2 definition))

(defsubst mucs-conversion-get-conv-type (symbol)
  (get symbol 'mucs-conv-type))

(defsubst mucs-conversion-set-program-and-compiled-code
  (symbol program code)
  (put symbol 'mucs-conversion-program program)
  (if code
      (put symbol 'mucs-compiled-code code)))

;;;
;;;
;;;

(defmacro mucs-define-coding-system
  (symbol mnemonic doc-string
	  decode-conversion encode-conversion
	  &optional alist eol-type)
  (if (mule-version-satisfied-p 4 1)
      `(make-coding-system
	,symbol 4 ,mnemonic ,doc-string
	(cons ,decode-conversion
	      ,encode-conversion)
	,alist ,eol-type)
    `(make-coding-system
      ,symbol 4 ,mnemonic ,doc-string
      (cons ,decode-conversion
	    ,encode-conversion)
      ,alist)))

(provide 'mucs)
