/*
 * LEVEE, or Captain Video;  A vi clone
 *
 * Copyright (c) 1982-1997 David L Parsons
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by David L Parsons (orc@pell.chi.il.us).  My name may not be used
 * to endorse or promote products derived from this software without
 * specific prior written permission.  THIS SOFTWARE IS PROVIDED
 * AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.
 */
#include <unistd.h>
#include <string.h>
#include <signal.h>

#include "levee.h"
#include "extern.h"

/* make a unique temporary file */
void stamp(char *s, char *templat)
{
    char *getenv();

    strcpy(s, "/tmp/");

    strcat(s, templat);
    numtoa(&s[strlen(s)], getpid());
}

/* ctrlc: control-C handler */
void ctrlc()
{
    count = 0;	/* clear count, eh? */
}

/* initialize: set up everything I can in levee */
void initialize(int count, char **args)
{
    int i;
    char *getenv();

    signal(SIGINT, ctrlc);
    initcon();

#if ZTERM
    zconfig();
#endif /*ZTERM*/

#if TERMCAP
    tc_init();
#endif

    version(); strput(".  Copyright (c) 1983-1989 by David Parsons");

    if (!CA) {
	lineonly = TRUE;
        levee_mvcur(0, 0);
        strput(CE);
	prints("(line mode)");
    } else {
	lineonly = FALSE;
    }

    /* initialize macro table */
    for (i = 0;i < MAXMACROS;i++)
	mbuffer[i].token = 0;
    core[0] = EOL;
	
    yank.size = ERR;		/* no yanks yet */
    
    undo.blockp = undo.ptr = 0;
    
    fillchar(adjcurr, sizeof(adjcurr), 0);
    fillchar(adjendp, sizeof(adjendp), 0);
    
    adjcurr[BTO_WD]	=	/* more practical to just leave dynamic */
    adjcurr[SENT_BACK]	=
    adjendp[BTO_WD]	=
    adjendp[FORWD]	=
    adjendp[MATCHEXPR]	=
    adjendp[PATT_BACK]	=
    adjendp[TO_CHAR]	=
    adjendp[UPTO_CHAR]	=
    adjendp[PAGE_BEGIN]	=
    adjendp[PAGE_MIDDLE]=
    adjendp[PAGE_END]	= TRUE;

    fillchar(contexts, sizeof(contexts), -1);

    stamp(undobuf, "$un");
    stamp(yankbuf, "$ya");
    stamp(undotmp, "$tm");
    
    levee_mvcur(LINES-1,0);
    {	char *p;
	extern char *execstr;	/* [exec.c] */

	if ((p = getenv("LVRC"))) {
	    strcpy(instring,p);
	    execstr = instring;
	    setcmd();
	}
    }

    ++args, --count;
    if (count > 0 && **args == '+') {
	char *p = *args;
	strcpy(startcmd, p[1] ? (1+p) : "$");
	++args, --count;
    }
    argc = 0;
    while (count-- > 0)
	expandargs(*args++, &argc, &argv);
    if (argc > 0) {
	strcpy(filenm, argv[0]);
	if (argc > 1)
	    toedit(argc);
	inputf(filenm,TRUE);
    }
    else
	filenm[0] = 0;
}

boolean execmode(exec_type emode)
{
    boolean more,			/* used [more] at end of line */
	 noquit;		/* quit flag for :q, :xit, :wq */
    exec_type mode;

    zotscreen = diddled = FALSE;
    noquit = TRUE;

    if (lineonly)
	println();

    mode=emode;
    do {
	prompt(FALSE,":");
	if (getline(instring))
	    exec(instring, &mode, &noquit);
	indirect = FALSE;
	if (mode == E_VISUAL && zotscreen && noquit) {	/*ask for more*/
	    prints(" [more]");
	    if ((ch=peekc()) == 13 || ch == ' ' || ch == ':')
		readchar();
	    more = (ch != ' ' && ch != 13);
	}
	else
	    more = (mode == E_EDIT);
	if (mode != E_VISUAL && curpos.x > 0)
	    println();
	else
	    levee_mvcur(-1,0);
    } while (more && noquit);
    if (zotscreen)
	clrprompt();
    return noquit;
}

int main(int argc, char **argv)
{
    initialize(argc, argv);

    diddled = TRUE;	/* force screen redraw when we enter editcore() */
    if (lineonly)
	while (execmode(E_EDIT))
	    prints("(no visual mode)");
    else
	while (execmode(editcore()))
            /* do nada */;

    unlink(undobuf);
    unlink(yankbuf);

#if ZTERM
    zclose();
#endif

    fixcon();

    println();
    exit(0);
}
