% These routines facilitate the manipulation of mode dependent data.

!if (is_defined ("Mode_Info_Type"))
typedef struct
{
   next,			       %  Pointer to next
     mode_name,			       %  Name of Mode
   
   % Modal Data follows
   
     fold_info,			       %  folding.sl: beg\rend\r\beg1\r\end1
     dabbrev_word_chars,		       %  word chars for dabbrev mode
     init_mode_menu,
}
Mode_Info_Type;

static variable Mode_Info_List = NULL;
static define find_mode_info (mode_name)
{
   variable mode_info;
   
#iftrue
   foreach (Mode_Info_List) using ("next")
     {
	mode_info = ();
	if (mode_info.mode_name == mode_name)
	  return mode_info;
     }
   return NULL;
#else
   mode_info = Mode_Info_List;
   while (mode_info != NULL)
     {
	if (mode_info.mode_name == mode_name)
	  break;
	mode_info = mode_info.next;
     }
   return mode_info;
#endif
}

define mode_set_mode_info (mode_name, field_name, field_value)
{
   variable mode_info;
   
   mode_info = find_mode_info (mode_name);
   if (mode_info == NULL)
     {
	mode_info = @Mode_Info_Type;
	mode_info.next = Mode_Info_List;
	mode_info.mode_name = mode_name;
	Mode_Info_List = mode_info;
     }

   set_struct_field (mode_info, field_name, field_value);
}
   
define mode_get_mode_info (field_name)
{
   variable mode_info;
   
   if (_NARGS == 1)
     get_mode_name ();

   variable mode_name = ();
     
   mode_info = find_mode_info (mode_name);
   if (mode_info == NULL)
     return NULL;
   
   return get_struct_field (mode_info, field_name);
}
