/* GXedit
 * Copyright 1998 Patrick Lambert <drow@wildstar.net>
 *
 * This program is free software. You can use, copy and modify it under
 * the terms of the GPL. See the file COPYING for the full GPL license.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>  
#include <math.h>
#include <sys/time.h>
#include <gtk/gtk.h>
#include "config.h"
#ifdef USE_SOCKS
#include <socks.h>
#endif
#ifdef GTKEDITOR_PATCH
#include "gtkeditor.h"
#endif
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h> 
#include <unistd.h>
#include <ctype.h>
#define ABOUT "GXedit is a multi function graphical text editor\nmade by Patrick Lambert <drow@darkelf.net>\nhttp://devplanet.fastethernet.net"
#define HELP1 "GXedit User Manual\n\n"
/* this is to keep the config stuff at all times */
char search_string[101];
char filename[501], home[101], line[513], global_var[513], col_name[101], login[101];
char images[101], progname[101], mail_from[101], mail_server[101], cvs_root[101], cvs_dir[101];
char temp[1024], temp2[101], news_server[101], subject[101], mirror_remote[101];
char bg[101], bg_pixmap[101], font[101], xfm[101], dict[101], doc_dir[101], gzip[101], default_news[101], default_web[101], compile[101];
char tmp_name[50], tmp_name2[50], findbuf[512], current_project[512];
int toolbar, tooltips, x_size, y_size, x_pos, y_pos, debug, no_cfg, full_tb, set_edit, convert, indent, auto_indent, access_opt, audio, show_project;
int run_in_xterm, run_in_bg, autosave, modified, reply, mirr_serv, mirr_cl, mirr_timeout, s, ss, icons, flat, netbar, nonet, old_open, cvs_z3, show_line;
int scroll_loc, letters_count, words_count, page_width, line_wrap, mail_cmd, syntax_h, fortune, marked, h_style, tail, tail_t, htmlbar, use_socks;
int binded, hs, urlbar, tab_width, sticky_dir, use_xrn;
long original;
size_t TS;
/* widgets */
GList *last_files;
GdkColormap *cmap;
GdkColor color, html, sh_c;
GtkTooltips *tips;
GtkStyle *style;
GdkPixmap *pixm;
GtkWidget *window, *text, *button, *table, *label, *BMmenu, *menu, *menubutton, *hbox;
GtkWidget *menubar, *menuitem, *vscrollbar, *hscrollbar, *vbox, *vbox3, *window2, *window4, *window5, *text2, *sep, *hbox2;
GtkWidget *entry_box, *cb1, *eb1, *eb2, *eb3, *eb4, *eb5, *eb6, *eb7, *eb8, *eb9, *eb10, *eb11, *eb12, *eb13, *eb14, *eb15, *eb16, *eb17, *eb18, *eb19, *eb20, *eb21, *eb22, *eb23, *eb24, *eb25, *eb26, *project_list, *url_list;
GtkWidget *text_debug, *dw, *submenu, *root_tree, *root_item, *notebook, *submenu2, *noteWin, *noteLabel;
GtkWidget *frame, *vbox2, *scrolled_window, *gtklist1, *list_item1, *text3, *handle_box;
GtkWidget *line_label;
char line_tmp[100];
#ifdef GTKEDITOR_PATCH
GList *entries;
#endif
#ifdef GTK_1_1
GtkWidget *window3;
#endif
FILE *fd, *fd2;
/* functions declarations */
#ifdef USE_BABEL
char *babel(char *str, const char *ld);
#endif
char ndcode(char trans);
void CB_import_rot13(GtkWidget *widget, GtkFileSelection *fs);
void msgbox(char *string);
void msgbox_c(GtkWidget *w, GtkWidget *e);
char *lindex(char *input_string, int word_number);
char *lrange(char *input_string, int starting_at);
void CB_msg_ok(GtkWidget *gtklist, gpointer func_data);
void print_debug(char *string);
void CB_settings_wrap(GtkWidget *widget, GtkWidget *entry);
void extract_color(GdkColor *color, unsigned red, unsigned green, unsigned blue);
gushort convert_color(unsigned c);
void CB_msg(GtkWidget *widget, GtkWidget *entry);
#ifdef GTK_1_1
void CB_sel_font(GtkWidget *widget, GtkWidget *entry);
void CB_sel_font_ok(GtkWidget *widget, GtkFontSelectionDialog *fs);
#endif
void CB_msgbox_close(GtkWidget *widget, GtkWidget *entry);
void CB_mins(GtkWidget *widget, GtkWidget *entry);
void CB_find_case(GtkWidget *widget, GtkWidget *entry);
void CB_macros(gint type, GtkWidget *entry);
void CB_indent_ok(GtkWidget *widget, GtkWidget *entry);
void CB_say_file_ok(GtkWidget *widget, GtkFileSelection *fs);
void CB_say_file(GtkWidget *widget, GtkWidget *entry);
void CB_say_current(GtkWidget *widget, GtkWidget *entry);
char *html_to_text(char buf[]);
void update_last_files(char *file);
void CB_find_ok(GtkWidget *widget, GtkWidget *entry);
void CB_ftp_put(GtkWidget *widget, GtkWidget *entry);
void CB_ftp_put_ok(GtkWidget *widget, GtkWidget *entry);
void CB_man(gint what, GtkWidget *entry);
void CB_insert(gint what, GtkWidget *entry);
void CB_HTML(gint what, GtkWidget *entry);
void CB_HTML_0(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_1(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_styles(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_2(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_3(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_4(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_5(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_6(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_7(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_8(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_9(GtkWidget *widget, GtkWidget *entry);
void CB_HTML_10(GtkWidget *widget, GtkWidget *entry);
void CB_reply(GtkWidget *widget, GtkWidget *entry);
void CB_files_xfm(GtkWidget *widget, GtkWidget *entry);
void CB_settings_apps(GtkWidget *widget, GtkWidget *entry);
void CB_save_undo();
void CB_tail_cancel_ok(GtkWidget *widget, GtkWidget *event);
void tail_cancel();
void CB_bookmarks(gint type, GtkWidget *entry);
void run_script(char *file);
void CB_project_new(GtkWidget *widget, GtkWidget *entry);
void CB_mysql(GtkWidget *widget, GtkEntry *entry);
void CB_mysql_ok(GtkWidget *widget, GtkEntry *entry);
void CB_project_open(GtkWidget *widget, GtkWidget *entry);
void CB_project_edit(GtkWidget *widget, GtkWidget *entry);
void CB_sysinfo(GtkWidget *widget, GtkWidget *entry);
void CB_project_add(GtkWidget *widget, GtkWidget *entry);
void CB_project_file(GtkWidget *widget, GtkWidget *entry);
void CB_open_hex_ok(GtkWidget *widget, GtkFileSelection *fs);
void CB_open_hex(GtkWidget *widget, GtkWidget *entry);
void convert_to_hex(char *str);
void CB_project_open_ok2(char *prj);
void CB_open_ok(GtkWidget *widget, GtkFileSelection *fs);
void CB_edit_ok(GtkWidget *widget, GtkFileSelection *fs);
void CB_bookmarks_add(GtkWidget *widget, GtkWidget *entry);
void CB_bookmarks_del(GtkWidget *widget, GtkWidget *entry);
void CB_ref_close(GtkWidget *widget, GtkWidget *entry);
void tail_loop(GtkWidget *widget, GtkWidget *entry);
void open_file(char *file, char *errmsg);
void delete_note(GtkWidget *widget, GtkWidget *event);
void create_note(FILE *nd);
void CB_undo(GtkWidget *widget, GtkWidget *entry);
void CB_agenda_cal(GtkWidget *widget, GtkWidget *entry);
void CB_awk_callbacks(gint type, GtkWidget *entry);
void CB_encrypt_ok(GtkWidget *widget, GtkWidget *entry);
void CB_encrypt(GtkWidget *widget, GtkWidget *entry);
void CB_decrypt_ok(GtkWidget *widget, GtkFileSelection *fs);
void CB_decrypt_1(GtkWidget *widget, GtkWidget *entry);
void CB_decrypt(GtkWidget *widget, GtkWidget *entry);
void CB_mirror_server(GtkWidget *widget, GtkWidget *entry);
void CB_mirror_client_loop(int sockfd, GtkWidget *entry);
void CB_mirror_close(GtkWidget *widget, GtkWidget *entry);
void CB_mirror_client(GtkWidget *widget, GtkWidget *entry);
void CB_url_open(GtkWidget *widget, GtkWidget *event);
void CB_autosave(GtkWidget *widget, GtkWidget *entry);
void CB_new_gxedit(GtkWidget *widget, GtkWidget *entry);
void CB_insert_note(GtkWidget *widget, GtkWidget *entry);
void CB_insert_note_ok(GtkWidget *widget, GtkWidget *entry);
void CB_close_debug(GtkWidget *widget, GtkWidget *entry);
void CB_open_cancel(GtkWidget *widget, GtkFileSelection *fs);
void CB_open_last(gint type, GtkWidget *entry);
void CB_files_ok(GtkWidget *widget, GtkFileSelection *fs);
void CB_files_2(GtkWidget *widget, GtkFileSelection *fs);
void CB_ref(GtkWidget *widget, GtkWidget *entry);
void CB_files_1(gint type, GtkWidget *entry);
void CB_ispell_ok(GtkWidget *widget, GtkWidget *entry);
void CB_settings_save(GtkWidget *widget, GtkWidget *entry);
void CB_settings_icons(GtkWidget *widget, GtkWidget *entry);
void CB_settings_toolbar(GtkWidget *widget, GtkWidget *entry);
void CB_settings_reply(GtkWidget *widget, GtkWidget *entry);
void CB_settings_autosave(GtkWidget *widget, GtkWidget *entry);
void CB_settings_toolbar_full(GtkWidget *widget, GtkWidget *entry);
void CB_settings_netbar(GtkWidget *widget, GtkWidget *entry);
void CB_settings_auto_indent(GtkWidget *widget, GtkWidget *entry);
void CB_settings_access(GtkWidget *widget, GtkWidget *entry);
void CB_settings_audio(GtkWidget *widget, GtkWidget *entry);
void CB_settings_debug(GtkWidget *widget, GtkWidget *entry);
void CB_settings_tooltips(GtkWidget *widget, GtkWidget *entry);
void CB_settings_last_files(GtkWidget *widget, GtkWidget *entry);
void CB_settings_sticky_dir(GtkWidget *widget, GtkWidget *entry);
void CB_settings_rc(GtkWidget *widget, GtkWidget *entry);
void CB_run_ok(GtkWidget *widget, GtkWidget *entry);
void CB_print_ok(GtkWidget *widget, GtkWidget *entry);
void CB_open_news_list(GtkWidget *widget, GtkWidget *entry);
void CB_open_article_ok(GtkWidget *gtklist, gpointer func_data);
void CB_open_news_ok(GtkWidget *widget, GtkWidget *entry);
void CB_news_post_ok(GtkWidget *widget, GtkWidget *entry);
void CB_grep_ok2(GtkWidget *widget, GtkFileSelection *fs);
void CB_grep_ok(GtkWidget *widget, GtkWidget *entry);
void CB_grep(GtkWidget *widget, GtkWidget *entry);
void CB_goto_ok(GtkWidget *widget, GtkWidget *entry);
char *base_change(int base, int i);
void CB_goto(GtkWidget *widget, GtkWidget *entry);
void CB_news_post(GtkWidget *widget, GtkWidget *entry);
void CB_application(GtkWidget *blah, gint type);
void CB_open_news(GtkWidget *widget, GtkWidget *entry);
void CB_history(GtkWidget *widget, gpointer data);
void CB_open_article(GtkWidget *widget, GtkWidget *entry);
void CB_opennet_ok(GtkWidget *widget, GtkWidget *entry);
void CB_opennet_convert(GtkWidget *widget, GtkWidget *entry);
void CB_opennet(GtkWidget *widget, GtkWidget *entry);
void CB_print(GtkWidget *widget, GtkWidget *entry);
void CB_run_bg(GtkWidget *widget, GtkWidget *entry);
void CB_run_xterm(GtkWidget *widget, GtkWidget *entry);
void CB_exit_ok(GtkWidget *widget, GtkWidget *entry);
void CB_open_ok(GtkWidget *widget, GtkFileSelection *fs);
void CB_about_close(GtkWidget *widget, GtkWidget *entry);
void CB_open_window_ok(GtkWidget *widget, GtkFileSelection *fs);
void CB_open_window(GtkWidget *widget, GtkWidget *entry);
void CB_open_mail_ok(GtkWidget *gtklist, gpointer func_data);
void CB_open_mail(GtkWidget *widget, GtkWidget *entry);
void CB_agenda_open(GtkWidget *widget, GtkWidget *entry);
void CB_agenda_save(GtkWidget *widget, GtkWidget *entry);
void CB_agenda(gint type, GtkWidget *entry);
void CB_import_ps(GtkWidget *widget, GtkFileSelection *fs);
void CB_import_rtf(GtkWidget *widget, GtkFileSelection *fs);
void CB_import_man(GtkWidget *widget, GtkFileSelection *fs);
void CB_import(gint type, GtkWidget *entry);
void CB_emacs(GtkWidget *widget, GtkWidget *entry);
void CB_links_ok(GtkWidget *widget, GtkWidget *entry);
void CB_links_in(GtkWidget *widget, GtkWidget *entry);
void CB_netscape(GtkWidget *widget, GtkWidget *entry);
void CB_vi(GtkWidget *widget, GtkWidget *entry);
void CB_settings_scroll_loc(GtkWidget *widget, GtkWidget *entry);
void CB_saveas_cancel(GtkWidget *widget, GtkFileSelection *fs);
void CB_saveas_ok(GtkWidget *widget, GtkFileSelection *fs);
void CB_email_ok(GtkWidget *widget, GtkWidget *entry);
void CB_email(GtkWidget *widget, GtkWidget *entry);
void CB_about(GtkWidget *widget, GtkWidget *entry);
void set_defaults();
void parse_rc();
int main(int argc, char *argv[]);
void read_cfg();
void make_cfg();
void make_gui();
/* net */
#ifdef USE_NET
char *resolve(char *string);
int network_fetch(char *server, char *dir, int lconvert);
int send_email(char *to, char *subject, char *attch, char *data);
int post_news(char *group, char *subject);
int list_groups();
int get_groups(char *group, char *tmp1, char *tmp2);
int get_article(char *group, char *art);
int mirror_server(char *tmp1);
int mirror_init();
int mirror_listen(char *tmp1);
#endif
void CB_new(GtkWidget *widget, gpointer data);
void CB_open(GtkWidget *widget, gpointer data);
void CB_save(GtkWidget *widget, gpointer data);
void CB_saveas(GtkWidget *widget, gpointer data);
void CB_exit(GtkWidget *widget, gpointer data);
void CB_copy(GtkWidget *widget, gpointer data);
void CB_paste(GtkWidget *widget, gpointer data);
void CB_mark(GtkWidget *widget, gpointer data);
void CB_find(GtkWidget *widget, gpointer data);
void CB_help(GtkWidget *widget, gpointer data);
void CB_settings(GtkWidget *widget, gpointer data);
void CB_spell(GtkWidget *widget, gpointer data);
void CB_awk(GtkWidget *widget, gpointer data);
void CB_run(GtkWidget *widget, gpointer data);
void CB_lines_count(GtkWidget *widget, gpointer data);
void CB_bytes_count(GtkWidget *widget, gpointer data);
void CB_words_count(GtkWidget *widget, gpointer data);
void CB_find_again(GtkWidget *widget, gpointer data);
void CB_indent(GtkWidget *widget, gpointer data);
void CB_indent_plus(GtkWidget *widget, gpointer data);
void CB_indent_minus(GtkWidget *widget, gpointer data);
