/* vi:set ts=8 sts=0 sw=8:
 * $Id: menu.c,v 1.56 2000/02/28 17:22:37 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <string.h>
#include "doc.h"
#include "undo.h"
#include "menu.h"
#include "msgbar.h"
#include "msgbox.h"
#include "about.h"
#include "toolbar.h"
#include "prefs.h"
#include "misc.h"
#ifdef APP_GNP
#include "print.h"
#include "clipboard.h"
#include "search.h"
#include "project.h"
#include "prjbar.h"
#include "htmltags.h"
#include "htmlview.h"
#include "shellcmd.h"
#include "srcctrl.h"
#endif

#include "gnpintl.h"

#ifdef USE_RECENT
#if !defined(USE_GNOME) && defined(GTK_HAVE_FEATURES_1_1_0)
static void menu_add(GtkItemFactory *menubar, char *submenupath,
		     char *newmenupath, char *accelerator,
		     GtkItemFactoryCallback callback, gpointer cbdata);
static void menu_remove(GtkItemFactory *menubar, char *menupath);
#endif
#endif	/* USE_RECENT */

#ifdef USE_GNOME
#include <gnome.h>

#ifdef USE_RECENT
#define MENU_PATH_RECENT_DOC	"_File/Open Recent.../"
#endif	/* USE_RECENT */

static void menu_set_callback_data(win_t *w, GnomeUIInfo *menu);
static void menu_gnome_setup_post1(win_t *w, GnomeUIInfo *menu);
static void menu_gnome_setup_post2(win_t *w, GnomeUIInfo *mip);


/*** local variables ***/
static GnomeUIInfo view_html_menu[] = {
	{
#ifdef USE_GTKXMHTML
		GNOME_APP_UI_ITEM,
		N_("View in XmHTML Window"),
		N_("View in XmHTML Window"),
		(gpointer)html_view_xmhtml_win_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
#endif
#ifdef USE_GTKHTML
	{
		GNOME_APP_UI_ITEM,
		N_("View in GtkHTML Window"),
		N_("View in GtkHTML Window"),
		(gpointer)html_view_gtkhtml_win_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
#endif
#ifdef USE_GTKXMHTML
	{
		GNOME_APP_UI_ITEM,
		N_("View (Xm)HTML as doc"),
		N_("View (Xm)HTML as doc"),
		(gpointer)html_view_xmhtml_doc_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
#endif
#ifdef USE_GTKXMHTML
	{
		GNOME_APP_UI_ITEM,
		N_("View (Gtk)HTML as doc"),
		N_("View (Gtk)HTML as doc"),
		(gpointer)html_view_gtkhtml_doc_cb,
		NULL, NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
#endif
	{
		GNOME_APP_UI_ITEM,
		N_("View HTML in Netscape"),
		N_("View HTML in Netscape"),
		(gpointer)html_view_browser_cb,
		NULL, NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* view_html_menu */


#ifdef USE_SOURCE_CTRL
static GnomeUIInfo scc_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("Check _In (locked)"),
		N_("Check In (locked)"),
		(gpointer)scc_checkin_locked,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Check I_n (unlocked)"),
		N_("Check In (unlocked)"),
		(gpointer)scc_checkin_unlocked,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Check In (ini_tial)"),
		N_("Check In (initial)"),
		(gpointer)scc_checkin_initial,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Check _Out (unlocked)"),
		N_("Check Out (unlocked)"),
		(gpointer)scc_checkout_unlocked,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Check Out (_locked)"),
		N_("Check Out (locked)"),
		(gpointer)scc_checkout_locked,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("_Undo Check Out"),
		N_("Undo Check Out"),
		(gpointer)scc_checkout_undo,
		NULL, NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("_Revision History"),
		N_("Revision History"),
		(gpointer)scc_rev_history,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* scc_menu */
#endif	/* USE_SOURCE_CTRL */


#ifdef USE_RECENT
static GnomeUIInfo recent_menu[] = {
	GNOMEUIINFO_END
};
#endif	/* USE_RECENT */


static GnomeUIInfo file_menu[] = {
	GNOMEUIINFO_MENU_NEW_ITEM(
		N_("_New"),
		N_("Start a new document"),
		(gpointer)doc_new_cb, NULL),

	GNOMEUIINFO_MENU_OPEN_ITEM((gpointer)doc_open_cb, NULL),
#ifdef USE_RECENT
	{
		GNOME_APP_UI_SUBTREE,
		N_("Open Recent..."),
		N_("Open recently accessed documents"),
		&recent_menu,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_OPEN
	},
#endif	/* USE_RECENT */

	{ GNOME_APP_UI_SEPARATOR },

	GNOMEUIINFO_MENU_SAVE_ITEM((gpointer)doc_save_cb, NULL),

	GNOMEUIINFO_MENU_SAVE_AS_ITEM((gpointer)doc_saveas_cb, NULL),

	GNOMEUIINFO_MENU_CLOSE_ITEM((gpointer)doc_close_cb, NULL),

	{
		GNOME_APP_UI_ITEM,
		N_("Close A_ll"),
		N_("Close all documents"),
		(gpointer)doc_close_all_cb,
		NULL, NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_CLOSE,
		0,
		GDK_CONTROL_MASK,
		NULL
	},

	{ GNOME_APP_UI_SEPARATOR },

	GNOMEUIINFO_MENU_PRINT_ITEM((gpointer)print_cb, NULL),

	{ GNOME_APP_UI_SEPARATOR },

	{
		GNOME_APP_UI_SUBTREE,
		N_("View HTML"),
		N_("View HTML"),
		&view_html_menu
	},
#ifdef USE_SOURCE_CTRL
	{ GNOME_APP_UI_SEPARATOR },

	{
		GNOME_APP_UI_SUBTREE,
		N_("Source Code Control"),
		N_("Source Code Control"),
		&scc_menu
	},
#endif
#ifdef USE_FILEINFO
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("File _Info"),
		N_("Info about current document"),
		(gpointer)doc_info_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_PIXMAP_ABOUT,
		'I',
		GDK_CONTROL_MASK,
		NULL
	},
#endif	/* USE_FILEINFO */

	{ GNOME_APP_UI_SEPARATOR },

	GNOMEUIINFO_MENU_EXIT_ITEM((gpointer)win_close_all_cb, NULL),

	GNOMEUIINFO_END
}; /* file_menu */

#if defined(USE_UNDOREDO) || defined(USE_CLIPBOARD) || \
    defined(USE_HTMLTAGS) || defined(USE_SEARCH) || defined(USE_SHELL_INSERT)
static GnomeUIInfo edit_menu[] = {
#ifdef USE_UNDOREDO
	GNOMEUIINFO_MENU_UNDO_ITEM((gpointer)undo_cb, NULL),
	GNOMEUIINFO_MENU_REDO_ITEM((gpointer)redo_cb, NULL),
	{
		GNOME_APP_UI_ITEM,
		N_("Undo All"),
		N_("Undo all changes"),
		(gpointer)undo_all_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_UNDO
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Redo All"),
		N_("Redo all undo's"),
		(gpointer)redo_all_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_REDO
	},
	{ GNOME_APP_UI_SEPARATOR },
#endif	/* USE_UNDOREDO */
#ifdef USE_CLIPBOARD
	GNOMEUIINFO_MENU_CUT_ITEM((gpointer)cut_cb, NULL),
	GNOMEUIINFO_MENU_COPY_ITEM((gpointer)copy_cb, NULL),
	GNOMEUIINFO_MENU_PASTE_ITEM((gpointer)paste_cb, NULL),
	GNOMEUIINFO_MENU_SELECT_ALL_ITEM((gpointer)selall_cb, NULL),

	{ GNOME_APP_UI_SEPARATOR },
#endif	/* USE_CLIPBOARD */
#ifdef USE_SHELL_INSERT
	{
		GNOME_APP_UI_ITEM,
		N_("_Insert Shell Output"),
		N_("Insert Shell Output"),
		(gpointer)shell_exec_read_dlg,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_BLANK,
		0,
		GDK_CONTROL_MASK,
		NULL
	},

	{ GNOME_APP_UI_SEPARATOR },
#endif	/* USE_SHELL_INSERT */

#ifdef USE_SEARCH
	GNOMEUIINFO_MENU_FIND_ITEM((gpointer)search_search_cb, NULL),
	GNOMEUIINFO_MENU_FIND_AGAIN_ITEM((gpointer)search_again_cb, NULL),
	GNOMEUIINFO_MENU_REPLACE_ITEM((gpointer)search_replace_cb, NULL),

	{ GNOME_APP_UI_SEPARATOR },

	{
		GNOME_APP_UI_ITEM,
		N_("_Goto Line #..."),
		N_("Goto Line #..."),
		(gpointer)goto_line_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_SEARCH,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
#endif	/* USE_SEARCH */
	GNOMEUIINFO_END
}; /* edit_menu */
#endif

#ifdef USE_HTMLTAGS
static GnomeUIInfo html_links_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("HyperLink"),
		N_("Insert <HREF> tag"),
		(gpointer)html_link_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Target"),
		N_("Insert <A> tag"),
		(gpointer)html_target_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Image"),
		N_("Insert <IMG> tag"),
		(gpointer)html_image_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* html_links_menu */


static GnomeUIInfo html_heading_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("Header1"),
		N_("Insert <H1> tag"),
		(gpointer)html_h1_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Header2"),
		N_("Insert <H2> tag"),
		(gpointer)html_h2_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Header3"),
		N_("Insert <H3> tag"),
		(gpointer)html_h3_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Header4"),
		N_("Insert <H4> tag"),
		(gpointer)html_h4_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Header5"),
		N_("Insert <H5> tag"),
		(gpointer)html_h5_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Header6"),
		N_("Insert <H6> tag"),
		(gpointer)html_h6_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* html_heading_menu */


static GnomeUIInfo html_layout_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("Align Left"),
		N_("Align LEFT tag"),
		(gpointer)html_left_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Align Center"),
		N_("Align RIGHT tag"),
		(gpointer)html_center_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Align Right"),
		N_("Align CENTER tag"),
		(gpointer)html_right_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Paragraph"),
		N_("Insert <P> tag"),
		(gpointer)html_paragraph_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Line Break"),
		N_("Insert <BR> tag"),
		(gpointer)html_linebreak_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Separator"),
		N_("Insert <HR> tag"),
		(gpointer)html_separator_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* html_layout_menu */


static GnomeUIInfo html_font_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("Bold"),
		N_("Insert <B> tag"),
		(gpointer)html_bold_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Italic"),
		N_("Insert <I> tag"),
		(gpointer)html_italic_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Underline"),
		N_("Insert <U> tag"),
		(gpointer)html_underline_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Typewriter"),
		N_("Insert <TT> tag"),
		(gpointer)html_typewriter_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Strikeout"),
		N_("Insert <S> tag"),
		(gpointer)html_strikeout_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Emphasis"),
		N_("Insert <EM> tag"),
		(gpointer)html_emphasis_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Strong"),
		N_("Insert <STRONG> tag"),
		(gpointer)html_strong_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Size +1"),
		N_("Font Size +1"),
		(gpointer)html_fontp1_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Size -1"),
		N_("Font Size -1"),
		(gpointer)html_fontm1_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Preformatted"),
		N_("Insert <PRE> tag"),
		(gpointer)html_preformatted_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Subscript"),
		N_("Insert <SUB> tag"),
		(gpointer)html_subscript_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Superscript"),
		N_("Insert <SUP> tag"),
		(gpointer)html_superscript_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Big"),
		N_("Insert <BIG> tag"),
		(gpointer)html_big_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Small"),
		N_("Insert <SMALL> tag"),
		(gpointer)html_small_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* html_font_menu */


static GnomeUIInfo html_list_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("Ordered List"),
		N_("Insert <OL> tag"),
		(gpointer)html_ordered_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Unordered List"),
		N_("Insert <UL> tag"),
		(gpointer)html_unordered_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("List Item"),
		N_("Insert <LI> tag"),
		(gpointer)html_listitem_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Definition List"),
		N_("Insert <DL> tag"),
		(gpointer)html_deflist_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Definition Term"),
		N_("Insert <DT> tag"),
		(gpointer)html_defterm_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Definition"),
		N_("Insert <DD> tag"),
		(gpointer)html_def_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Menu"),
		N_("Insert <MENU> tag"),
		(gpointer)html_menu_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* html_list_menu */


static GnomeUIInfo html_tables_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("New Table"),
		N_("Insert <TABLE> tag"),
		(gpointer)html_tablenew_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Table Row"),
		N_("Insert <TR> tag"),
		(gpointer)html_tablerow_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Table Header"),
		N_("Insert <TH> tag"),
		(gpointer)html_tablehdr_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Table Data"),
		N_("Insert <TD> tag"),
		(gpointer)html_tabledata_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* html_tables_menu */


static GnomeUIInfo html_frames_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("New Frame"),
		N_("Insert <FRAME> tag"),
		(gpointer)html_framenew_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Frame Set"),
		N_("Insert <FRAMESET> tag"),
		(gpointer)html_frameset_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Frame Base"),
		N_("Insert <BASE> tag"),
		(gpointer)html_framebase_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("No Frames"),
		N_("Insert <NOFRAMES> tag"),
		(gpointer)html_frameno_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* html_frames_menu */


static GnomeUIInfo html_forms_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("New Form"),
		N_("Insert <FORM> tag"),
		(gpointer)html_formnew_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Text Field"),
		N_("INPUT=\"TEXT\" tag"),
		(gpointer)html_formtfield_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Password Field"),
		N_("INPUT=\"PASSWORD\" tag"),
		(gpointer)html_formpasswd_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Text Area"),
		N_("Insert <TEXTAREA> tag"),
		(gpointer)html_formtarea_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("List Box"),
		N_("Insert <SELECT> tag"),
		(gpointer)html_formselect_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("List Item"),
		N_("Insert <OPTION> tag"),
		(gpointer)html_formoption_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Radio Button"),
		N_("INPUT=\"RADIO\" tag"),
		(gpointer)html_formradio_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Checkbox"),
		N_("INPUT=\"CHECKBOX\" tag"),
		(gpointer)html_formchkbox_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM,
		N_("Button"),
		N_("INPUT=\"BUTTON\" tag"),
		(gpointer)html_formbutton_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Image"),
		N_("INPUT=\"IMAGE\" tag"),
		(gpointer)html_formimage_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Submit"),
		N_("INPUT=\"SUBMIT\" tag"),
		(gpointer)html_formsubmit_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Reset"),
		N_("INPUT=\"CHECK\" tag"),
		(gpointer)html_formchkbox_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* html_frames_menu */


static GnomeUIInfo html_tag_case_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("Lower case Tags"),
		N_("Insert tags in LOWER case"),
		(gpointer)html_tag_lower,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Upper case Tags"),
		N_("Insert tags in UPPER case"),
		(gpointer)html_tag_upper,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
};


static GnomeUIInfo html_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("Tag Chooser"),
		N_("HTML Tag Chooser"),
		(gpointer)html_tag_chooser_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},

	{ GNOME_APP_UI_SEPARATOR },

	{
		GNOME_APP_UI_ITEM,
		N_("Title"),
		N_("Insert <TITLE> tag"),
		(gpointer)html_title_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Comment"),
		N_("Insert HTML comment"),
		(gpointer)html_comment_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},

	{ GNOME_APP_UI_SEPARATOR },

	{
		GNOME_APP_UI_SUBTREE,
		N_("Links"),
		N_("Link tags"),
		&html_links_menu
	},
	{
		GNOME_APP_UI_SUBTREE,
		N_("Heading"),
		N_("Header tags"),
		&html_heading_menu
	},
	{
		GNOME_APP_UI_SUBTREE,
		N_("Layout"),
		N_("Layout tags"),
		&html_layout_menu
	},
	{
		GNOME_APP_UI_SUBTREE,
		N_("Font"), N_("Font tags"),
		&html_font_menu
	},
	{
		GNOME_APP_UI_SUBTREE,
		N_("List"),
		N_("List tags"),
		&html_list_menu
	},
	{
		GNOME_APP_UI_SUBTREE,
		N_("Tables"),
		N_("Tables tags"),
		&html_tables_menu
	},
	{
		GNOME_APP_UI_SUBTREE,
		N_("Frames"),
		N_("Frame tags"),
		&html_frames_menu
	},
	{
		GNOME_APP_UI_SUBTREE,
		N_("Forms"),
		N_("Form tags"),
		&html_forms_menu
	},

	{ GNOME_APP_UI_SEPARATOR },

	GNOMEUIINFO_RADIOLIST(html_tag_case_menu),

	GNOMEUIINFO_END
}; /* html_menu[] */
#endif	/* USE_HTMLTAGS */


#ifdef WANT_PROJECT
static GnomeUIInfo project_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("Toggle Project Bar"),
		N_("Toggle Project Bar"),
		(gpointer)prjbar_toggle,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},

	{ GNOME_APP_UI_SEPARATOR },

	{
		GNOME_APP_UI_ITEM,
		N_("New Project"),
		N_("New Project"),
		NULL,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Open Project"),
		N_("Open Project"),
		(gpointer)prj_open_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Edit Project"),
		N_("Edit Project"),
		NULL,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Save Project"),
		N_("Save Project"),
		NULL,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Close Project"),
		N_("Close Project"),
		(gpointer)prj_close_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},

	{ GNOME_APP_UI_SEPARATOR },

	{
		GNOME_APP_UI_ITEM,
		N_("Project List"),
		N_("Project List"),
		(gpointer)prj_list_show,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("Edit a Project"),
		N_("Edit a Project"),
		NULL,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* project_menu */
#endif	/* WANT_PROJECT */

static GnomeUIInfo window_menu[] = {
#ifdef USE_DOCLIST
	{
		GNOME_APP_UI_ITEM,
		N_("_Doc List"),
		N_("Document List"),
		(gpointer)doc_list_show,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		'L',
		GDK_CONTROL_MASK,
		NULL
	},
#endif	/* USE_DOCLIST */
#ifdef WANT_MSGBOX
	{
		GNOME_APP_UI_ITEM,
		N_("_Messages"),
		N_("gnotepad+ messages"),
		(gpointer)msgbox_show,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		'M',
		GDK_CONTROL_MASK,
		NULL
	},
#endif  /* #ifdef WANT_MSGBOX */
#if defined(USE_DOCLIST) || defined(WANT_MSGBOX)
	{ GNOME_APP_UI_SEPARATOR },
#endif
#ifdef USE_WINLIST
	{
		GNOME_APP_UI_ITEM,
		N_("_Window List"),
		N_("Window list"),
		(gpointer)win_list_show,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
#endif	/* USE_WINLIST */
	{
		GNOME_APP_UI_ITEM,
		N_("_New Window"),
		N_("New Window"),
		(gpointer)win_new_with_doc,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("_Close Window"),
		N_("Close current window"),
		(gpointer)win_close_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* window_menu */


#ifdef USE_TOOLBARS
static GnomeUIInfo toolbar_style_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("Icons & Text"),
		N_("Show toolbars with icons and text"),
		(gpointer)tb_pic_text,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("_Icons Only"),
		N_("Show toolbars with icons only"),
		(gpointer)tb_pic_only,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("_Text Only"),
		N_("Show toolbar with text only"),
		(gpointer)tb_text_only,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
}; /* toolbar_style_menu */


static GnomeUIInfo toolbar_menu[] = {
	GNOMEUIINFO_TOGGLEITEM_DATA(
		N_("Main Toolbar"),
		N_("Toggle the main toolbar"),
		(gpointer)tb_toggle,
		NULL, NULL),

#ifdef USE_HTMLTAGS
	GNOMEUIINFO_TOGGLEITEM_DATA(
		N_("HTML Toolbar"),
		N_("Toggle the HTML toolbar"),
		(gpointer)tb_html_toggle,
		NULL, NULL),

	{ GNOME_APP_UI_SEPARATOR },
#endif

	GNOMEUIINFO_TOGGLEITEM_DATA(
		N_("Raised Buttons"),
		N_("Toggle raised/flat buttons"),
		(gpointer)tb_raised_toggle,
		NULL, NULL),
	GNOMEUIINFO_TOGGLEITEM_DATA(
		N_("Show Tooltips"),
		N_("Show tooltips"),
		(gpointer)tb_ttip_toggle,
		NULL, NULL),

	{ GNOME_APP_UI_SEPARATOR },

	GNOMEUIINFO_RADIOLIST((gpointer)toolbar_style_menu),

	GNOMEUIINFO_END
}; /* toolbar_menu */
#endif	/* USE_TOOLBARS */


static GnomeUIInfo doctab_pos_menu[] = {
	{
		GNOME_APP_UI_ITEM,
		N_("_Top"),
		N_("Document tabs to the top"),
		(gpointer)win_dtab_top,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("_Bottom"),
		N_("Document tabs to the bottom"),
		(gpointer)win_dtab_bot,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("_Left"),
		N_("Document tabs to the left"),
		(gpointer)win_dtab_left,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("_Right"),
		N_("Document tabs to the right"),
		(gpointer)win_dtab_right,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE,
		NULL,
		0,
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
};

static GnomeUIInfo doctab_menu[] = {
	GNOMEUIINFO_TOGGLEITEM_DATA(
		N_("Toggle Doc Tabs"),
		N_("Toggle document tabs on/off"),
		(gpointer)win_dtab_toggle,
		NULL, NULL),

	{ GNOME_APP_UI_SEPARATOR },

	GNOMEUIINFO_RADIOLIST(doctab_pos_menu),

	GNOMEUIINFO_END
}; /* doctab_menu */

static GnomeUIInfo options_menu[] = {
	GNOMEUIINFO_TOGGLEITEM_DATA(
		N_("Message Bar"),
		N_("Toggle message bar on/off"),
		(gpointer)msgbar_toggle,
		NULL, NULL),
	GNOMEUIINFO_TOGGLEITEM_DATA(
		N_("Use Wordwrap"),
		N_("Toggle wordwrap on/off"),
		(gpointer)win_wwrap_toggle,
		NULL, NULL),
	{
		GNOME_APP_UI_SUBTREE,
		N_("Doc Tabs"),
		N_("Doc tabs options"),
		&doctab_menu
	},
#ifdef USE_TOOLBARS
	{
		GNOME_APP_UI_SUBTREE,
		N_("Toolbar"),
		N_("Toolbar options"),
		&toolbar_menu
	},
#endif	/* USE_TOOLBARS */

	{ GNOME_APP_UI_SEPARATOR },

	GNOMEUIINFO_MENU_PREFERENCES_ITEM((gpointer)prefs_cb, NULL),
	GNOMEUIINFO_END
}; /* options_menu */

static GnomeUIInfo help_menu[] = {
	GNOMEUIINFO_HELP(APP_NAME),
	GNOMEUIINFO_MENU_ABOUT_ITEM((gpointer)about_cb, NULL),
	GNOMEUIINFO_END
}; /* help_menu */

static GnomeUIInfo main_menu[] = {
	{
		GNOME_APP_UI_SUBTREE,
		N_("_File"),
		N_("File commands"),
		&file_menu,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE
	},
#if defined(USE_UNDOREDO) || defined(USE_CLIPBOARD) || \
    defined(USE_SEARCH) || defined(USE_SHELL_INSERT)
	{
		GNOME_APP_UI_SUBTREE,
		N_("_Edit"),
		N_("Editing commands"),
		&edit_menu,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE
	},
#endif
#ifdef USE_HTMLTAGS
	{
		GNOME_APP_UI_SUBTREE,
		N_("H_TML"),
		N_("Insert HTML Tags"),
		&html_menu,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE
	},
#endif
	{
		GNOME_APP_UI_SUBTREE,
		N_("_Window"),
		N_("Window commands"),
		&window_menu,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE
	},
#ifdef WANT_PROJECT
	{
		GNOME_APP_UI_SUBTREE,
		N_("_Project"),
		N_("Project commands"),
		&project_menu,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE
	},
#endif
	{
		GNOME_APP_UI_SUBTREE,
		N_("_Options"),
		N_("Options"),
		&options_menu,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE
	},
	{
		GNOME_APP_UI_SUBTREE,
		N_("_Help"),
		N_("Help"),
		&help_menu,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_NONE
	},
	GNOMEUIINFO_END
}; /* main_menu */

#else

#ifdef GTK_HAVE_FEATURES_1_1_0

#ifdef USE_RECENT
#define MENU_PATH_RECENT_DOC	"/File/Open Recent.../"
#endif	/* USE_RECENT */

static GtkItemFactoryEntry mainmenu[] = {
	{
		"/_File",
		NULL, NULL, 0, "<Branch>"
	},
	{
		"/File/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/File/_New",
		"<control>N",
		(GtkItemFactoryCallback)doc_new_cb
	},
	{
		N_("/File/_Open..."),
		"F3",
		(GtkItemFactoryCallback)doc_open_cb
	},
#ifdef USE_RECENT
	{ MENU_PATH_RECENT_DOC },
	{
		"/File/Open Recent.../tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/File/sep1",
		NULL, NULL, 0, "<Separator>"
	},
#endif	/* USE_RECENT */
#ifdef APP_GNP
	{
		N_("/File/_Save"),
		"<control>S",
		(GtkItemFactoryCallback)doc_save_cb
	},
	{
		N_("/File/S_ave As..."),
		NULL,
		(GtkItemFactoryCallback)doc_saveas_cb
	},
#endif
	{
		N_("/File/_Close"),
		"<control>W",
		(GtkItemFactoryCallback)doc_close_cb
	},
	{
		"/File/Close A_ll",
		NULL,
		(GtkItemFactoryCallback)doc_close_all_cb
	},
#ifdef APP_GNP
	{
		"/File/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		N_("/File/_Print..."),
		"<control>P",
		(GtkItemFactoryCallback)print_cb
	},
	{
		"/File/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/File/View HTML/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
#ifdef USE_GTKXMHTML
	{
		N_("/File/View HTML/With HTML window"),
		NULL,
		(GtkItemFactoryCallback)html_view_cb,
		HtmlViewXmHtml
	},
	{
		N_("/File/View (Xm)HTML"),
		NULL, NULL, 0, "<Branch>"
	},
	{
		N_("/File/View (Xm)HTML/As a document"),
		NULL,
		(GtkItemFactoryCallback)html_view_cb,
		HtmlViewXmHtmlDoc
	},
#endif	/* USE_GTKXMHTML */
	{
		N_("/File/View HTML/In Netscape"),
		NULL,
		(GtkItemFactoryCallback)html_view_cb,
		HtmlViewBrowser
	},
#endif	/* APP_GNP */
#ifdef USE_SOURCE_CTRL
	{
		"/File/sep1",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/File/Source Code Control/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/File/Source Code Control/Check _In (locked)",
		NULL,
		(GtkItemFactoryCallback)scc_menu_cb,
		SCC_CI_LOCK
	},
	{
		"/File/Source Code Control/Check I_n (unlocked)",
		NULL,
		(GtkItemFactoryCallback)scc_menu_cb,
		SCC_CI_UNLOCK
	},
	{
		"/File/Source Code Control/Check In (ini_tial)",
		NULL,
		(GtkItemFactoryCallback)scc_menu_cb,
		SCC_CI_INIT
	},
	{
		"/File/Source Code Control/Check _Out (unlocked)",
		NULL,
		(GtkItemFactoryCallback)scc_menu_cb,
		SCC_CO_UNLOCK
	},
	{
		"/File/Source Code Control/Check Out (_locked)",
		NULL,
		(GtkItemFactoryCallback)scc_menu_cb,
		SCC_CO_LOCK
	},
	{
		"/File/Source Code Control/_Undo Check Out",
		NULL,
		(GtkItemFactoryCallback)scc_menu_cb,
		SCC_CO_UNDO
	},
	{
		"/File/Source Code Control/_Revision History",
		NULL,
		(GtkItemFactoryCallback)scc_menu_cb,
		SCC_REVHIST
	},
#endif
#ifdef USE_FILEINFO
	{
		"/File/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/File/File _Info",
		"<control>I",
		(GtkItemFactoryCallback)doc_info_cb
	},
#endif	/* USE_FILEINFO */
	{
		"/File/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		N_("/File/E_xit"),
		"<control>Q",
		(GtkItemFactoryCallback)win_close_all_cb
	},

#if defined(USE_UNDOREDO) || defined(USE_CLIPBOARD) || \
    defined(USE_SEARCH) || defined(USE_SHELL_INSERT)
#ifdef APP_GNP
	{
		"/_Edit",
		NULL, NULL, 0, "<Branch>"
	},
	{
		"/Edit/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
#ifdef USE_UNDOREDO
	{
		N_("/Edit/_Undo"),
		"<control>Z",
		(GtkItemFactoryCallback)undo_cb
	},
	{
		N_("/Edit/_Redo"),
		"<control>R",
		(GtkItemFactoryCallback)redo_cb
	},
	{
		"/Edit/Undo All",
		NULL,
		(GtkItemFactoryCallback)undo_all_cb
	},
	{
		"/Edit/Redo All",
		NULL,
		(GtkItemFactoryCallback)redo_all_cb
	},
	{
		"/Edit/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
#endif	/* USE_UNDOREDO */

#ifdef USE_CLIPBOARD
	{
		N_("/Edit/C_ut"),
		"<control>X",
		(GtkItemFactoryCallback)cut_cb
	},
	{
		N_("/Edit/_Copy"),
		"<control>C",
		(GtkItemFactoryCallback)copy_cb
	},
	{
		N_("/Edit/_Paste"),
		"<control>V",
		(GtkItemFactoryCallback)paste_cb
	},
	{
		N_("/Edit/_Select All"),
		"<control>A",
		(GtkItemFactoryCallback)selall_cb
	},
	{
		"/Edit/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
#endif	/* USE_CLIPBOARD */
#ifdef USE_SHELL_INSERT
	{
		"/Edit/_Insert Shell Output",
		NULL,
		(GtkItemFactoryCallback)shell_exec_read_dlg
	},
#endif	/* USE_SHELL_INSERT */
#ifdef USE_SEARCH
	{
		"/Edit/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		N_("/Edit/_Find..."),
		"F6",
		(GtkItemFactoryCallback)search_cb,
		Find
	},
	{
		N_("/Edit/Find _Again"),
		"<shift>F6",
		(GtkItemFactoryCallback)search_again_cb,
		Again
	},
	{
		N_("/Edit/_Replace..."),
		"F7",
		(GtkItemFactoryCallback)search_cb,
		Replace
	},
	{
		"/Edit/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/Edit/_Goto Line #...",
		NULL,
		(GtkItemFactoryCallback)search_cb,
		GotoLine
	},
#endif	/* USE_SEARCH */
#endif	/* APP_GNP */
#endif

#ifdef USE_HTMLTAGS
	{
		N_("/H_TML"),
		NULL, NULL, 0, "<Branch>"
	},
	{
		"/HTML/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/HTML/Tag Chooser",
		NULL,
		(GtkItemFactoryCallback)html_tag_chooser_cb
	},

	{
		"/HTML/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Title",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlTtl
	},
	{
		"/HTML/Comment",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlCmnt
	},
	{
		"/HTML/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Links/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/HTML/Links/HyperLink",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlLink
	},
	{
		"/HTML/Links/Target",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlTarg
	},
	{
		"/HTML/Links/Image",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlImg
	},
	{
		"/HTML/Heading/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/HTML/Heading/Header1",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlH1
	},
	{
		"/HTML/Heading/Header2",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlH2
	},
	{
		"/HTML/Heading/Header3",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlH3
	},
	{
		"/HTML/Heading/Header4",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlH4
	},
	{
		"/HTML/Heading/Header5",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlH5
	},
	{
		"/HTML/Heading/Header6",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlH6
	},
	{
		"/HTML/Layout/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/HTML/Layout/Align Left",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlLeft
	},
	{
		"/HTML/Layout/Align Center",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlCent
	},
	{
		"/HTML/Layout/Align Right",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlRght
	},
	{
		"/HTML/Layout/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Layout/Paragraph",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlPara
	},
	{
		"/HTML/Layout/Line Break",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlLbrk
	},
	{
		"/HTML/Layout/Separator",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlSep
	},
	{
		"/HTML/Font/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/HTML/Font/Bold",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlBold
	},
	{
		"/HTML/Font/Italic",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlItal
	},
	{
		"/HTML/Font/Underline",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlUlne
	},
	{
		"/HTML/Font/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Font/Typewriter",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlTty
	},
	{
		"/HTML/Font/Strikeout",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlStrk
	},
	{
		"/HTML/Font/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Font/Emphasis",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlEmph
	},
	{
		"/HTML/Font/Strong",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlStrg
	},
	{
		"/HTML/Font/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Font/Size +1",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFontP
	},
	{
		"/HTML/Font/Size -1",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFontM
	},
	{
		"/HTML/Font/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Font/Preformatted",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlPre
	},
	{
		"/HTML/Font/Subscript",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlSub
	},
	{
		"/HTML/Font/Superscript",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlSup
	},
	{
		"/HTML/Font/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Font/Big",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlBig
	},
	{
		"/HTML/Font/Small",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlSmll
	},
	{
		"/HTML/List/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/HTML/List/Ordered List",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlOrdr
	},
	{
		"/HTML/List/Unordered List",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlUord
	},
	{
		"/HTML/List/List Item",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlLitm
	},
	{
		"/HTML/List/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/List/Definition List",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlDefList
	},
	{
		"/HTML/List/Definition Term",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlDefTerm
	},
	{
		"/HTML/List/Definition",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlDef
	},
	{
		"/HTML/List/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/List/Menu",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlMenu
	},
	{
		"/HTML/Tables/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
#if 0
	{
		"/HTML/Tables/Wizard",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlTblWiz
	},
	{
		"/HTML/Tables/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
#endif
	{
		"/HTML/Tables/New Table",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlTblNew
	},
	{
		"/HTML/Tables/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Tables/Table Row",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlTblRow
	},
	{
		"/HTML/Tables/Table Header",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlTblHdr
	},
	{
		"/HTML/Tables/Table Data",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlTblData
	},
	{
		"/HTML/Frames/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/HTML/Frames/New Frame",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFrameNew
	},
	{
		"/HTML/Frames/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Frames/Frame Set",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFrameSet
	},
	{
		"/HTML/Frames/Frame Base",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFrameBase
	},
	{
		"/HTML/Frames/No Frames",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFrameNo
	},
	{
		"/HTML/Forms/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/HTML/Forms/New Form",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormNew
	},
	{
		"/HTML/Forms/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Forms/Text Field",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormTfield
	},
	{
		"/HTML/Forms/Password Field",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormPass
	},
	{
		"/HTML/Forms/Text Area",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormTarea
	},
	{
		"/HTML/Forms/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Forms/List Box",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormSel
	},
	{
		"/HTML/Forms/List Item",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormOpt
	},
	{
		"/HTML/Forms/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Forms/Radio Button",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormRadio
	},
	{
		"/HTML/Forms/Checkbox",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormChk
	},
	{
		"/HTML/Forms/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Forms/Button",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormBtn
	},
	{
		"/HTML/Forms/Image",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormImg
	},
	{
		"/HTML/Forms/Submit",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormSubmit
	},
	{
		"/HTML/Forms/Reset",
		NULL,
		(GtkItemFactoryCallback)html_menu_cb,
		HtmlFormReset
	},
	{
		"/HTML/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/HTML/Lower case tags",
		NULL,
		(GtkItemFactoryCallback)html_tag_lower,
		0, "<RadioItem>"
	},
	{
		"/HTML/Upper case tags",
		NULL,
		(GtkItemFactoryCallback)html_tag_upper,
		0, "<RadioItem>"
	},
#endif	/* USE_HTMLTAGS */

#if defined(WANT_PROJECT) && defined(APP_GNP)
	{
		"/_Project",
		NULL, NULL, 0, "<Branch>"
	},
	{
		"/Project/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		N_("/Project/Toggle _Project Bar"),
		NULL,
		(GtkItemFactoryCallback)prjbar_toggle
	},
	{
		"/Project/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		N_("/Project/_New Project") },
	{
		N_("/Project/_Open Project"),
		NULL,
		(GtkItemFactoryCallback)prj_open_cb
	},
	{
		N_("/Project/_Edit Project") },
	{
		N_("/Project/_Save Project") },
	{
		N_("/Project/_Close Project"),
		NULL,
		(GtkItemFactoryCallback)prj_close_cb
	},
	{
		"/Project/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		N_("/Project/Current Project _Info") },
	{
		N_("/Project/Project _List"),
		NULL,
		(GtkItemFactoryCallback)prj_list_show
	},
	{
		N_("/Project/Edit _A Project") },
#endif	/* WANT_PROJECT */

	{
		"/_Window",
		NULL, NULL, 0, "<Branch>"
	},
	{
		"/Window/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
#ifdef USE_DOCLIST
	{
		"/Window/_Doc List",
		"<control>L",
		(GtkItemFactoryCallback)doc_list_show
	},
#endif	/* USE_DOCLIST */
#ifdef WANT_MSGBOX
	{
		"/Window/_Messages",
		"<control>M",
		(GtkItemFactoryCallback)msgbox_show
	},
#endif  /* #ifdef WANT_MSGBOX */
#if defined(USE_DOCLIST) || defined(WANT_MSGBOX)
	{
		"/Window/<sep1>",
		NULL, NULL, 0, "<Separator>"
	},
#endif
#ifdef USE_WINLIST
	{
		"/Window/_Window List",
		NULL,
		(GtkItemFactoryCallback)win_list_show
	},
#endif	/* USE_WINLIST */
	{
		"/Window/_New Window",
		NULL,
		(GtkItemFactoryCallback)win_new_with_doc
	},
	{
		"/Window/_Close Window",
		NULL,
		(GtkItemFactoryCallback)win_close_cb
	},

	{
		"/_Options",
		NULL, NULL, 0, "<Branch>"
	},
	{
		"/Options/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/Options/Message Bar",
		NULL,
		(GtkItemFactoryCallback)msgbar_toggle,
		0, "<ToggleItem>"
	},
#ifdef APP_GNP
	{
		N_("/Options/Wordwrap"),
		NULL,
		(GtkItemFactoryCallback)win_wwrap_toggle,
		0, "<ToggleItem>"
	},
#endif
	{
		"/Options/Doc Tabs/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		N_("/Options/Doc Tabs/Use Tabs"),
		NULL,
		(GtkItemFactoryCallback)win_dtab_toggle,
		0, "<ToggleItem>"
	},
	{
		"/Options/Doc Tabs/<separator>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/Options/Doc Tabs/Top",
		NULL,
		(GtkItemFactoryCallback)win_dtab_top,
		0, "<RadioItem>"
	},
	{
		"/Options/Doc Tabs/Bottom",
		NULL,
		(GtkItemFactoryCallback)win_dtab_bot,
		0, "<RadioItem>"
	},
	{
		"/Options/Doc Tabs/Left",
		NULL,
		(GtkItemFactoryCallback)win_dtab_left,
		0, "<RadioItem>"
	},
	{
		"/Options/Doc Tabs/Right",
		NULL,
		(GtkItemFactoryCallback)win_dtab_right,
		0, "<RadioItem>"
	},
#ifdef USE_TOOLBARS
	{
		"/Options/Toolbar/tearoff1",
		NULL, NULL, 0, "<Tearoff>"
	},
	{
		"/Options/Toolbar/Main Toolbar",
		NULL,
		(GtkItemFactoryCallback)tb_toggle,
		0, "<ToggleItem>"
	},
#if defined(APP_GNP) && defined(USE_HTMLTAGS)
	{
		"/Options/Toolbar/HTML Toolbar",
		NULL,
		(GtkItemFactoryCallback)tb_html_toggle,
		0, "<ToggleItem>"
	},
#endif
	{
		"/Options/Toolbar/<separator>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/Options/Toolbar/Raised Buttons",
		NULL,
		(GtkItemFactoryCallback)tb_raised_toggle,
		0, "<ToggleItem>"
	},
	{
		N_("/Options/Toolbar/Tooltips"),
		NULL,
		(GtkItemFactoryCallback)tb_ttip_toggle,
		0, "<ToggleItem>"
	},
	{
		"/Options/Toolbar/<separator>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		"/Options/Toolbar/Icons & Text",
		NULL,
		(GtkItemFactoryCallback)tb_pic_text,
		0, "<RadioItem>"
	},
	{
		N_("/Options/Toolbar/Icons Only"),
		NULL,
		(GtkItemFactoryCallback)tb_pic_only,
		0, "<RadioItem>"
	},
	{
		"/Options/Toolbar/Text Only",
		NULL,
		(GtkItemFactoryCallback)tb_text_only,
		0, "<RadioItem>"
	},
#endif	/* USE_TOOLBARS */
	{
		"/Options/<separator>",
		NULL, NULL, 0, "<Separator>"
	},
	{
		N_("/Options/_Preferences..."),
		NULL,
		(GtkItemFactoryCallback)prefs_cb
	},

	{
		"/_Help",
		NULL, NULL, 0, "<LastBranch>" },
	{
		N_("/Help/_About gnotepad+"),
		NULL,
		(GtkItemFactoryCallback)about_cb
	}
}; /* mainmenu[] */

#else	/* GTK 1.0.x */

#ifdef USE_RECENT
#define MENU_PATH_RECENT_DOC	"<Main>/File/Open Recent.../"

static void menu_add(GtkMenuFactory *menubar, char *submenupath,
	char *newmenupath, char *accel, GtkMenuCallback cb, gpointer cbdata);
static void menu_remove(GtkMenuFactory *menubar, char *menupath);
#endif	/* USE_RECENT */

static GtkMenuEntry mainmenu[] = {
	{
		"<Main>/File/New", 
		"<control>N", 
		doc_new_cb
	},
	{
		"<Main>/File/Open...",
		"<control>O",
		doc_open_cb
	},
#ifdef USE_RECENT
	{
		MENU_PATH_RECENT_DOC
	},
	{
		"<Main>/File/<separator>"
	},
#endif	/* USE_RECENT */
	{
		"<Main>/File/Save",
		"<control>S",
		doc_save_cb
	},
	{
		"<Main>/File/Save As...",
		NULL,
		doc_saveas_cb
	},
	{
		"<Main>/File/Close",
		"<control>W",
		doc_close_cb
	},
	{
		"<Main>/File/Close All",
		NULL,
		doc_close_all_cb
	},
	{
		"<Main>/File/<separator>"
	},
	{
		"<Main>/File/Print...",
		"<control>P",
		print_cb
	},
#ifdef USE_SOURCE_CTRL
	{
		"<Main>/File/<separator>"
	},
	{
		"<Main>/File/Source Code Control/Check In (locked)",
		NULL,
		scc_checkin_locked 
	},
	{
		"<Main>/File/Source Code Control/Check In (unlocked)",
		NULL,
		scc_checkin_unlocked 
	},
	{
		"<Main>/File/Source Code Control/Check In (initial)",
		NULL,
		scc_checkin_initial 
	},
	{
		"<Main>/File/Source Code Control/Check Out (unlocked)",
		NULL,
		scc_checkout_unlocked 
	},
	{
		"<Main>/File/Source Code Control/Check Out (locked)",
		NULL,
		scc_checkout_locked 
	},
	{
		"<Main>/File/Source Code Control/Undo Check Out",
		NULL,
		scc_checkout_undo 
	},
	{
		"<Main>/File/Source Code Control/Revision History",
		NULL,
		scc_rev_history 
	},
#endif	/* USR_SRCCTRL */
#ifdef USE_FILEINFO
	{
		"<Main>/File/<separator>"
	},
	{
		"<Main>/File/File Info",
		"<control>I",
		doc_info_cb
	},
#endif	/* USE_FILEINFO */
	{
		"<Main>/File/<separator>"
	},
	{
		"<Main>/File/Exit",
		"<control>Q",
		win_close_all_cb
	},

#if defined(USE_UNDOREDO) || defined(USE_CLIPBOARD) || \
    defined(USE_HTMLTAGS) || defined(USE_SEARCH) || defined(USE_SHELL_INSERT)
# ifdef APP_GNP
#  ifdef USE_CLIPBOARD
	{
		"<Main>/Edit/Cut",
		"<control>X",
		cut_cb
	},
	{
		"<Main>/Edit/Copy",
		"<control>C",
		copy_cb
	},
	{
		"<Main>/Edit/Paste",
		"<control>V",
		paste_cb
	},
	{
		"<Main>/Edit/Select All",
		"<control>A",
		selall_cb
	},
	{
		"<Main>/Edit/<separator>"
	},
#  endif	/* USE_CLIPBOARD */
#  ifdef USE_SHELL_INSERT
	{
		"<Main>/Edit/Insert Shell Output",
		NULL,
		shell_exec_read_dlg 
	},
#  endif	/* USE_SHELL_INSERT */
#  ifdef USE_HTMLTAGS
	{
		"<Main>/Edit/<separator>"
	},
	{
		"<Main>/Edit/Insert HTML/Title",
		NULL,
		html_title_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Comment",
		NULL,
		html_comment_cb 
	},
	{
		"<Main>/Edit/Insert HTML/<separator>"
	},
	{
		"<Main>/Edit/Insert HTML/Links/HyperLink",
		NULL,
		html_link_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Links/Target",
		NULL,
		html_target_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Links/Image",
		NULL,
		html_image_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Heading/Header1",
		NULL,
		html_h1_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Heading/Header2",
		NULL,
		html_h2_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Heading/Header3",
		NULL,
		html_h3_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Heading/Header4",
		NULL,
		html_h4_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Heading/Header5",
		NULL,
		html_h5_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Heading/Header6",
		NULL,
		html_h6_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Layout/Align Center",
		NULL,
		html_center_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Layout/<separator>"
	},
	{
		"<Main>/Edit/Insert HTML/Layout/Paragraph",
		NULL,
		html_paragraph_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Layout/Line Break",
		NULL,
		html_linebreak_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Layout/Separator",
		NULL,
		html_separator_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/Bold",
		NULL,
		html_bold_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/Italic",
		NULL,
		html_italic_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/Underline",
		NULL,
		html_underline_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/<separator>"
	},
	{
		"<Main>/Edit/Insert HTML/Font/Typewriter",
		NULL,
		html_typewriter_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/Strikeout",
		NULL,
		html_strikeout_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/<separator>"
	},
	{
		"<Main>/Edit/Insert HTML/Font/Emphasis",
		NULL,
		html_emphasis_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/Strong",
		NULL,
		html_strong_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/<separator>"
	},
	{
		"<Main>/Edit/Insert HTML/Font/Subscript",
		NULL,
		html_subscript_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/Superscript",
		NULL,
		html_superscript_cb
	},
	{
		"<Main>/Edit/Insert HTML/Font/<separator>"
	},
	{
		"<Main>/Edit/Insert HTML/Font/Big",
		NULL,
		html_big_cb 
	},
	{
		"<Main>/Edit/Insert HTML/Font/Small",
		NULL,
		html_small_cb 
	},
	{
		"<Main>/Edit/Insert HTML/List/Ordered List",
		NULL,
		html_ordered_cb 
	},
	{
		"<Main>/Edit/Insert HTML/List/Unordered List",
		NULL,
		html_unordered_cb
	},
	{
		"<Main>/Edit/Insert HTML/List/List Item",
		NULL,
		html_listitem_cb 
	},
#  endif	/* USE_HTMLTAGS */
	{
		"<Main>/Edit/<separator>"
	},
# endif	/* APP_GNP */
# ifdef USE_SEARCH
	{
		"<Main>/Edit/Find...",
		"<control>F",
		search_search_cb 
	},
	{
		"<Main>/Edit/Find Again",
		"<control>G",
		search_again_cb
	},
	{
		"<Main>/Edit/Replace",
		"<control>R",
		search_replace_cb
	},
	{
		"<Main>/Edit/<separator>"
	},
	{
		"<Main>/Edit/Goto Line #...",
		NULL,
		goto_line_cb
	},
# endif	/* USE_SEARCH */
#endif

#ifdef USE_HTMLTAGS
	{
		"<Main>/HTML/Tag Chooser",
		NULL,
		html_tag_chooser_cb
	},
	{
		"<Main>/HTML/<separator>"
	},
	{
		"<Main>/HTML/Title",
		NULL,
		html_title_cb
	},
	{
		"<Main>/HTML/Comment",
		NULL,
		html_comment_cb
	},
	{
		"<Main>/HTML/<separator>"
	},
	{
		"<Main>/HTML/Links/HyperLink",
		NULL,
		html_link_cb
	},
	{
		"<Main>/HTML/Links/Target",
		NULL,
		html_target_cb
	},
	{
		"<Main>/HTML/Links/Image",
		NULL,
		html_image_cb
	},
	{
		"<Main>/HTML/Heading/Header1",
		NULL,
		html_h1_cb
	},
	{
		"<Main>/HTML/Heading/Header2",
		NULL,
		html_h2_cb
	},
	{
		"<Main>/HTML/Heading/Header3",
		NULL,
		html_h3_cb
	},
	{
		"<Main>/HTML/Heading/Header4",
		NULL,
		html_h4_cb
	},
	{
		"<Main>/HTML/Heading/Header5",
		NULL,
		html_h5_cb
	},
	{
		"<Main>/HTML/Heading/Header6",
		NULL,
		html_h6_cb
	},
	{
		"<Main>/HTML/Layout/Align Left",
		NULL,
		html_left_cb
	},
	{
		"<Main>/HTML/Layout/Align Center",
		NULL,
		html_center_cb
	},
	{
		"<Main>/HTML/Layout/Align Right",
		NULL,
		html_right_cb
	},
	{
		"<Main>/HTML/Layout/<separator>"
	},
	{
		"<Main>/HTML/Layout/Paragraph",
		NULL,
		html_paragraph_cb
	},
	{
		"<Main>/HTML/Layout/Line Break",
		NULL,
		html_linebreak_cb
	},
	{
		"<Main>/HTML/Layout/Separator",
		NULL,
		html_separator_cb
	},
	{
		"<Main>/HTML/Font/Bold",
		NULL,
		html_bold_cb
	},
	{
		"<Main>/HTML/Font/Italic",
		NULL,
		html_italic_cb
	},
	{
		"<Main>/HTML/Font/Underline",
		NULL,
		html_underline_cb
	},
	{
		"<Main>/HTML/Font/<separator>"
	},
	{
		"<Main>/HTML/Font/Typewriter",
		NULL,
		html_typewriter_cb
	},
	{
		"<Main>/HTML/Font/Strikeout",
		NULL,
		html_strikeout_cb
	},
	{
		"<Main>/HTML/Font/<separator>"
	},
	{
		"<Main>/HTML/Font/Emphasis",
		NULL,
		html_emphasis_cb
	},
	{
		"<Main>/HTML/Font/Strong",
		NULL,
		html_strong_cb
	},
	{
		"<Main>/HTML/Font/<separator>"
	},
	{
		"<Main>/HTML/Font/Size +1",
		NULL,
		html_fontp1_cb
	},
	{
		"<Main>/HTML/Font/Size -1",
		NULL,
		html_fontm1_cb
	},
	{
		"<Main>/HTML/Font/<separator>"
	},
	{
		"<Main>/HTML/Font/Preformatted",
		NULL,
		html_preformatted_cb
	},
	{
		"<Main>/HTML/Font/Subscript",
		NULL,
		html_subscript_cb
	},
	{
		"<Main>/HTML/Font/Superscript",
		NULL,
		html_superscript_cb
	},
	{
		"<Main>/HTML/Font/<separator>"
	},
	{
		"<Main>/HTML/Font/Big",
		NULL,
		html_big_cb
	},
	{
		"<Main>/HTML/Font/Small",
		NULL,
		html_small_cb
	},
	{
		"<Main>/HTML/List/Ordered List",
		NULL,
		html_ordered_cb
	},
	{
		"<Main>/HTML/List/Unordered List",
		NULL,
		html_unordered_cb
	},
	{
		"<Main>/HTML/List/List Item",
		NULL,
		html_listitem_cb
	},
	{
		"<Main>/HTML/List/<separator>"
	},
	{
		"<Main>/HTML/List/Definition List",
		NULL,
		html_deflist_cb
	},
	{
		"<Main>/HTML/List/Definition Term",
		NULL,
		html_defterm_cb
	},
	{
		"<Main>/HTML/List/Definition",
		NULL,
		html_def_cb
	},
	{
		"<Main>/HTML/List/<separator>"
	},
	{
		"<Main>/HTML/List/Menu",
		NULL,
		html_menu_cb
	},
	{
		"<Main>/HTML/Tables/New Table",
		NULL,
		html_tablenew_cb
	},
	{
		"<Main>/HTML/Tables/<separator>"
	},
	{
		"<Main>/HTML/Tables/Table Row",
		NULL,
		html_tablerow_cb
	},
	{
		"<Main>/HTML/Tables/Table Header",
		NULL,
		html_tablehdr_cb
	},
	{
		"<Main>/HTML/Tables/Table Data",
		NULL,
		html_tabledata_cb
	},
	{
		"<Main>/HTML/Frames/New Frame",
		NULL,
		html_framenew_cb
	},
	{
		"<Main>/HTML/Frames/<separator>"
	},
	{
		"<Main>/HTML/Frames/Frame Set",
		NULL,
		html_frameset_cb
	},
	{
		"<Main>/HTML/Frames/Frame Base",
		NULL,
		html_framebase_cb
	},
	{
		"<Main>/HTML/Frames/No Frames",
		NULL,
		html_frameno_cb},
	{
		"<Main>/HTML/Forms/New Form",
		NULL,
		html_formnew_cb
	},
	{
		"<Main>/HTML/Forms/<separator>"
	},
	{
		"<Main>/HTML/Forms/Text Field",
		NULL,
		html_formtfield_cb
	},
	{
		"<Main>/HTML/Forms/Password Field",
		NULL,
		html_formpasswd_cb
	},
	{
		"<Main>/HTML/Forms/Text Area",
		NULL,
		html_formtarea_cb
	},
	{
		"<Main>/HTML/Forms/<separator>"
	},
	{
		"<Main>/HTML/Forms/List Box",
		NULL,
		html_formselect_cb
	},
	{
		"<Main>/HTML/Forms/List Item",
		NULL,
		html_formoption_cb
	},
	{
		"<Main>/HTML/Forms/<separator>"
	},
	{
		"<Main>/HTML/Forms/Radio Button",
		NULL,
		html_formradio_cb
	},
	{
		"<Main>/HTML/Forms/Checkbox",
		NULL,
		html_formchkbox_cb
	},
	{
		"<Main>/HTML/Forms/<separator>"
	},
	{
		"<Main>/HTML/Forms/Button",
		NULL,
		html_formbutton_cb
	},
	{
		"<Main>/HTML/Forms/Image",
		NULL,
		html_formimage_cb
	},
	{
		"<Main>/HTML/Forms/Submit",
		NULL,
		html_formsubmit_cb
	},
	{
		"<Main>/HTML/Forms/Reset",
		NULL,
		html_formchkbox_cb
	},
	{
		"<Main>/HTML/Lower case tags",
		NULL,
		html_tag_lower
	},
	{
		"<Main>/HTML/Upper case tags",
		NULL,
		html_tag_upper
	},
#endif	/* USE_HTMLTAGS */

#ifdef USE_DOCLIST
	{
		"<Main>/Window/Doc List",
		"<control>L",
		doc_list_show
	},
#endif	/* USE_DOCLIST */
#ifdef WANT_MSGBOX
	{
		"<Main>/Window/Messages",
		"<control>M",
		msgbox_show},
#endif  /* #ifdef WANT_MSGBOX */
#if defined(USE_DOCLIST) || defined(WANT_MSGBOX)
	{
		"<Main>/Window/<separator>"
	},
#endif
#ifdef USE_WINLIST
	{
		"<Main>/Window/Window List",
		NULL,
		win_list_show
	},
#endif	/* USE_WINLIST */
	{
		"<Main>/Window/New Window",
		NULL,
		win_new_with_doc
	},
	{
		"<Main>/Window/Close Window",
		NULL,
		win_close_cb
	},

#ifdef APP_GNP
# ifdef WANT_PROJECT
	{
		"<Main>/Project/Toggle Project Bar",
		NULL,
		prjbar_toggle
	},
	{
		"<Main>/Project/<separator>"
	},
	{
		"<Main>/Project/New Project"
	},
	{
		"<Main>/Project/Open Project",
		NULL,
		prj_open_cb
	},
	{
		"<Main>/Project/Edit Project"
	},
	{
		"<Main>/Project/Save Project"
	},
	{
		"<Main>/Project/Close Project",
		NULL,
		prj_close_cb
	},
	{
		"<Main>/Project/<separator>"
	},
	{
		"<Main>/Project/Current Project Info"
	},
	{
		"<Main>/Project/Project List",
		NULL,
		prj_list_show
	},
	{
		"<Main>/Project/Edit A Project"
	},
# endif	/* WANT_PROJECT */
#endif	/* APP_GNP */

	{
		"<Main>/Options/Toggle Message Bar",
		NULL,
		msgbar_toggle
	},
	{
		"<Main>/Options/Toggle Wordwrap",
		NULL,
		win_wwrap_toggle
	},
	{
		"<Main>/Options/Doc Tabs/Toggle",
		NULL,
		win_dtab_toggle
	},
	{
		"<Main>/Options/Doc Tabs/<separator>"
	},
	{
		"<Main>/Options/Doc Tabs/Top",
		NULL,
		win_dtab_top
	},
	{
		"<Main>/Options/Doc Tabs/Bottom",
		NULL,
		win_dtab_bot
	},
	{
		"<Main>/Options/Doc Tabs/Left",
		NULL,
		win_dtab_left
	},
	{
		"<Main>/Options/Doc Tabs/Right",
		NULL,
		win_dtab_right
	},
#ifdef USE_TOOLBARS
	{
		"<Main>/Options/Toolbar/Toggle HTML Toolbar",
		NULL,
		tb_html_toggle
	},
	{
		"<Main>/Options/Toolbar/<separator>"
	},
	{
		"<Main>/Options/Toolbar/Toggle On-Off",
		NULL,
		tb_toggle
	},
	{
		"<Main>/Options/Toolbar/Toggle Tooltips",
		NULL,
		tb_ttip_toggle
	},
	{
		"<Main>/Options/Toolbar/<separator>"
	},
	{
		"<Main>/Options/Toolbar/Icons & Text",
		NULL,
		tb_pic_text
	},
	{
		"<Main>/Options/Toolbar/Icons Only",
		NULL,
		tb_pic_only
	},
	{
		"<Main>/Options/Toolbar/Text Only",
		NULL,
		tb_text_only
	},
#endif	/* USE_TOOLBARS */
	{
		"<Main>/Options/<separator>"
	},
	{
		"<Main>/Options/Preferences...",
		NULL,
		prefs_cb
	},

	{
		"<Main>/Help/About gnotepad+",
		NULL,
		about_cb
	}
};
#endif	/* GTK_HAVE_FEATURES_1_1_0 */

#endif	/* USE_GNOME */

#ifdef APP_GNP
typedef struct {
	char *name;
	GtkMenuCallback cb;
} qmenu_t;

static qmenu_t qmenu[] = {
#ifdef USE_CLIPBOARD
	{ N_("Cut"), cut_cb },
	{ N_("Copy"), copy_cb },
	{ N_("Paste"), paste_cb },
	{ "<separator>", NULL },
#endif	/* USE_CLIPBOARD */
	{ N_("Open in new window"), doc_open_in_new_win },
	{ "<separator>", NULL },
	{ N_("Save"), doc_save_cb },
	{ N_("Close"), doc_close_cb },
	{ N_("Print"), print_cb },
	{ NULL, NULL }
};
#endif

#if 0
#if defined(ENABLE_NLS) && !defined(USE_GNOME) && \
    defined(GTK_HAVE_FEATURES_1_1_0)
static gchar *
menu_translate(const gchar *path, gpointer data)
{
	if (!strcmp(gettext(path), path))
		return gettext(strrchr(path, '/') + 1);
	return gettext(path);
}
#endif
#endif

/*** global function definitions ***/
/*
 * PUBLIC: menu_main_init
 *
 * initialize the menubar.  called from win_new().
 */
void
menu_main_init(win_t *w)
{
#ifndef USE_GNOME
# ifdef GTK_HAVE_FEATURES_1_1_0
	GtkAccelGroup *accgrp;
	int numitems;
# else
	GtkMenuPath *mpath;
	GtkMenuFactory *subf;
	GtkMenuEntry *newmenu;
	int numitems, i;
# endif
#endif

#ifdef ENABLE_NLS
	bindtextdomain("gnotepad+", LOCALEDIR);
	textdomain("gnotepad+");
#endif

#ifdef USE_GNOME
	menu_set_callback_data(w, main_menu);
	gnome_app_create_menus(GNOME_APP(w->toplev), main_menu);
	gnome_app_install_menu_hints(GNOME_APP(w->toplev), main_menu);
	menu_gnome_setup_post1(w, main_menu);
	menu_main_state_set((void *)w);
#else
# ifdef GTK_HAVE_FEATURES_1_1_0
	numitems = sizeof(mainmenu) / sizeof(mainmenu[0]);
	accgrp = gtk_accel_group_new();
	w->mainfact = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accgrp);
#if 0
#  ifdef ENABLE_NLS
	gtk_item_factory_set_translate_func(w->mainfact, menu_translate,
					    "<main>", NULL);
#  endif
#endif

	/*
	 * words cannot express how stupid some of the gtk folks can be.  they
	 * really need to learn how to write documentation.  but hey, you get
	 * what you paid for, and since it's free, let's not complain any more.
	 *
	 * using gtk_item_factory_create_items() from testgtk.c won't work
	 * unless you change a lot of code.  since i'm trying to preserve the
	 * overall structure from my gtk-1.0.x code base, i can't just blindly
	 * use gtk_item_factory_create_items().  fortunately, i took a look at
	 * yet another public and undocumented routine which happens to do what
	 * was needed: gtk_item_factory_create_items_ac().  here, we can
	 * specify the callback type:
	 *
	 * gtk_item_factory_create_items(w->mainfact, numitems, mainmenu, NULL);
	 */
	gtk_item_factory_create_items_ac(w->mainfact, numitems, mainmenu, w, 2);

	gtk_accel_group_attach(accgrp, GTK_OBJECT(w->toplev));
	w->menubar = gtk_item_factory_get_widget(w->mainfact, "<main>");

	menu_main_state_set((void *)w);
# else	/* GTK 1.0.x */
	newmenu = mainmenu;
	numitems = sizeof(mainmenu) / sizeof(mainmenu[0]);

	for (i = 0; i < numitems; i++)
		newmenu[i].callback_data = (gpointer)w;
	w->mainfact = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
	subf = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
	gtk_menu_factory_add_subfactory(w->mainfact, subf, "<Main>");
	gtk_menu_factory_add_entries(w->mainfact, newmenu, numitems);

	mpath = gtk_menu_factory_find(w->mainfact, "<Main>/Help");
	gtk_menu_item_right_justify(GTK_MENU_ITEM(mpath->widget));

	w->menubar = subf->widget;
	gtk_window_add_accelerator_table(GTK_WINDOW(w->toplev), subf->table);
# endif	/* GTK_HAVE_FEATURES_1_1_0 */

	w->menubar_h = gtk_handle_box_new();
	gtk_container_add(GTK_CONTAINER(w->menubar_h), w->menubar);
	gtk_box_pack_start(GTK_BOX(w->mainbox), w->menubar_h, FALSE, TRUE, 0);
	gtk_widget_show(w->menubar);
	gtk_widget_show(w->menubar_h);
#endif	/* no gnome */

} /* menu_main_init */


#ifdef GTK_HAVE_FEATURES_1_1_0

# ifdef USE_GNOME
/*
 * for each window, we keep track of a list of mwi_data_t items.  this list
 * represents the widget created for toggle buttons and radio buttons in the
 * menus themselves.  we need to keep a copy of this list because the global
 * variable, main_menu[], along with all the submenus, have their 'widget'
 * field (a member of GnomeUIInfo) updated each time a new menu is created.
 * hence, in order to keep track of the widget value on a per-menu (or rather,
 * a per-window) basis, after we create the menus, we scan through the menus,
 * and grab a copy of the widget if it's a button widget.  we also grab the
 * pointer to the callback so we know how this widget is supposed to behave.
 * (see the next struct)
 *
 * note that this structure is used for Gnome only, since in the regular
 * gtk+-1.1.x case, the widgets are hashed as part of the menuitemfactory
 * creation.  hence, we simply use gtk_item_factory_get_widget() to get the
 * widget instead of storing a list of them.
 *
 * thanks to Havoc Pennington <hp@pobox.com, <hp@Mcs.Net>> for suggesting the
 * idea of saving the widget itself from the menu structure.
 */
typedef struct {
	GtkWidget *wgt;
	gpointer cb;
} mwi_data_t;
# endif


/*
 * here, we track the callback with respect to a particular (check button) menu
 * item.  'val' associates what the value of the check button is.  once we have
 * the widget from the menu item, we look through a table of micb_data_t items,
 * find the matching callback, and use 'val' to determine the current state of
 * the check button widget.
 */
typedef struct {
	GtkItemFactoryCallback cb;
	long *opt;
	long val;
} micb_data_t;

static micb_data_t micb_data[] = {
# ifdef USE_HTMLTAGS
	{ (GtkItemFactoryCallback)html_tag_lower,
	  &prefs.options1, HTML_TAG_LOWER
	},
	{ (GtkItemFactoryCallback)html_tag_upper,
	  &prefs.options1, HTML_TAG_UPPER
	},
# endif
	{ (GtkItemFactoryCallback)msgbar_toggle,
	  &prefs.options1, SHOW_MSGBAR
	},
	{ (GtkItemFactoryCallback)win_wwrap_toggle,
	  &prefs.options1, USE_WORDWRAP
	},
	{ (GtkItemFactoryCallback)win_dtab_toggle,
	  &prefs.options1, SHOW_TABS
	},
# ifdef USE_TOOLBARS
#  ifdef USE_HTMLTAGS
	{ (GtkItemFactoryCallback)tb_html_toggle,
	  &prefs.options1, SHOW_HTML_TOOLBAR
	},
#  endif
	{ (GtkItemFactoryCallback)tb_toggle,
	  &prefs.options1, SHOW_TOOLBAR
	},
	{ (GtkItemFactoryCallback)tb_raised_toggle,
	  &prefs.options1, TOOLBAR_RAISED
	},
	{ (GtkItemFactoryCallback)tb_ttip_toggle,
	  &prefs.options1, SHOW_TOOLTIPS
	},
# endif	/* USE_TOOLBARS */
	{ (GtkItemFactoryCallback)win_dtab_top,
	  &prefs.options1, DOC_TABS_TOP
	},
	{ (GtkItemFactoryCallback)win_dtab_bot,
	  &prefs.options1, DOC_TABS_BOTTOM
	},
	{ (GtkItemFactoryCallback)win_dtab_left,
	  &prefs.options1, DOC_TABS_LEFT
	},
	{ (GtkItemFactoryCallback)win_dtab_right,
	  &prefs.options1, DOC_TABS_RIGHT
	},
# ifdef USE_TOOLBARS
	{ (GtkItemFactoryCallback)tb_pic_text,
	  &prefs.options1, PIC_TEXT_TOOLBAR
	},
	{ (GtkItemFactoryCallback)tb_pic_only,
	  &prefs.options1, PIC_ONLY_TOOLBAR
	},
	{ (GtkItemFactoryCallback)tb_text_only,
	  &prefs.options1, TEXT_ONLY_TOOLBAR
	},
# endif	/* USE_TOOLBARS */
	{ NULL }
}; /* micb_data_t */


/*
 * PUBLIC: menu_main_state_set
 *
 * sets individual menu items which may have a toggle button or a radio button.
 */
void
menu_main_state_set(void *data)
{
	win_t *w = (win_t *)data;
	micb_data_t *micp;
# ifdef USE_GNOME
	GSList *mwlp;

	for (mwlp = w->menuwgts; mwlp; mwlp = mwlp->next) {
		mwi_data_t *mwip = (mwi_data_t *)(mwlp->data);

		for (micp = micb_data; micp->cb; micp++) {
			if ((gpointer)(mwip->cb) == (gpointer)(micp->cb)) {
				GTK_CHECK_MENU_ITEM(mwip->wgt)->active =
					(*micp->opt & micp->val) ? TRUE : FALSE;
			}
		}
	}
# else
	int numitems, i;
	GtkWidget *wgt;

	numitems = sizeof(mainmenu) / sizeof(mainmenu[0]);

	/* set the various states for the toggle/radio items */
	for (i = 0; i < numitems; i++) {
		if (!mainmenu[i].item_type)
			continue;
		if (strcmp(mainmenu[i].item_type, "<ToggleItem>") &&
		    strcmp(mainmenu[i].item_type, "<RadioItem>"))
			continue;

		for (micp = micb_data; micp->cb; micp++) {
			if (mainmenu[i].callback != micp->cb)
				continue;
			/*
			 * GTK bugaroo: gtk_item_factory_get_widget()
			 * doesn't work if there are underscores (key
			 * accelerators) in the menuitem path!!
			 */
			wgt = gtk_item_factory_get_widget(w->mainfact,
							  mainmenu[i].path);

			if (!wgt || !GTK_IS_CHECK_MENU_ITEM(wgt))
				continue;

			GTK_CHECK_MENU_ITEM(wgt)->active =
					(*micp->opt & micp->val) ? TRUE : FALSE;
		}
	}
# endif	/* no gnome */
} /* menu_main_state_set */
#endif	/* GTK_HAVE_FEATURES_1_1_0 */

#ifdef USE_GNOME
static void
menu_gnome_setup_post1(win_t *w, GnomeUIInfo *menu)
{
	GnomeUIInfo *mip;

	for (mip = menu; mip->type != GNOME_APP_UI_ENDOFINFO; mip++) {
		if (mip->type == GNOME_APP_UI_SUBTREE) {
			menu_gnome_setup_post1(
					w, (GnomeUIInfo *)(mip->moreinfo));
		/*
		 * strangely enough, we need to accept GNOME_APP_UI_ITEM items
		 * because individual radio items in a radio item group will
		 * have this type.  to avoid performing action on a menu item
		 * that has type GNOME_APP_UI_ITEM but really isn't a radio
		 * item, we manually use the GTK_IS_xxx checks down below.
		 */
		} else if (mip->type == GNOME_APP_UI_TOGGLEITEM ||
			   mip->type == GNOME_APP_UI_RADIOITEMS ||
			   mip->type == GNOME_APP_UI_ITEM) {
			/*
			 * the lead entry to a radio item group will not have
			 * a label/description.  instead, it has a pointer to
			 * another subtree which contains all the individual
			 * radio items.  see GnomeUIInfo.
			 */
			if (mip->label == NULL) {
				menu_gnome_setup_post1(
					w, (GnomeUIInfo *)(mip->moreinfo));
			} else
				menu_gnome_setup_post2(w, mip);

		} /* it's possibly toggle/{radio|ui_item} */
	} /* for each menu item */
} /* menu_gnome_setup_post1 */


static void
menu_gnome_setup_post2(win_t *w, GnomeUIInfo *mip)
{
	mwi_data_t *data;
	micb_data_t *micp;

	for (micp = micb_data; micp->cb; micp++) {
		if ((gpointer)(mip->moreinfo) != (gpointer)(micp->cb))
			continue;
		if (!mip->widget || !GTK_IS_CHECK_MENU_ITEM(mip->widget))
			continue;
		/*
		 * found the check item (a toggle or
		 * radio button) in the menu.  now save
		 * its callback and widget so we know
		 * what to do with it later.
		 */
		data = g_new(mwi_data_t, 1);
		data->wgt = mip->widget;
		data->cb = (gpointer)(mip->moreinfo);
		w->menuwgts = g_slist_prepend(w->menuwgts, data);
	} /* find the callback */
} /* menu_gnome_setup_post2 */


static void
menu_set_callback_data(win_t *w, GnomeUIInfo *menu)
{
	GnomeUIInfo *mip;

	/*
	 * note: lead entries for a radioitem group will have an empty/null
	 * label/description.  it will then contain a pointer to a list/subtree
	 * which has the actual radioitems.  see GnomeUIInfo.
	 */
	for (mip = menu; mip->type != GNOME_APP_UI_ENDOFINFO; mip++) {
		if (mip->type == GNOME_APP_UI_SUBTREE ||
		   (mip->type == GNOME_APP_UI_RADIOITEMS && !mip->label))
			menu_set_callback_data(w, (GnomeUIInfo *)mip->moreinfo);
		else
			mip->user_data = w;
	}
} /* menu_set_callback_data */
#endif	/* USE_GNOME */

/*
 * PUBLIC: menu_recent_doc_remove
 *
 * always removes the first entry, since adding to the menu is FIFO.
 * called from recent_list_trim().
 */
#ifdef USE_RECENT
void
menu_recent_doc_remove(gpointer data)
{
	int len;
	char *menupath;
	doc_new_name_t *dnnp = (doc_new_name_t *)data;

	len = strlen(MENU_PATH_RECENT_DOC) +
	      strlen((const char *)my_basename(dnnp->fname)) + 1;
	menupath = g_new(char, len);
	g_snprintf(menupath, len, "%s%s",
			MENU_PATH_RECENT_DOC, my_basename(dnnp->fname));

# ifdef USE_GNOME
	gnome_app_remove_menus(GNOME_APP(dnnp->w->toplev), menupath, 1);
# else
	menu_remove(dnnp->w->mainfact, menupath);
# endif
	g_free(menupath);
} /* menu_recent_doc_remove */


/*
 * PUBLIC: menu_recent_doc_add
 *
 * called from recent_list_add(), recent_list_init()
 */
void
menu_recent_doc_add(GtkMenuCallback cbfunc, gpointer data)
{
	doc_new_name_t *dnnp = (doc_new_name_t *)data;
# ifdef USE_GNOME
	char *path;
	GnomeUIInfo *menuitem;

	menuitem = g_new0(GnomeUIInfo, 2);
	menuitem->type = GNOME_APP_UI_ITEM;
	menuitem->moreinfo = (gpointer)cbfunc;
	menuitem->user_data = data;
	menuitem->label = (char *)g_strdup(my_basename(dnnp->fname));
	menuitem[1].type = GNOME_APP_UI_ENDOFINFO;

	path = g_strdup(MENU_PATH_RECENT_DOC);
	gnome_app_insert_menus_with_data(GNOME_APP(dnnp->w->toplev),
					 path, menuitem, data);
	g_free(path);
	g_free(menuitem->label);
	g_free(menuitem);
# else
	menu_add(dnnp->w->mainfact, MENU_PATH_RECENT_DOC,
		(char *)my_basename(dnnp->fname), NULL,
#  ifdef GTK_HAVE_FEATURES_1_1_0
		(GtkItemFactoryCallback)cbfunc,
#  else
		cbfunc,
#  endif
		(gpointer)dnnp);
# endif	/* no gnome */
} /* menu_recent_doc_add */
#endif	/* USE_RECENT */


/*
 * PUBLIC: quickmenu_init
 *
 * initialize the quick popup menu (right mouse click).  called from win_new().
 */
void
quickmenu_init(win_t *w)
{
	GtkWidget *tmp;
	qmenu_t *qmp = qmenu;

	w->quickmenu = gtk_menu_new();
	while (qmp && qmp->name != NULL) {
		if (strcmp(qmp->name, "<separator>") == 0)
			tmp = gtk_menu_item_new();
		else
			tmp = gtk_menu_item_new_with_label(gettext(qmp->name));

		gtk_menu_append(GTK_MENU(w->quickmenu), tmp);
		gtk_widget_show(tmp);

		if (qmp->cb)
			(void)gtk_signal_connect(GTK_OBJECT(tmp), "activate",
						 GTK_SIGNAL_FUNC(qmp->cb), w);
		qmp++;
	}
} /* quickmenu_init */


/*
 * PUBLIC: quickmenu_show
 *
 * callback routine invoked when user clicks on right mouse button.
 */
gboolean
quickmenu_show(GtkWidget *wgt, GdkEvent *ev)
{
	if (ev->type == GDK_BUTTON_PRESS) {
		GdkEventButton *event = (GdkEventButton *)ev;
		if (event->button == 3) {
			gtk_menu_popup(GTK_MENU(wgt), NULL, NULL, NULL, NULL,
					event->button, event->time);
			return TRUE;
		}
	}
	return FALSE;
} /* quickmenu_show */


/*** local functions ***/
/*
 * PRIVATE: menu_remove
 *
 * called only from menu_recent_doc_remove(), to remove an item from the
 * submenu for recent files.
 */
#ifdef USE_RECENT
# if !defined(USE_GNOME) && defined(GTK_HAVE_FEATURES_1_1_0)
static void
menu_remove(GtkItemFactory *menubar, char *menupath)
{
	gtk_item_factory_delete_item(menubar, menupath);
} /* menu_remove */

# else
#  ifndef GTK_HAVE_FEATURES_1_1_0
static void
menu_remove(GtkMenuFactory *menubar, char *menupath)
{
	gtk_menu_factory_remove_paths(menubar, &menupath, 1);
} /* menu_remove */
#  endif
# endif
#endif	/* USE_RECENT */


#ifdef USE_RECENT
/*
 * PRIVATE: menu_add
 *
 * called only from menu_recent_doc_add() to add an item to the submenu for
 * recent files.
 */
# if !defined(USE_GNOME) && defined(GTK_HAVE_FEATURES_1_1_0)
static void 
menu_add(GtkItemFactory *menubar, char *submenupath, char *newmenupath,
	 char *accelerator, GtkItemFactoryCallback callback, gpointer cbdata)
{
	GtkItemFactoryEntry *newentry;
	int len;

	newentry = g_new(GtkItemFactoryEntry, 1);
	len = strlen(submenupath) + strlen(newmenupath) + 1;
	newentry->path = g_new(char, len);
	g_snprintf(newentry->path, len, "%s%s", submenupath, newmenupath);
	newentry->accelerator = accelerator;
	newentry->callback = callback;
	newentry->callback_action = 0;
	newentry->item_type = "<Item>";

	/*
	 * again, words cannot express how stupid some of the gtk folks can be.
	 *
	 * the last param to gtk_item_factory_create_item() is the callback
	 * type.  effectively, this specifies what kind of parameters and in
	 * what order they are in for the callback routine.  for more details,
	 * see the *private* function gtk_item_factory_callback_marshal().
	 *
	 * i don't understand why the old menu factory code couldn't have just
	 * been updated to use the new item factory crap instead of having
	 * everyone forcibly switch to item factories.  can you say boneheaded?
	 */
	gtk_item_factory_create_item(menubar, newentry, cbdata, 2);

	/*
	 * although it doesn't say that you can anywhere, it looks like we can
	 * safely free up the space we just allocated
	 */
	g_free(newentry->path);
	g_free(newentry);
} /* menu_add */
# else
#  ifndef GTK_HAVE_FEATURES_1_1_0
static void 
menu_add(GtkMenuFactory *menubar, char *submenupath, char *newmenupath,
	 char *accelerator, GtkMenuCallback callback, gpointer cbdata)
{
	GtkMenuEntry *newentry;
	int len;

	newentry = g_new(GtkMenuEntry, 1);
	len = strlen(submenupath) + strlen(newmenupath) + 1;
	newentry->path = g_new(char, len);
	g_snprintf(newentry->path, len, "%s%s", submenupath, newmenupath);
	newentry->accelerator = accelerator;
	newentry->callback = callback;
	newentry->callback_data = cbdata;
	newentry->widget = NULL;

	gtk_menu_factory_add_entries(menubar, newentry, 1);

	/*
	 * although it doesn't say that you can anywhere, it looks like we can
	 * safely free up the space we just allocated
	 */
	g_free(newentry->path);
	g_free(newentry);
} /* menu_add */
#  endif	/* gtk+-1.0.x */
# endif	/* !defined(USE_GNOME) && defined(GTK_HAVE_FEATURES_1_1_0) */
#endif	/* USE_RECENT */


/* the end */
