/* vi:set ts=8 sts=0 sw=8:
 * $Id: doc.h,v 1.34 2000/03/01 01:46:29 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __DOC_H__
#define __DOC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <sys/stat.h>
#include <gtk/gtk.h>
#include "main.h"
#include "win.h"
#include "project.h"

/* new document flags */
#define	UPDATE_MSGBAR	(1 << 0)
#define DO_LOAD		(1 << 1)
#define UPDATE_TITLE	(1 << 2)
#define FORCE_READONLY	(1 << 3)
#define NEVER_UNLOAD	(1 << 4)


typedef enum {
	DocText,
	DocXmHtml,
	DocGtkHtml,
	DocNoType
} doc_type_t;

typedef struct {
#ifdef APP_DEBUG
	unsigned	docid;		/* document id */
#endif
	win_t *		w;		/* document's parent window (win_t *) */
	char *		fname;		/* document's filename */
	struct stat *	sb;		/* info from stat() */
#if defined(USE_FILEINFO) || defined(GTK_HAVE_FEATURES_1_1_0)
	void *		docinfo;	/* top level docinfo */
#endif
	guint		changed_id;	/* id of doc changed */
	bool_t		changed;	/* whether or not doc has changed */
#ifdef WANT_DOCUNLOAD
	bool_t		loaded;		/* whether file contents in memory */
	bool_t		never_unload;	/* never unload this doc from memory */
	float		adjvalue;	/* Gtk adjustment value to store
					   current position in document */
#endif
	bool_t		force_ro;	/* forced to be readonly */
	GtkWidget *	data;		/* text or clist widget */
	GtkWidget *	tablabel;	/* tab label, containing filename */
	GtkWidget *	printwin;	/* top level print window */
	GtkWidget *	printentry;	/* widget containing print cmd */
#if defined(USE_UNDOREDO) && defined(GTK_HAVE_FEATURES_1_1_0)
	unsigned	ins_txt_id;	/* "insert_text" signal (txt widget) */
	unsigned	del_txt_id;	/* "delete_text" signal (txt widget) */
	GList *		undolist;	/* list of actions for undo */
	GList *		undotail;	/* tail of undo list */
	GList *		redolist;	/* list of actions for redo */
	GList *		redotail;	/* tail of redo list */
#endif	/* USE_UNDOREDO */
#ifdef WANT_PROJECT
	prj_t *		prj;		/* project this doc belongs in */
#endif
} doc_t;

#ifdef USE_RECENT
typedef struct {
	win_t *w;			/* pointer into entry in 'winlist' */
	char *fname;
} doc_new_name_t;
#endif	/* USE_RECENT */


#define DOC_CURRENT(w)	(doc_t *)((w)->curdoc)
extern char *	doc_basefname(doc_t *d);
#ifdef USE_RECENT
extern void	doc_by_name(GtkWidget *wgt, gpointer cbdata);
#endif	/* USE_RECENT */
#ifdef APP_GNP
extern void	doc_changed_cb(GtkWidget *wgt, gpointer cbdata);
extern int	doc_check_if_any_changed(win_t *w);
#endif
extern void	doc_close_all_cb(GtkWidget *wgt, gpointer cbdata);
extern bool_t	doc_close_all_common(win_t *w);
extern void	doc_close_cb(GtkWidget *wgt, gpointer cbdata);
extern bool_t	doc_close_common(win_t *w, bool_t set_title);
extern void	doc_foreach(win_t *wp, void (*func)(void *));
extern void	doc_goto_by_name(GtkWidget *wgt, gpointer cbdata);
#ifdef USE_FILEINFO
extern void	doc_info_cb(GtkWidget *wgt, gpointer cbdata);
extern void	doc_info_label_update(win_t *w);
#else
# define	doc_info_label_update(w)
#endif	/* USE_FILEINFO */
#if defined(USE_FILEINFO) || defined(GTK_HAVE_FEATURES_1_1_0)
extern void	doc_info_init(win_t *w, GtkWidget *parent);
#else
# define	doc_info_init(w, parent)
#endif
#ifdef USE_DOCLIST
extern void	doc_list_destroy(GtkWidget *wgt, gpointer cbdata);
extern void	doc_list_show(GtkWidget *wgt, gpointer cbdata);
#endif	/* USE_DOCLIST */
extern void	doc_load(doc_t *d);
extern void	doc_unload(doc_t *d);
extern void	doc_new(win_t *parent, char *fname, doc_type_t, long flags);
extern void	doc_new_cb(GtkWidget *wgt, gpointer cbdata);
extern void	doc_open_cb(GtkWidget *wgt, gpointer cbdata);
extern void	doc_open_in_new_win(GtkWidget *wgt, gpointer cbdata);
#ifdef APP_GNP
extern void	doc_flags_set(doc_t *d, long flags);
extern void	doc_redraw(void *data);
extern void	doc_saveas_cb(GtkWidget *wgt, gpointer cbdata);
extern bool_t	doc_saveas_common(win_t *w);
extern void	doc_save_cb(GtkWidget *wgt, gpointer cbdata);
extern bool_t	doc_save_common(win_t *w);
extern void	doc_switch_page(GtkWidget *wgt, GtkNotebookPage *page,
				     int num, gpointer cbdata);
extern void	doc_tab_stop_set(void *data);
extern void	doc_toggle_wrap(GtkWidget *w, gpointer data);
#endif
#if defined(WANT_PROJECT) && defined(APP_GNP)
extern void	doc_open_prj(win_t *w);
#endif	/* WANT_PROJECT */
extern void	doc_insert_text_cb(GtkEditable *, const char *, int, int *,
				gpointer);
extern void	doc_delete_text_cb(GtkEditable *, int start, int end, gpointer);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __DOC_H__ */
