/*  Gaby
 *  Copyright (C) 1998-1999 Frederic Peters
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#else
#  warning "no config.h !!!"
#  define PACKAGE "gaby"
#  define VERSION "unknown"
#endif /* HAVE_CONFIG_H */

#ifndef CODENAME
#  define CODENAME "One Advice, Space"
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>

#ifdef HAVE_GETOPT_H
#  include <getopt.h>
#endif

#ifdef HAVE_REGEX_H
#  include <regex.h>
#endif

#ifdef HAVE_LOCALE_H
#  include <locale.h>
#endif

#ifdef NO_GUI
#  include <glib.h>
#else /* ! NO_GUI */
#  ifdef USE_GNOME 
#    include <gnome.h>
#  else
#    include <gtk/gtk.h>
#  endif
#  ifdef HAVE_IMLIB
#    include <gdk_imlib.h>
#  endif
#endif /* ! NO_GUI */

#include <gmodule.h>

#ifdef HAVE_ESD
#  include <esd.h>
#endif

#ifndef NO_GUI
#  ifndef APP_DECLARED
#    ifdef USE_GNOME
extern GnomeApp *app;
#    else
extern GtkWidget *app;
#    endif
#  endif
#else
extern void *app;
#endif

#ifndef LIST_WINS_DECLARED
extern GList *list_windows;
#endif

#ifndef LISTS_DECLARED
extern GList *list_tables;
extern GList *list_subtables;
extern GList *list_views;
extern GList *list_actions;
extern GList *list_print_plugins;
#endif

#ifndef APPNAME_DECLARED
extern char *appname;
#endif

/* this code left the autoconf documentation for a better place :) */
#if HAVE_DIRENT_H
#  include <dirent.h>
#  define NAMLEN(dirent) strlen((dirent)->d_name)
#else
#  define dirent direct
#  define NAMLEN(dirent) (dirent)->d_namlen
#  if HAVE_SYS_NDIR_H
#    include <sys/ndir.h>
#  endif
#  if HAVE_SYS_DIR_H
#    include <sys/dir.h>
#  endif
#  if HAVE_NDIR_H
#    include <ndir.h>
#  endif
#endif

#ifdef HAVE_GETTEXT
#  include <libintl.h>
#  define gettext_noop(String) (String)
#else
#  include <intl/libintl.h>
#endif

#define _(String) gettext (String)

#define INDEXES_ARE_ARRAYS

#include "struct.h"

#include "gabyerror.h"

#ifndef GABY_ERRNO_DECLARED
	/* those 2 ones are for plug-ins, read errors.h and do_action() in
	 * menu.c if you want to know more about them */
extern int   gaby_errno;
extern char* gaby_message;
#endif

#ifdef DEBUG_GABY
/* this is for debugging */
#  ifdef __GNUC__
#    define debug_print(format, args...) (fprintf(stderr, format, ##args))
#  else
#    define debug_print			 printf
#  endif
#endif

#ifdef FOLLOW_MIGUEL
/* this is for plug-ins */
#define mstatic
#include "py_fm.h"
#else
#define mstatic static
#endif

