#!/bin/sh

if test x$1 = x || test x$2 = x ; then
    echo "Usage:"
    echo "$0 <package-name> <version-number>"
    echo ""
    exit
fi

rm -Rf ./x/
mkdir ./x

for i in `cat $1.spec | sed -e '1,/^%file/D' | grep -v '^%doc' | \
	sed -e 's/%[a-z]*//g'` ; do
    DIR=`echo $i | sed -e 's+/[^/]*$++g'`
    mkdir -p ./x/$DIR
    cp -ap $i ./x/$DIR/
done

mkdir -p ./x/usr/doc/$1-$2
for i in `cat $1.spec | sed -e '1,/^%file/D' | grep '^%doc'| \
	sed -e 's/%[a-z]*//g'` ; do
    cp -ap $i ./x/usr/doc/$1-$2/
done

(
    cd ./x || {
	echo 'huh? where is directory x?!'
	exit
    }
    tar -czf ../$1-$2.tar.gz *
)

rm -Rf ./x/

