/* fileinfo.c - display info on a file
   Copyright (C) 1997 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <my_string.h>
#include "stringtools.h"
#include <sys/types.h>

#include <my_string.h>
#include <sys/stat.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "coolwidget.h"
#include "pool.h"
#include "mad.h"

/*
 *	      struct stat
 *	      {
 *		  dev_t		st_dev;	     /* device */
 *		  ino_t		st_ino;	     /* inode */
 *		  umode_t	st_mode;     /* protection */
 *		  nlink_t	st_nlink;    /* number of hard links */
 *		  uid_t		st_uid;	     /* user ID of owner */
 *		  gid_t		st_gid;	     /* group ID of owner */
 *		  dev_t		st_rdev;     /* device type (if inode device) */
 *		  off_t		st_size;     /* total size, in bytes */
 *		  unsigned long st_blksize;  /* blocksize for filesystem I/O */
 *		  unsigned long st_blocks;   /* number of blocks allocated */
 *		  time_t	st_atime;    /* time of last access */
 *		  time_t	st_mtime;    /* time of last modification */
 *		  time_t	st_ctime;    /* time of last change */
 *	      };
 */

void fileinfo_cmd (Window win, int x, int y, char *filename)
{
    struct stat s;
    CEvent cwevent;
    CState s;

    if (lstat(filename, &s)) {
	CErrorDialog (win, x, y, " File Info ", get_sys_error (" Cannot lstat this file. "));
	return;
    }
/* Not yet finished */
}








