/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : resonato.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitResonator
|
| Description : DSPKitResonator
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char resonato_cc [] = "$Id$";

#include "resonato.h"

long DSPKitResonator::setInput(DSPKitProcessor *ip)
{
  DSPKitProcessor::setInput (ip);
  chBuf.y1 = 0.0;
  chBuf.y2 = 0.0;
  return 1;
}

void DSPKitResonator::setCenterFreqAndBW (double f,double bw)
{
  centerFreq = f;
  bandwidth  = bw;

  b2 = exp (-(2 * M_PI) * (bandwidth / inputSamplingRate));
  b1 = (-4.0 * b2) / (1.0 + b2) *
       cos (2 * M_PI * (centerFreq / inputSamplingRate));
  a0 = (1.0 - b2) * sqrt (1.0 - (b1 * b1) / (4.0 * b2));
}

long DSPKitResonator::getSample (double &outputSample)
{
  double inputSample;

  if (!input->getSample(inputSample)) return 0;
  outputSample = a0 * inputSample - b1 * chBuf.y1 - b2 * chBuf.y2;
  chBuf.y2 = chBuf.y1;
  chBuf.y1 = outputSample;
  return 1;
}

/***************************************************************************/
