/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : butterwo.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitButterworthFilter
|
| Description : DSPKitButterworthFilter
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_BUTTERWORTH_H_
#define _DSPKIT_BUTTERWORTH_H_

#include "processo.h"

typedef struct BWBuffer
{
  double x [2];
  double y [2];

} BWBuffer;

class DSPKitButterworthFilter : public DSPKitProcessor
{
  public:

    long setInput (DSPKitProcessor *ip);
    long getSample (double &outputSample);

  protected:

    double   cutOffFreq;
    double   C;
    double   D;
    double   a [3];
    double   b [2];
    BWBuffer chBuf;
};

#endif

/***************************************************************************/
