/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPMixPlay.h
|
| Revision    : 1.0
| Date        : 10/05/96
|
| Object      : None
|
| Description : Prototypes for the mix play operations
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DPMixPlay_h
#define _DPMixPlay_h

#include "DPSample.h"

#define MIXCHANNELS 8

// Typedef for playlist entry

typedef struct {
  DPSample *sample;
  long     bufferNo;
  double   vol;
  long     frame;
  long     release;
  long     inc;
} playEntry;

// Playlist is global

extern playEntry    playList [MIXCHANNELS];
extern double       mixplayMasterVol;
extern long         DPMixPlayStop;
extern AFfilehandle mixfile;

char *mixPlay ();

#endif // _DPMixPlay_h

/***************************************************************************/
