/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_effect.h
|
| Revision    : 1.0
| Date        : 15/05/96
|
| Object      : None
|
| Description : Effects parameter definitions
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DPTich_effect_h
#define _DPTich_effect_h

#define DELAY_TIME_CH1(def)                      \
  {                                              \
    "Delay Time","Ch1",                          \
    0,                                           \
    0.0,1000.0,10.0,def,def,"msecs","%.1lf",     \
    0,{ },0,0                                    \
  }

#define DELAYN_TIME_CH1(delay,def)               \
  {                                              \
    "Delay "delay" Time","Ch1",                  \
    0,                                           \
    0.0,1000.0,10.0,def,def,"msecs","%.1lf",     \
    0,{ },0,0                                    \
  }

#define DELAY_TIME_CH2(def)                      \
  {                                              \
    "Delay Time","Ch2",                          \
    0,                                           \
    0.0,1000.0,10.0,def,def,"msecs","%.1lf",     \
    0,{ },0,0                                    \
  }

#define DELAYN_TIME_CH2(delay,def)               \
  {                                              \
    "Delay "delay" Time","Ch2",                  \
    0,                                           \
    0.0,1000.0,10.0,def,def,"msecs","%.1lf",     \
    0,{ },0,0                                    \
  }

#define FEEDBACK_MODE(def)                       \
  {                                              \
    "Feedback Mode","",                          \
    1,                                           \
    0.0,0.0,0.0,0.0,0.0,"","",                   \
    2,{ "Normal","Cross" },def,def               \
  }

#define FEEDBACKN_MODE(feed,def)                 \
  {                                              \
    "Feedback "feed" Mode","",                   \
    1,                                           \
    0.0,0.0,0.0,0.0,0.0,"","",                   \
    2,{ "Normal","Cross" },def,def               \
  }

#define FEEDBACK_LEVEL_CH1(def)                  \
  {                                              \
    "Feedback Level","Ch1",                      \
    0,                                           \
    -100.0,100.0,1.0,def,def,"%","%.1lf",        \
    0,{ },0,0                                    \
  }

#define FEEDBACKN_LEVEL_CH1(feed,def)            \
  {                                              \
    "Feedback "feed" Level","Ch1",               \
    0,                                           \
    -100.0,100.0,1.0,def,def,"%","%.1lf",        \
    0,{ },0,0                                    \
  }

#define FEEDBACK_LEVEL_CH2(def)                  \
  {                                              \
    "Feedback Level","Ch2",                      \
    0,                                           \
    -100.0,100.0,1.0,def,def,"%","%.1lf",        \
    0,{ },0,0                                    \
  }

#define FEEDBACKN_LEVEL_CH2(feed,def)            \
  {                                              \
    "Feedback "feed" Level","Ch2",               \
    0,                                           \
    -100.0,100.0,1.0,def,def,"%","%.1lf",        \
    0,{ },0,0                                    \
  }

#define LFO_DEPTH_CH1(def)                       \
  {                                              \
    "LFO Depth","Ch1",                           \
    0,                                           \
    0.0,100.0,1.0,def,def,"%","%.1lf",           \
    0,{ },0,0                                    \
  }

#define LFO_DEPTH_CH2(def)                       \
  {                                              \
    "LFO Depth","Ch2",                           \
    0,                                           \
    0.0,100.0,1.0,def,def,"%","%.1lf",           \
    0,{ },0,0                                    \
  }

#define LFO_PHASE_DIFF(def)                      \
  {                                              \
    "LFO Phase Difference","",                   \
    0,                                           \
    0.0,180.0,1.0,def,def,"deg","%.1lf",         \
    0,{ },0,0                                    \
  }

#define LFO_FREQ_CH1(def)                        \
  {                                              \
    "LFO Frequency","Ch1",                       \
    0,                                           \
    0.01,40.0,0.01,def,def,"Hz","%.2lf",         \
    0,{ },0,0                                    \
  }

#define LFO_FREQ_CH2(def)                        \
  {                                              \
    "LFO Frequency","Ch2",                       \
    0,                                           \
    0.01,40.0,0.01,def,def,"Hz","%.2lf",         \
    0,{ },0,0                                    \
  }

#define LFO_WAVEFORM_CH1(def)                    \
  {                                              \
    "LFO Waveform","Ch1",                        \
    1,                                           \
    0.0,0.0,0.0,0.0,0.0,"","",                   \
    5,{ "Sine","Triangle","Exponential 1",       \
    "Exponential 2","Square" },def,def           \
  }

#define LFO_WAVEFORM_CH2(def)                    \
  {                                              \
    "LFO Waveform","Ch2",                        \
    1,                                           \
    0.0,0.0,0.0,0.0,0.0,"","",                   \
    5,{ "Sine","Triangle","Exponential 1",       \
    "Exponential 2","Square" },def,def           \
  }

#define TAP_TIME_CH1(tap,def)                    \
  {                                              \
    "Tap "tap" Time","Ch1",                      \
    0,                                           \
    0.0,1000.0,10.0,def,def,"msecs","%.1lf",     \
    0,{ },0,0                                    \
  }

#define TAP_TIME_CH2(tap,def)                    \
  {                                              \
    "Tap "tap" Time","Ch2",                      \
    0,                                           \
    0.0,1000.0,10.0,def,def,"msecs","%.1lf",     \
    0,{ },0,0                                    \
  }

#define TAP_LEVEL_CH1(tap,def)                   \
  {                                              \
    "Tap "tap" Level","Ch1",                     \
    0,                                           \
    -100.0,100.0,1.0,def,def,"%","%.1lf",        \
    0,{ },0,0                                    \
  }

#define TAP_LEVEL_CH2(tap,def)                   \
  {                                              \
    "Tap "tap" Level","Ch2",                     \
    0,                                           \
    -100.0,100.0,1.0,def,def,"%","%.1lf",        \
    0,{ },0,0                                    \
  }

#define BANDN_FREQ_CH1(band,def)                 \
  {                                              \
    "Band "band" Frequency","Ch1",               \
    0,                                           \
    0.02,20.0,0.01,def,def,"kHz","%.2lf",        \
    0,{ },0,0                                    \
  }

#define BANDN_FREQ_CH2(band,def)                 \
  {                                              \
    "Band "band" Frequency","Ch2",               \
    0,                                           \
    0.02,20.0,0.01,def,def,"kHz","%.2lf",        \
    0,{ },0,0                                    \
  }

#define BANDN_GAIN_CH1(band,def)                 \
  {                                              \
    "Band "band" Gain","Ch1",                    \
    0,                                           \
    -24.0,12.0,1.0,def,def,"dB","%+.1lf",        \
    0,{ },0,0                                    \
  }

#define BANDN_GAIN_CH2(band,def)                 \
  {                                              \
    "Band "band" Gain","Ch2",                    \
    0,                                           \
    -24.0,12.0,1.0,def,def,"dB","%+.1lf",        \
    0,{ },0,0                                    \
  }

#define BANDN_RES_CH1(band,def)                  \
  {                                              \
    "Band "band" Resonance","Ch1",               \
    0,                                           \
    0.1,10.0,0.1,def,def,"","%.1lf",             \
    0,{ },0,0                                    \
  }
  
#define BANDN_RES_CH2(band,def)                  \
  {                                              \
    "Band "band" Resonance","Ch2",               \
    0,                                           \
    0.1,10.0,0.1,def,def,"","%.1lf",             \
    0,{ },0,0                                    \
  }
  
  
effectType reverberation = 
{
  "Reverberation",
  19,
  {
    {
      "Reverb Type","",
      1,
      0.0,0.0,0.0,0.0,0.0,"","",
      3,{"Moorer","Schroeder","Multi Tap"},0,0
    },
    {
      "Reverb Time","",
      0,
      0.1,50.0,0.1,2.0,2.0,"secs","%.1lf",
      0,{ },0,0
    },
    {
      "Predelay Time","Ch1",
      0,
      0.0,500.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Predelay Time","Ch2",
      0,
      0.0,500.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Size","",
      0,
      0.5,2.0,0.05,1.0,1.0,"","%.2lf",
      0,{ },0,0
    },
    {
      "Spread","",
      0,
      0.5,2.0,0.05,1.0,1.0,"","%.2lf",
      0,{ },0,0
    },
    {
      "Presence","",
      0,
      0.1,1.0,0.05,0.8,0.8,"","%.2lf",
      0,{ },0,0
    },
//     {
//       "Rotate High Freq","",
//       0,
//       0.4,20.0,0.1,10.0,10.0,"kHz","%.2lf",
//       0,{ },0,0
//     },
//     {
//       "Rotate High Gain","",
//       0,
//       -24.0,0.0,1.0,0.0,0.0,"dB","%+.1lf",
//       0,{ },0,0
//     },
//     {
//       "Rotate Low Freq","",
//       0,
//       0.02,6.3,0.02,0.1,0.1,"kHz","%.2lf",
//       0,{ },0,0
//     },
//     {
//       "Rotate Low Gain","",
//       0,
//       -24.0,0.0,1.0,0.0,0.0,"dB","%+.1lf",
//       0,{ },0,0
//     },
    {
      "Early Ref 1 Time","Ch1",
      0,
      0.0,500.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Early Ref 1 Time","Ch2",
      0,
      0.0,500.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Early Ref 1 Level","Ch1",
      0,
      -100.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Early Ref 1 Level","Ch2",
      0,
      -100.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Early Ref 2 Time","Ch1",
      0,
      0.0,500.0,10.0,100.0,100.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Early Ref 2 Time","Ch2",
      0,
      0.0,500.0,10.0,100.0,100.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Early Ref 2 Level","Ch1",
      0,
      -100.0,100.0,1.0,30.0,30.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Early Ref 2 Level","Ch2",
      0,
      -100.0,100.0,1.0,30.0,30.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Cross ER Time","Ch1",
      0,
      0.0,500.0,10.0,75.0,75.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Cross ER Time","Ch2",
      0,
      0.0,500.0,10.0,75.0,75.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Cross ER Level","Ch1",
      0,
      -100.0,100.0,1.0,20.0,20.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Cross ER Level","Ch2",
      0,
      -100.0,100.0,1.0,20.0,20.0,"%","%.1lf",
      0,{ },0,0
    }
  }
};

effectType gatedReverberation = 
{
  "Gated Reverberation",
  17,
  {
    {
      "Reverb Type","",
      1,
      0.0,0.0,0.0,0.0,0.0,"","",
      3,{"Moorer","Schroeder","Multi Tap"},0,0
    },
    {
      "Gate Time","",
      0,
      0.0,500.0,10.0,200.0,200.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Predelay Time","Ch1",
      0,
      0.0,500.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Predelay Time","Ch2",
      0,
      0.0,500.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Size","",
      0,
      0.5,2.0,0.05,1.0,1.0,"","%.2lf",
      0,{ },0,0
    },
    {
      "Spread","",
      0,
      0.5,2.0,0.05,1.0,1.0,"","%.2lf",
      0,{ },0,0
    },
    {
      "Presence","",
      0,
      0.1,1.0,0.05,0.8,0.8,"","%.2lf",
      0,{ },0,0
    },
    {
      "Envelope Form","",
      1,
      0.0,0.0,0.0,0.0,0.0,"","",
      3,{ "Linear","Exponential 1","Exponential 2" },0,0
    },
    {
      "Envelope Direction","",
      1,
      0.0,0.0,0.0,0.0,0.0,"","",
      4,{ "Normal","Reverse","Left to Right","Right to Left" },0,0
    },
    {
      "Envelope Time","",
      0,
      0.01,100.0,0.01,0.5,0.5,"secs","%.2lf",
      0,{ },0,0
    },
    {
      "Centre Predelay Time","Ch1",
      0,
      0.0,500.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Centre Predelay Time","Ch2",
      0,
      0.0,500.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Centre Envelope Form","",
      1,
      0.0,0.0,0.0,0.0,0.0,"","",
      3,{ "Linear","Exponential 1","Exponential 2" },0,0
    },
    {
      "Centre Envelope Direction","",
      1,
      0.0,0.0,0.0,0.0,0.0,"","",
      2,{ "Normal","Reverse", },0,0
    },
    {
      "Centre Envelope Time","",
      0,
      0.01,100.0,0.01,0.5,0.5,"secs","%.2lf",
      0,{ },0,0
    },
    {
      "Centre Output Level","",
      0,
      -100.0,100.0,1.0,20.0,20.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Release Time","",
      0,
      0.0,500.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    }
  }
};

effectType stereoDelay = 
{
  "Stereo Delay",
  9,
  {
    DELAY_TIME_CH1(300.0),
    DELAY_TIME_CH2(300.0),
    FEEDBACK_MODE(0),
    FEEDBACK_LEVEL_CH1(50.0),
    FEEDBACK_LEVEL_CH2(50.0),
    {
      "Low Pass Filter Frequency","Ch1",
      0,
      0.4,20.0,0.1,20.0,20.0,"kHz","%.2lf",
      0,{ },0,0
    },
    {
      "Low Pass Filter Frequency","Ch2",
      0,
      0.4,20.0,0.1,20.0,20.0,"kHz","%.2lf",
      0,{ },0,0
    },
    {
      "High Pass Filter Frequency","Ch1",
      0,
      0.02,6.3,0.02,0.02,0.02,"kHz","%.2lf",
      0,{ },0,0
    },
    {
      "High Pass Filter Frequency","Ch2",
      0,
      0.02,6.3,0.02,0.02,0.02,"kHz","%.2lf",
      0,{ },0,0
    }
  }
};

effectType modulatedDelay = 
{
  "Modulated Delay",
  12,
  {
    DELAY_TIME_CH1(300.0),
    DELAY_TIME_CH2(300.0),
    FEEDBACK_MODE(0),
    FEEDBACK_LEVEL_CH1(50.0),
    FEEDBACK_LEVEL_CH2(50.0),
    LFO_DEPTH_CH1(50.0),
    LFO_DEPTH_CH2(50.0),
    LFO_PHASE_DIFF(0.0),
    LFO_FREQ_CH1(5.0),
    LFO_FREQ_CH2(5.0),
    LFO_WAVEFORM_CH1(0),
    LFO_WAVEFORM_CH2(0)
  }
};

effectType multiTapDelay = 
{
  "Multi Tap Delay",
  31,
  {
    DELAY_TIME_CH1(1000.0),
    DELAY_TIME_CH2(1000.0),
    FEEDBACK_MODE(0),
    FEEDBACK_LEVEL_CH1(50.0),
    FEEDBACK_LEVEL_CH2(50.0),
    TAP_TIME_CH1("1",100.0),
    TAP_TIME_CH2("1",100.0),
    TAP_LEVEL_CH1("1",50.0),
    TAP_LEVEL_CH2("1",50.0),
    TAP_TIME_CH1("2",200.0),
    TAP_TIME_CH2("2",200.0),
    TAP_LEVEL_CH1("2",50.0),
    TAP_LEVEL_CH2("2",50.0),
    TAP_TIME_CH1("3",300.0),
    TAP_TIME_CH2("3",300.0),
    TAP_LEVEL_CH1("3",50.0),
    TAP_LEVEL_CH2("3",50.0),
    TAP_TIME_CH1("4",400.0),
    TAP_TIME_CH2("4",400.0),
    TAP_LEVEL_CH1("4",50.0),
    TAP_LEVEL_CH2("4",50.0),
    TAP_TIME_CH1("5",500.0),
    TAP_TIME_CH2("5",500.0),
    TAP_LEVEL_CH1("5",50.0),
    TAP_LEVEL_CH2("5",50.0),
    TAP_TIME_CH1("6",600.0),
    TAP_TIME_CH2("6",600.0),
    TAP_LEVEL_CH1("6",50.0),
    TAP_LEVEL_CH2("6",50.0),
    {
      "Delay Level","Ch1",
      0,
      -100.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Delay Level","Ch2",
      0,
      -100.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    }
  }
};

effectType multiDelay = 
{
  "Multi Delay",
  30,
  {
    FEEDBACKN_MODE("1",0),
    FEEDBACKN_LEVEL_CH1("1",50.0),
    FEEDBACKN_LEVEL_CH2("1",50.0),
    DELAYN_TIME_CH1("1",100.0),
    DELAYN_TIME_CH2("1",100.0),
    FEEDBACKN_MODE("2",0),
    FEEDBACKN_LEVEL_CH1("2",50.0),
    FEEDBACKN_LEVEL_CH2("2",50.0),
    DELAYN_TIME_CH1("2",200.0),
    DELAYN_TIME_CH2("2",200.0),
    FEEDBACKN_MODE("3",0),
    FEEDBACKN_LEVEL_CH1("3",50.0),
    FEEDBACKN_LEVEL_CH2("3",50.0),
    DELAYN_TIME_CH1("3",300.0),
    DELAYN_TIME_CH2("3",300.0),
    FEEDBACKN_MODE("4",0),
    FEEDBACKN_LEVEL_CH1("4",50.0),
    FEEDBACKN_LEVEL_CH2("4",50.0),
    DELAYN_TIME_CH1("4",400.0),
    DELAYN_TIME_CH2("4",400.0),
    FEEDBACKN_MODE("5",0),
    FEEDBACKN_LEVEL_CH1("5",50.0),
    FEEDBACKN_LEVEL_CH2("5",50.0),
    DELAYN_TIME_CH1("5",500.0),
    DELAYN_TIME_CH2("5",500.0),
    FEEDBACKN_MODE("6",0),
    FEEDBACKN_LEVEL_CH1("6",50.0),
    FEEDBACKN_LEVEL_CH2("6",50.0),
    DELAYN_TIME_CH1("6",600.0),
    DELAYN_TIME_CH2("6",600.0)
  }
};

effectType flanger = 
{
  "Flanger",
  18,
  {
    LFO_DEPTH_CH1(50.0),
    LFO_DEPTH_CH2(50.0),
    LFO_PHASE_DIFF(0.0),
    LFO_FREQ_CH1(5.0),
    LFO_FREQ_CH2(5.0),
    LFO_WAVEFORM_CH1(0),
    LFO_WAVEFORM_CH2(0),
//     {
//       "LFO Step","Ch1",
//       1,
//       0.0,0.0,0.0,0.0,0.0,"","",
//       2,{ "Off","On" },0,0
//     },
//     {
//       "LFO Step","Ch2",
//       1,
//       0.0,0.0,0.0,0.0,0.0,"","",
//       2,{ "Off","On" },0,0
//     },
//     {
//       "LFO Step Frequency","Ch1",
//       0,
//       0.01,100.0,0.01,0.01,0.01,"Hz","%.2lf",
//       0,{ },0,0
//     },
//     {
//       "LFO Step Frequency","Ch2",
//       0,
//       0.01,100.0,0.01,0.01,0.01,"Hz","%.2lf",
//       0,{ },0,0
//     },
    DELAY_TIME_CH1(100.0),
    DELAY_TIME_CH2(100.0),
    FEEDBACK_MODE(0),
    FEEDBACK_LEVEL_CH1(50.0),
    FEEDBACK_LEVEL_CH2(50.0),
    {
      "Flanger Delay Time","Ch1",
      0,
      0.0,50.0,1.0,25.0,25.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Flanger Delay Time","Ch2",
      0,
      0.0,50.0,1.0,25.0,25.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Flanger Resonance","Ch1",
      0,
      -100.0,100.0,1.0,0.0,0.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Flanger Resonance","Ch1",
      0,
      -100.0,100.0,1.0,0.0,0.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Delay Mix (0=dry 100=wet)","Ch1",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Delay Mix (0=dry 100=wet)","Ch2",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    }
  }
};

effectType phaser = 
{
  "Phaser",
  18,
  {
    LFO_DEPTH_CH1(50.0),
    LFO_DEPTH_CH2(50.0),
    LFO_PHASE_DIFF(0.0),
    LFO_FREQ_CH1(5.0),
    LFO_FREQ_CH2(5.0),
    LFO_WAVEFORM_CH1(0),
    LFO_WAVEFORM_CH2(0),
//     {
//       "LFO Step","Ch1",
//       1,
//       0.0,0.0,0.0,0.0,0.0,"","",
//       2,{ "Off","On" },0,0
//     },
//     {
//       "LFO Step","Ch2",
//       1,
//       0.0,0.0,0.0,0.0,0.0,"","",
//       2,{ "Off","On" },0,0
//     },
//     {
//       "LFO Step Frequency","Ch1",
//       0,
//       0.01,100.0,0.01,0.01,0.01,"Hz","%.2lf",
//       0,{ },0,0
//     },
//     {
//       "LFO Step Frequency","Ch2",
//       0,
//       0.01,100.0,0.01,0.01,0.01,"Hz","%.2lf",
//       0,{ },0,0
//     },
    DELAY_TIME_CH1(100.0),
    DELAY_TIME_CH2(100.0),
    FEEDBACK_MODE(0),
    FEEDBACK_LEVEL_CH1(50.0),
    FEEDBACK_LEVEL_CH2(50.0),
    {
      "Phaser Delay Time","Ch1",
      0,
      0.0,50.0,1.0,25.0,25.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Phaser Delay Time","Ch2",
      0,
      0.0,50.0,1.0,25.0,25.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Phaser Resonance","Ch1",
      0,
      -100.0,100.0,1.0,0.0,0.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Phaser Resonance","Ch1",
      0,
      -100.0,100.0,1.0,0.0,0.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Delay Mix (0=dry 100=wet)","Ch1",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Delay Mix (0=dry 100=wet)","Ch2",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    }
  }
};

effectType distortion = 
{
  "Distortion",
  4,
  {
    {
      "Gain","Ch1",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Gain","Ch2",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Distortion Type","",
      1,
      0.0,0.0,0.0,0.0,0.0,"","",
      2,{ "Valve","Tube" },0,0
    },
    {
      "Presence","",
      0,
      0.1,1.0,0.05,0.8,0.8,"","%.2lf",
      0,{ },0,0
    }
  }
};

effectType filter = 
{
  "Filter",
  5,
  {
    {
      "Filter Type","",
      1,
      0.0,0.0,0.0,0.0,0.0,"","",
      4,{ "Low Pass","High Pass","Band Pass","Band Reject" },0,0
    },
    {
      "Low Pass Cut Off","",
      0,
      0.02,20.0,0.02,10.0,10.0,"kHz","%.2lf",
      0,{ },0,0
    },
    {
      "High Pass Cut Off","",
      0,
      0.02,20.0,0.02,10.0,10.0,"kHz","%.2lf",
      0,{ },0,0
    },
    {
      "Band Pass/Reject Centre","",
      0,
      0.02,20.0,0.02,10.0,10.0,"kHz","%.2lf",
      0,{ },0,0
    },
    {
      "Band Pass/Reject Bandwidth","",
      0,
      0.02,20.0,0.02,10.0,10.0,"kHz","%.2lf",
      0,{ },0,0
    }
  }
};

effectType autoPan = 
{
  "Auto Pan",
  14,
  {
    LFO_DEPTH_CH1(50.0),
    LFO_DEPTH_CH2(50.0),
    LFO_PHASE_DIFF(0.0),
    LFO_FREQ_CH1(5.0),
    LFO_FREQ_CH2(5.0),
    LFO_WAVEFORM_CH1(0),
    LFO_WAVEFORM_CH2(0),
    DELAY_TIME_CH1(100.0),
    DELAY_TIME_CH2(100.0),
    FEEDBACK_MODE(0),
    FEEDBACK_LEVEL_CH1(50.0),
    FEEDBACK_LEVEL_CH2(50.0),
    {
      "Delay Mix (0=dry 100=wet)","Ch1",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Delay Mix (0=dry 100=wet)","Ch2",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    }
  }
};

effectType equalizer = 
{
  "Equalizer",
  32,
  {
    BANDN_FREQ_CH1("1",2.0),
    BANDN_FREQ_CH2("1",2.0),
    BANDN_GAIN_CH1("1",0.0),
    BANDN_GAIN_CH2("1",0.0),
    BANDN_RES_CH1("1",2.0),
    BANDN_RES_CH2("1",2.0),
    BANDN_FREQ_CH1("2",6.0),
    BANDN_FREQ_CH2("2",6.0),
    BANDN_GAIN_CH1("2",0.0),
    BANDN_GAIN_CH2("2",0.0),
    BANDN_RES_CH1("2",2.0),
    BANDN_RES_CH2("2",2.0),
    BANDN_FREQ_CH1("3",10.0),
    BANDN_FREQ_CH2("3",10.0),
    BANDN_GAIN_CH1("3",0.0),
    BANDN_GAIN_CH2("3",0.0),
    BANDN_RES_CH1("3",2.0),
    BANDN_RES_CH2("3",2.0),
    BANDN_FREQ_CH1("4",14.0),
    BANDN_FREQ_CH2("4",14.0),
    BANDN_GAIN_CH1("4",0.0),
    BANDN_GAIN_CH2("4",0.0),
    BANDN_RES_CH1("4",2.0),
    BANDN_RES_CH2("4",2.0),
    BANDN_FREQ_CH1("5",18.0),
    BANDN_FREQ_CH2("5",18.0),
    BANDN_GAIN_CH1("5",0.0),
    BANDN_GAIN_CH2("5",0.0),
    BANDN_RES_CH1("5",2.0),
    BANDN_RES_CH2("5",2.0),
    {
      "Total Level","Ch1",
      0,
      -24.0,12.0,1.0,0.0,0.0,"dB","%+.1lf",
      0,{ },0,0
    },
    {
      "Total Level","Ch2",
      0,
      -24.0,12.0,1.0,0.0,0.0,"dB","%+.1lf",
      0,{ },0,0
    }
  }
};

effectType gate = 
{
  "Gate",
  6,
  {
    {
      "Gate Time","Ch1",
      0,
      10.0,5000.0,10.0,500.0,500.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Gate Time","Ch2",
      0,
      10.0,5000.0,10.0,500.0,500.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Signal Threshold","Ch1",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Signal Threshold","Ch2",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Predelay Time","Ch1",
      0,
      0.0,1000.0,10.0,100.0,100.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Predelay Time","Ch2",
      0,
      0.0,1000.0,10.0,100.0,100.0,"msecs","%.1lf",
      0,{ },0,0
    }
  }
};

effectType compressorLimiter = 
{
  "Compressor / Limiter",
  6,
  {
    {
      "Mode","",
      1,
      0.0,0.0,0.0,0.0,0.0,"","",
      3,{ "Compress","Limit","Comp->Lim" },0,0
    },
    {
      "Compression Ratio","",
      0,
      0.01,100.0,0.01,1.0,1.0,"","%.2lf",
      0,{ },0,0
    },
    {
      "Compression Time","",
      0,
      10.0,1000.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Compression Threshold","",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    },
    {
      "Limiter Time","",
      0,
      10.0,1000.0,10.0,50.0,50.0,"msecs","%.1lf",
      0,{ },0,0
    },
    {
      "Limiter Threshold","",
      0,
      0.0,100.0,1.0,50.0,50.0,"%","%.1lf",
      0,{ },0,0
    }
  }
};

#endif //_DPTich_Effect_h

/***************************************************************************/
