/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_DSP.h
|
| Revision    : 1.0
| Date        : 15/05/96
|
| Object      : None
|
| Description : Effects function prototypes
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DPTich_DSP_h
#define _DPTich_DSP_h

#include "DPTich_main.h"

char *DSPReverberation
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPReverberation
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPGatedReverberation
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPGatedReverberation
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPStereoDelay
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPStereoDelay
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPModulatedDelay
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPModulatedDelay
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPMultiTapDelay
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPMultiTapDelay
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPMultiDelay
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPMultiDelay
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPFlanger
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPFlanger
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPPhaser
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPPhaser
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPDistortion
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPDistortion
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPFilter
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPFilter
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPAutoPan
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPAutoPan
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPEqualizer
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPEqualizer
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPGate
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPGate
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

char *DSPCompressor
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop);

char *DSPCompressor
  (DPSample *inputSample,DPSample *outputSample,long susLoop,long relLoop,
  long first,long channel_a,long channel_b);

double calcFeedbackTime (double feedback,double delayTime);

#endif //_DPTich_DSP_h

/***************************************************************************/
