/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPSampleXforms.h
|
| Revision    : 1.0
| Date        : 04/03/96
|
| Object      : Xforms sample
|
| Description : Xforms sample object header file
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DPSample_Xforms_h
#define _DPSample_Xforms_h

#include "DPTich_main.h"

#define FL_SAMPLE        2001
#define FL_NORMAL_SAMPLE 0
#define BORDERX          20
#define BORDERY          20
#define AXISSPACE        20
#define AXISTICKS        2
#define STEREOGAP        10
#define QUADROGAP        5
#define MONOGAP          10
#ifdef LINUX
#define AXISTEXTSIZE     9
#else
#define AXISTEXTSIZE     7
#endif

extern FL_OBJECT *fl_create_sample (
  int type,
  FL_Coord x,
  FL_Coord y, 
  FL_Coord w,
  FL_Coord h,
  const char *label);

extern FL_OBJECT *fl_add_sample (
  int type,
  FL_Coord x,
  FL_Coord y, 
  FL_Coord w,
  FL_Coord h,
  const char *label);

extern DPSample *fl_get_sample (FL_OBJECT *ob);
extern void fl_set_sample (FL_OBJECT *ob,DPSample *newSample);
extern long fl_get_sample_scroll (FL_OBJECT *ob);
extern void fl_set_sample_scroll (FL_OBJECT *ob,long newScroll);
extern long fl_get_sample_axis (FL_OBJECT *ob);
extern void fl_set_sample_axis (FL_OBJECT *ob,long newScroll);
extern long fl_get_sample_edit (FL_OBJECT *ob);
extern void fl_set_sample_edit (FL_OBJECT *ob,long newEdit);
extern long fl_get_sample_frames (FL_OBJECT *ob);
extern void fl_set_sample_frames (FL_OBJECT *ob,long newFrames);
extern long fl_get_sample_freehand (FL_OBJECT *ob);
extern void fl_set_sample_freehand (FL_OBJECT *ob,long newFreehand);
extern long fl_get_sample_drawmode (FL_OBJECT *ob);
extern void fl_set_sample_drawmode (FL_OBJECT *ob,long newDrawmode);
extern long fl_get_sample_drawaccuracy (FL_OBJECT *ob);
extern void fl_set_sample_drawaccuracy (FL_OBJECT *ob,long newDrawaccuracy);
extern long fl_get_sample_undomode (FL_OBJECT *ob);
extern void fl_set_sample_undomode (FL_OBJECT *ob,long newUndomode);
extern long fl_get_sample_autowindows (FL_OBJECT *ob);
extern void fl_set_sample_autowindows (FL_OBJECT *ob,long newAutowindows);
extern long fl_get_sample_autoglobals (FL_OBJECT *ob);
extern void fl_set_sample_autoglobals (FL_OBJECT *ob,long newAutoglobals);
extern long fl_get_sample_autoeditmode (FL_OBJECT *ob);
extern void fl_set_sample_autoeditmode (FL_OBJECT *ob,long newAutoeditmode);
extern long fl_get_sample_copysave (FL_OBJECT *ob);
extern void fl_set_sample_copysave (FL_OBJECT *ob,long newSavecopy);
extern long fl_get_sample_tooltips (FL_OBJECT *ob);
extern void fl_set_sample_tooltips (FL_OBJECT *ob,long newTooltips);
extern long fl_get_sample_rangealt (FL_OBJECT *ob);
extern void fl_set_sample_rangealt (FL_OBJECT *ob,long newRangealt);
extern long fl_get_sample_rangecross (FL_OBJECT *ob);
extern void fl_set_sample_rangecross (FL_OBJECT *ob,long newRangecross);
extern const char *fl_get_sample_tempdir (FL_OBJECT *ob);
extern void fl_set_sample_tempdir (FL_OBJECT *ob,const char *newTempdir);

int handle_sample (
  FL_OBJECT * ob,
  int event,
  FL_Coord mx,
  FL_Coord my,
  int key,
  void *xev);

#endif //_DPSample_Xforms_h

/***************************************************************************/
