/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPCrossButton.c
|
| Revision    : 1.0
| Date        : 27/06/97
|
| Object      : XForms Cross Button
|
| Description : XForms cross button code file
|
| (c) Richard Kent 1997
|
| $Id$
|
****************************************************************************/

static char DPCrossButton_c [] = "$Id$";

// NB ob->col1 is the color of the box.
//    ob->col2 is the color of cross

#include "forms.h"
#include "DPCrossButton.h"

typedef FL_BUTTON_STRUCT SPEC;

/*---------------------------------------------------------------------------
| FUNCTION fl_create_sample
---------------------------------------------------------------------------*/
static void drawCrossbutton (FL_OBJECT *ob)
{
  FL_Coord xx;
  FL_Coord yy;
  FL_Coord ww;
  FL_Coord hh;

  // If the redraw is demanded by FL_ENTER, ignore it
  if (((SPEC *) ob->spec)->event == FL_ENTER) return;

  // Draw the bounding box first
  fl_drw_box (ob->boxtype,ob->x,ob->y,ob->w,ob->h,ob->col1,ob->bw);

  // Draw the box that contains the cross
  ww = hh = (FL_min (ob->w,ob->h));
  xx = ob->x;
  yy = ob->y;

  // If pushed, draw a down box with the cross, else just an up box
  if (((SPEC *) ob->spec)->val)
  {
    fl_drw_box (FL_DOWN_BOX,xx,yy,ww,hh,ob->col1,ob->bw);
    fl_drw_text (FL_ALIGN_CENTER,xx,yy,ww,hh,ob->col2,0,0,"@9plus");
  }
  else
  {
    fl_drw_box (FL_UP_BOX,xx,yy,ww,hh,ob->col1,ob->bw);
  }

  // Draw the label and return marking
  if (ob->align == FL_ALIGN_CENTER)
    fl_drw_text (FL_ALIGN_LEFT,xx+ww+3,ob->y,0,ob->h,
      ob->lcol,ob->lstyle,ob->lsize,ob->label);
  else
    fl_draw_object_label_outside (ob);

  if (ob->type == FL_RETURN_BUTTON)
    fl_drw_text(FL_ALIGN_CENTER,
      (FL_Coord) (ob->x + ob->w - (0.8 * ob->h)),
      (FL_Coord) (ob->y + (0.2 * ob->h)),
      (FL_Coord) (0.6 * ob->h),
      (FL_Coord) (0.6 * ob->h),ob->lcol,0,0,"@returnarrow");
}

/*---------------------------------------------------------------------------
| FUNCTION fl_create_crossbutton
---------------------------------------------------------------------------*/
extern FL_OBJECT *fl_create_crossbutton (
  int type,
  FL_Coord x,
  FL_Coord y,
  FL_Coord w,
  FL_Coord h,
  const char *label)
{
  FL_OBJECT *ob;
  fl_add_button_class (FL_CROSSBUTTON,drawCrossbutton,0);
  ob = fl_create_generic_button (FL_CROSSBUTTON,type,x,y,w,h,label);
  ob->boxtype = FL_NO_BOX;
  ob->col2 = FL_BLACK;
  return ob;
}

/*---------------------------------------------------------------------------
| FUNCTION fl_add_crossbutton
---------------------------------------------------------------------------*/
extern FL_OBJECT *fl_add_crossbutton (
  int type,
  FL_Coord x,
  FL_Coord y,
  FL_Coord w,
  FL_Coord h,
  const char *label)
{
  FL_OBJECT *ob = fl_create_crossbutton (type,x,y,w,h,label);
  fl_add_object (fl_current_form,ob);
  return ob;
}

/***************************************************************************/
