/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: app_schema.h,v 1.2 1999/08/09 12:45:50 lamteam Exp $
 * 
 *	Function:	- application schema templates and constants
 */

#ifndef _APP_SCHEMA_H
#define _APP_SCHEMA_H

#include "all_list.h"
#include "app_mgmt.h"
#include "lam.h"

/*
 * GER (Guaranteed Envelope Resources)
 */
#ifndef MPI_GER
#define MPI_GER			8
#endif

/*
 * structures 
 */
struct apparg {
	int4		apa_refcount;		/* reference count */
	int4		apa_argc;		/* # cmd line args */
	char		**apa_argv;		/* cmd line args */
};

struct appenv {
	int4		ape_refcount;		/* reference count */
	char		**ape_envv;		/* cmd line args */
	char		*ape_wrkdir;		/* working dir */
};

struct aschema {
	int4		asc_srcnode;		/* binary source node */
	int4		asc_node;		/* single target node */
	int4		asc_proc_cnt;		/* # processes this entry */
	int4		asc_errno;		/* error code */
	LIST *		asc_nodelist;		/* nodes this entry */
	struct apparg *	asc_args;		/* cmd line args */
	struct appenv *	asc_env;		/* environment */
};

/*
 * prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

extern LIST *	asc_bufparse(char *buf, int size, int *pl, char **env);
extern LIST *	asc_parse(const char *file, int *pl, char **env);
extern LIST *	asc_schedule(LIST *ap);
extern void	asc_free(LIST *ap);
extern int	asc_compat(int *argc, char ***argv);
extern int	asc_run(LIST *ap, int np, int4 rtf, int v,
			int e, struct _gps *p);
extern int	asc_ger(LIST *ap, int e);
extern int	asc_environment(int export, char *v, char ***env);
extern int	asc_workdir(LIST *ap, char *wrkdir);

#ifdef __cplusplus
}
#endif

#endif	/* _APP_SCHEMA_H */
