(**
   Interface to some functions of the underlying UNIX system.
**)

MODULE VOLLInt [INTERFACE "C"];
(* C land ahead.  Enter at your own risk! *)

(*
    Interface to lowlevel stuff.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)


IMPORT
  C;

TYPE
  timeval* = RECORD
               tv_sec*  : C.longint;                   (* seconds *)
               tv_usec* : C.longint                    (* microseconds *)
             END;

  time_t* = C.longint;

  fd_setPtr* = POINTER TO fd_set;
  fd_set*    = RECORD
                 set* : ARRAY 8 OF SET; (* whats the reals size of fd_set? *)
               END;

  DIRPtr*    = POINTER TO DIR;
  DIR*       = RECORD
                 (* some code *)
               END;

  direntPtr* = POINTER TO dirent;
  dirent*    = RECORD
               END;

PROCEDURE select*(n : C.int; readfds, writefds, exceptfds : fd_setPtr; VAR timeval : timeval):C.int;

PROCEDURE opendir*(name : ARRAY OF CHAR):DIRPtr;
PROCEDURE closedir*(directory : DIRPtr);
PROCEDURE readdir*(directory : DIRPtr):direntPtr;

END VOLLInt.