/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include <vdkb/vdkb.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_prj.h>
#include <stdio.h>
#include <sys/stat.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_form.h>
#include <vdk/vdkutils.h>
#include <string.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_labelbutton.h>
#include <vdkb/vdkb_textlabel.h>
#include <vdkb/vdkb_frame.h>
#include <vdkb/vdkb_pixmap.h>
#include <vdkb/vdkb_scrolled.h>
#include <vdkb/vdkb_menubar.h>
#include <vdkb/vdkb_menuitem.h>
#include <vdkb/vdkb_textwidget.h>
#include <vdkb/vdkb_menu.h>
#include <vdkb/vdkb_paned.h>
#include <vdkb/vdkb_entry.h>
#include <vdkb/vdkb_notebook.h>
#include <vdkb/vdkb_pixbutton.h>
#include <vdkb/vdkb_toolbar.h>
#include <vdkb/vdkb_customlist.h>
#include <vdkb/vdkb_customtree.h>
#include <vdkb/vdkb_separator.h>
#include <vdkb/vdkb_table.h>
#include <vdkb/vdkb_rbgroup.h>
#include <vdkb/vdkb_handlebox.h>
#include <vdkb/vdkb_guicanvas.h>
#include <vdkb/vdkb_combo.h>
#include <vdkb/vdkb_checkbutton.h>
#include <vdkb/vdkb_radiobutton.h>
#include <vdkb/vdkb_spinbutton.h>
#include <vdkb/vdkb_pbar.h>
#include <vdkb/vdkb_custombutton.h>
#include <vdkb/vdkb_sbar.h>
#include <vdkb/vdkb_grid.h>
#include <vdkb/vdkb_packer.h>
#include <vdkb/vdkb_slider.h>
#include <vdkb/vdkb_pholder.h>
#include <vdkb/vdkb_fixed.h>
#include <vdkb/vdkb_gnomeappbar.h>
#include <vdkb/vdkb_dedit.h>
#include <vdkb/vdkb_gnomeentry.h>
#include <ctype.h>

static char buff[256];
extern VDKBuilder* TheApp;
/*
TABLE:
contains mapping between vdk class names
and static class members of each class
Used by parser to make widgets during
.frm parsing
 */
struct
{
  char *Class;
  char* (*create_source)(char* buffer,VDKBParser& parser);
  bool (*create_widget)(VDKBGuiForm* owner,
			char* buffer,VDKBParser& parser);
} vdkclass[] =

{
  // containers
  { "VDKBox", VDKBEventBox::CreateSource,
    VDKBEventBox::CreateWidget },
  { "VDKFrame",
    VDKBFrame::CreateSource, VDKBFrame::CreateWidget },
  { "VDKScrolled",
    VDKBScrolled::CreateSource, VDKBScrolled::CreateWidget },
  { "VDKPaned",
    VDKBPaned::CreateSource, VDKBPaned::CreateWidget },
  { "VDKMenubar",
    VDKBMenubar::CreateSource, VDKBMenubar::CreateWidget },
  { "VDKNotebook",
    VDKBGuiNotebook::CreateSource, VDKBGuiNotebook::CreateWidget },
  { "VDKToolbar",
    VDKBToolbar::CreateSource, VDKBToolbar::CreateWidget },
  { "VDKTable",
    VDKBTable::CreateSource, VDKBTable::CreateWidget },
  { "VDKRadioButtonGroup",
    VDKBRadioButtonGroup::CreateSource, VDKBRadioButtonGroup::CreateWidget },
  { "VDKHandleBox",
    VDKBHandleBox::CreateSource, VDKBHandleBox::CreateWidget },
  { "VDKPacker",
    VDKBPacker::CreateSource, VDKBPacker::CreateWidget },
  { "VDKFixed",
    VDKBFixed::CreateSource, VDKBFixed::CreateWidget },
  // buttons
  { "VDKLabelButton",
    VDKBLabelButton::CreateSource, VDKBLabelButton::CreateWidget },
  { "VDKPixmapButton",
    VDKBPixmapButton::CreateSource, VDKBPixmapButton::CreateWidget },
  { "VDKCheckButton",
    VDKBCheckButton::CreateSource, VDKBCheckButton::CreateWidget },
  { "VDKRadioButton",
    VDKBRadioButton::CreateSource, VDKBRadioButton::CreateWidget },
  { "VDKSpinButton",
    VDKBSpinButton::CreateSource, VDKBSpinButton::CreateWidget },
  { "VDKCustomButton",
    VDKBCustomButton::CreateSource, VDKBCustomButton::CreateWidget },
  // texts
  { "VDKLabel",
    VDKBTextLabel::CreateSource, VDKBTextLabel::CreateWidget },
  { "VDKText",
    VDKBTextWidget::CreateSource, VDKBTextWidget::CreateWidget },
  { "VDKEntry",
    VDKBEntry::CreateSource, VDKBEntry::CreateWidget },
  // misc
  { "VDKCanvas",
    VDKBGuiCanvas::CreateSource, VDKBGuiCanvas::CreateWidget },
  { "VDKPixmap",
    VDKBPixmap::CreateSource, VDKBPixmap::CreateWidget },
  { "VDKMenuItem",
    VDKBMenuItem::CreateSource, VDKBMenuItem::CreateWidget },
  { "VDKMenu",
    VDKBMenu::CreateSource, VDKBMenu::CreateWidget },
  { "VDKCustomList",
    VDKBCustomList::CreateSource, VDKBCustomList::CreateWidget },
  { "VDKCombo",
    VDKBCombo::CreateSource, VDKBCombo::CreateWidget },
  { "VDKCustomTree",
    VDKBGuiCustomTree::CreateSource, VDKBGuiCustomTree::CreateWidget },
  { "VDKSeparator",
    VDKBSeparator::CreateSource, VDKBSeparator::CreateWidget },
  { "VDKProgressBar",
    VDKBProgressBar::CreateSource, VDKBProgressBar::CreateWidget },
  { "VDKStatusbar",
    VDKBStatusbar::CreateSource, VDKBStatusbar::CreateWidget },
  { "VDKGrid",
    VDKBGrid::CreateSource, VDKBGrid::CreateWidget },
  { "VDKSlider",
    VDKBSlider::CreateSource, VDKBSlider::CreateWidget },
  { "VDKPlaceHolder",
    VDKBPlaceHolder::CreateSource, VDKBPlaceHolder::CreateWidget },
  // gnome
#if HAVE_GNOME
  { "VDKGnomeAppBar",
    VDKBGnomeAppBar::CreateSource, VDKBGnomeAppBar::CreateWidget },
  {"VDKGnomeDateEdit",
   VDKBGnomeDateEdit::CreateSource, VDKBGnomeDateEdit::CreateWidget },
  {"VDKGnomeEntry",
   VDKBGnomeEntry::CreateSource, VDKBGnomeEntry::CreateWidget },
#endif
  // map end
  { NULL,NULL,NULL }
};

//////////////////////////////////////////////////////////////////
/*
 */
char*
CreateSource(char* classname, char* buffer, VDKBParser& parser)
{
  int t;
  VDKBAbstractComponentInterface* interface = NULL;
  for(t=0; vdkclass[t].Class; t++)
    if(!strcmp(classname,vdkclass[t].Class))
      return vdkclass[t].create_source(buffer,parser);
  // statically unsopported widget
  // try to seek it into plugins list
  interface =
    TheApp->PluginList().Interface(classname);
  if(interface)
    return interface->CreateSource(buffer,parser);
  else
    return (char*) NULL;
}
/*
 */
bool
CreateWidget(VDKBGuiForm* owner, char* classname,
	     char* buffer, VDKBParser& parser)
{
  int t;
  VDKBAbstractComponentInterface* interface = NULL;
  for(t=0; vdkclass[t].Class; t++)
    if(!strcmp(classname,vdkclass[t].Class))
      return vdkclass[t].create_widget(owner,buffer,parser);
  // statically unsopported widget
  // try to seek it into plugins list
  interface =
    TheApp->PluginList().Interface(classname);
  if(interface)
    return interface->CreateWidget(owner,buffer,parser);
  else
    return false;
}

// in vdkb_object.cc
extern char* vdkbclass_names[];
extern int ClassTypeLookup(char* word);

//==============================
static void Filter(char* s, char* filter)
{
  bool flag = false;
  char* p = s;
  for(;*s;s++)
    {
      if(strchr(filter,*s))
	{
	  if(flag && (*s == ' '))
	    *p++ = *s;
	  if(*s == '\"')
	    flag = flag ? false : true;
	}
      else
	*p++ = *s;
    }
  *p = '\0';
}
////////////////////////////////////////
void
VDKBProject::WriteGuiHeaderParsingFrm(FILE* fp, char* fname)
{
  VDKBParser parser(fname);
  char arg[64];
  char* object;
  char obj_type[128];
  char obj_name[128];
  char slot[64];
  char declare[12];
  // has the parser correctly loaded and filtered fname ?
  if(! parser.Buffer())
    return;
  char* name;
  char* memname = new char[strlen(fname)+1];
  strcpy(memname,fname);
  char* p = get_shortfilename(memname);
  if(p)
    name = p;
  else
     {
      delete[] memname;
      return ;
    }
  p =  get_extension(name);
  if(p)
    *p = '\0';
  fprintf(fp,"/*\n%s gui header\n*/",name);
  fprintf(fp,"\nprotected:");
#if HAVE_GNOME
  //  if(Type == vdk_gnome_project)
  //  fprintf(fp,"\n\tVDKGnomeAppBar* gnome_bar;");
#endif
  // writes object pointers
  p = parser.Buffer();
  while( (p = strstr(p,"[object]")) )
    {
      sprintf(arg,"[object]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetObjectClass(object,obj_type) &&
	     parser.GetObjectName(object,obj_name))
	    {
	      // checks if is a place holder
	      if(!strcmp(obj_type,"VDKPlaceHolder"))
		{
		  // extract obj type from place holder ctor
		  char ctor[256];
		  *ctor = '\0';
		  if(parser.GetParam(ctor,object,"Ctor:"))
		     {
		       int t;
		       for(t=0; ctor[t] && ctor[t] != '('; t++);
		       ctor[t] = '\0';
		     }
		  if(*ctor)
		    strcpy(obj_type,ctor);
		}
	      // checks if is an event-aware box
	      else if(!strcmp(obj_type,"VDKBox") &&
		      parser.GetParam(arg,object,"event-aware:") &&
		      !strcmp(arg,CHECK_TRUE)
		      )
		strcpy(obj_type,"VDKEventBox");
	      // actually writes widget declaration
	      fprintf(fp,"\n%s*  %s;",obj_type,obj_name);
	    }
	  p+=strlen(object);
	  delete[] object;
	}
      else
	break;
  }
  p = parser.Buffer();
  // write form events handlers declaration
  object = parser.GetObject(name);
  if(object)
    {
      if(parser.GetParam(arg,object,"OnFormActivate:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnFormActivate(VDKForm* sender, bool in_out);");
      if(parser.GetParam(arg,object,"OnExpose:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnExpose(VDKForm* sender, GdkRectangle area);");
      if(parser.GetParam(arg,object,"OnShow:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnShow(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnChildClosing:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnChildClosing(VDKForm* child);");
      if(parser.GetParam(arg,object,"OnIconize:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnIconize(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnRestore:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnRestore(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnMove:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnMove(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnResize:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnResize(VDKForm* sender, VDKPoint& new_size);");
      if(parser.GetParam(arg,object,"OnConfigure:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnConfigure(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnRealize:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnRealize(VDKForm* sender);");
      delete[] object;
    }
  //
  fprintf(fp,"\npublic:");

  // write signal map declaration
  name[0] = toupper(name[0]);
  if( strstr(p,"[connect]"))
    fprintf(fp,"\nDECLARE_SIGNAL_MAP(%sForm);",name);
  p = parser.Buffer();
  // write response function declarations
  while( (p = strstr(p,"[connect]")) )
    {
      sprintf(arg,"[connect]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetParam(slot,object,"slot:") &&
	     parser.GetParam(declare,object,"declare:"))
	    {
	      if(atoi(declare))
		fprintf(fp,"\nbool %s(VDKObject* sender);",slot);
	    }
	  p+=strlen(object);
	  delete[] object;
	}
      else
	break;
    }
  fprintf(fp,"\n/*\ndeclaring signal and events\ndynamics tables\n*/");
  fprintf(fp,"\nDECLARE_SIGNAL_LIST(%sForm);",name);
  fprintf(fp,"\nDECLARE_EVENT_LIST(%sForm);",name);
  delete[] memname;
  fclose(fp);
}
/*
 */

void
VDKBProject::WriteGUIBoxesSetup(VDKBParser& parser, FILE* fp)
{
  char arg[64];
  char* object;
  char obj_name[128];
  char obj_type[64];
  char* source = NULL;
  //char* parent;
  char* p = parser.Buffer();
  while( (p = strstr(p,"[object]")) )
    {
      sprintf(arg,"[object]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetObjectClass(object,obj_type) &&
	     parser.GetObjectName(object,obj_name) &&
	    ( source = CreateSource(obj_type,p,parser) ))
	    {
	      fprintf(fp,source);
	      delete source;
	    }
	  p+=strlen(object);
	  delete[] object;
	}
      else
	break;
  }
}
////////////////////////////////////////
void
VDKBProject::WriteGUISetupParsingFrm(FILE* fp,
				     char* fname)
{
  VDKBParser parser(fname);
  char* property;
  // has the parser correctly loaded and filtered fname ?
  if(! parser.Buffer())
    return;
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  ///////////////////////////////
  // extract form name from fname
  char* name;
  char* memname = new char[strlen(fname)+1];
  strcpy(memname,fname);
  char* p = get_shortfilename(memname);
  if(p)
    name = p;
  else
     {
      delete memname;
      return ;
    }
  p = get_extension(memname);
  if(p)
    *p = '\0';

  fprintf(fp,"\n#include <%s.%s>",name,h_ext);
  name[0] = toupper(name[0]);
  // write static table
  fprintf(fp,"\n/*\ndefining signal and events\ndynamics tables\n*/");
  fprintf(fp,"\nDEFINE_SIGNAL_LIST(%sForm,%s);",
	  name,
	  Type == vdk_project ? "VDKForm" : "VDKForm" /*"VDKGnomeForm"*/);
  fprintf(fp,"\nDEFINE_EVENT_LIST(%sForm,%s);",
	  name,
	  Type == vdk_project ? "VDKForm" : "VDKForm" /*"VDKGnomeForm"*/);
  p = parser.Buffer();
  if(strstr(p,"[connect]"))
    {
      char* object;
      char slot[64];
      char sender[64];
      char signal[64];
      char arg[32];
      fprintf(fp,"\n/*\ndefining signal static table\n*/");
      fprintf(fp,"\nDEFINE_SIGNAL_MAP(%sForm,%s)",
	      name,
	      Type == vdk_project ? "VDKForm" : "VDKForm" /*"VDKGnomeForm"*/);
      bool flag = false;
      while( (p = strstr(p,"[connect]")) )
	{
	  sprintf(arg,"[connect]{");
	  object = ExtractSection(p,arg,"}");
	  if(object)
	    {
	      if(flag)
		fprintf(fp,",");
	      flag = true;
	      if(parser.GetParam(sender,object,"sender:") &&
		 parser.GetParam(signal,object,"signal:") &&
		 parser.GetParam(slot,object,"slot:"))
		{
		  sprintf(buff,"ON_SIGNAL(%s,%s,%s)",
			  sender, signal, slot);
		  fprintf(fp,"\n%s",buff);
		  p+=strlen(object);
		  delete object;
		}
	    }
	  else
	    break;
	}
      fprintf(fp,"\nEND_SIGNAL_MAP");
    }
  fprintf(fp,"\n/*\nmain form setup\n*/");
  fprintf(fp,"\nvoid\n%sForm::GUISetup(void)\n{",
	  name);
  name[0] = tolower(name[0]);
  /////////////////////////////////////////////
  char* object = parser.GetObject(name);
  if(!object)
    {
      // error, just write an useless form
      fprintf(fp,"\n/* default useless form */");
      fprintf(fp,"\n\tTitle = \"%s\";",name);
      fprintf(fp,"\n\tSetSize(400,300);");
      fprintf(fp,"\n}\n");
      fclose(fp);
      delete[] memname;
      return;
    }

  //////////////////////// BACKGROUND ///////////////////////////
  if( (property = parser.GetParam(buff,object,PROP_NORMALBACKGROUND))
     &&
     strcmp(property,NIHIL_PROP))
    fprintf(fp,"\n\tNormalBackground = VDKRgb(%s);",buff);
  //////////////////////// FOREGROUND ///////////////////////////
  if( (property = parser.GetParam(buff,object,PROP_FOREGROUND))
     &&
     strcmp(property,NIHIL_PROP))
    fprintf(fp,"\n\tForeground = VDKRgb(%s)",buff);
    //////////////////////// FONT ///////////////////////////
  if( (property = parser.GetParam(buff,object,PROP_FONT))
     &&
     strcmp(property,NIHIL_PROP))
    fprintf(fp,"\n\tFont = new VDKFont(this,\"%s\");",buff);
  //////////////////////// CURSOR ///////////////////////////
  if( (property = parser.GetParam(buff,object,PROP_CURSOR))
     &&
     strcmp(property,NIHIL_PROP))
    fprintf(fp,"\n\tCursor = %s;",buff);

  //////////////////////// SIZE ///////////////////////////
  VDKPoint pt = parser.Size(object);
  if(pt.X() > 0)
      fprintf(fp,"\n\tSetSize(%d,%d);",pt.X(),pt.Y());
  else
    fprintf(fp,"\n\tSetSize(400,300);");
   ////////////////////// TITLE ////////////////////////////
  if(parser.GetParam(buff,object,"Title:"))
    fprintf(fp,"\n\tTitle = \"%s\";",buff);
  else
    fprintf(fp,"\n\tTitle = \"%s\";",name);
  ////////////////////// GNOME APP BAR /////////////////////
#if HAVE_GNOME
  //  if(Type == vdk_gnome_project)
  //  fprintf(fp,"\n\tAdd(gnome_bar = new VDKGnomeAppBar(this));");
#endif
  ////////////////////// BACKGROUND PIXMAP//////////
  if(parser.GetParam(buff,object,PROP_BACKPIX) &&
     strcmp(buff,NIHIL_PROP))
    {
      fprintf(fp,"\nVDKRawPixmap* _backpix = new VDKRawPixmap(this,\"%s\");",
	      buff);
      fprintf(fp,"\nif(_backpix) BackgroundPixmap = _backpix ;");
    }
  ////////////////////////////////////////////////////
  WriteGUIBoxesSetup(parser,fp);
  ///////////////////////////////////////////////////
  ////////////////////// FOCUS WIDGET ///////////////
  if(parser.GetParam(buff,object,PROP_FOCUSWIDGET) &&
     strcmp(buff,NIHIL_PROP))
    fprintf(fp,"\n\tFocusWidget = %s;",buff);
  //////////////////////////////////////////////////
  fprintf(fp,"\n}\n");
  fclose(fp);
  delete[] object;
  delete[] memname;
}

/*
read form signal file
to load form signal list
 */
void
VDKBGuiForm::ReadSignals(VDKBParser& parser)
{
  char arg[64];
  char* object;
  char sender[64];
  char signal[64];
  char slot[64];
  char declare[16];
  char* p = parser.Buffer();
  SignalList.flush();
  while( (p = strstr(p,"[connect]")) )
    {
      sprintf(arg,"[connect]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetParam(sender,object,"sender:") &&
	     parser.GetParam(signal,object,"signal:") &&
	     parser.GetParam(slot,object,"slot:") &&
	     parser.GetParam(declare,object,"declare:"))
	    {
	      bool b = atoi(declare) == 1;
	      VDKBConnection c(sender,signal,slot,b);
	      SignalList.add(c);
	    }
	  p+=strlen(object);
	  delete[] object;
	}
      else
	break;
    }
}
///////////////////////////////////////
VDKBParser::~VDKBParser()
{
  if(buffer)
    delete[] buffer;
}
////////////////////////////////////////
VDKBParser::VDKBParser(char* fname):fname(fname)
{
  char* filter = "\n\t \"", *p;
  int c;
  FILE *fp = fopen(fname,"r");
  if(! fp)
    {
      buffer = NULL;
      return;
    }
  struct stat info;
  stat(fname,&info);
  unsigned int size = info.st_size;
  buffer = p = new char[size+1];
  while( (c = fgetc(fp)) != EOF)
    *p++ = (char) c;
  *p ='\0';
  fclose(fp);
  Filter(buffer,filter);
}
/*
 */
char*
VDKBParser::GetObject(char* name)
{
  char arg[64];
  sprintf(arg,"[%s]{",name);
  return ExtractSection(buffer,arg,"}");
}
/*
 */
char*
VDKBParser::GetWidget(char* name)
{
 char arg[128];
 sprintf(arg,"[object]{this:%s;",name);
 return ExtractSection(buffer,arg,"}");
}
/*
 */
char*
VDKBParser::GetObjectName(char* object,char* tgt)
{
return ExtractWord(object,tgt,"this:",";");
}
/*
 */
char*
VDKBParser::GetObjectClass(char* object,char* tgt)
{
return ExtractWord(object,tgt,PARSER_CLASS,";");
}
/*
 */
char*
VDKBParser::GetParam(
		     char* tgt, // target
		     char* object, // object buffer
		     char* param) // param name
{
  if(!object)
    return (char*) NULL;
  else
    return ExtractWord(object,tgt,param,";");

}
/*
 */
int
VDKBParser::ClassName(char* name)
{
  char local[64];
  char* object = GetObject(name);
  char* word = GetParam(local,object,PARSER_CLASS);
  if(word)
      return ClassTypeLookup(word);
  else
    return vdkbclass_none;
}
/*
 */
VDKPoint
VDKBParser::Size(char* object)
{
  char local[64];
  VDKPoint p;
  char* word = GetParam(local,object,PROP_USIZE);
  if(!word || !strcmp(word,NIHIL_PROP))
    return p;
  char* comma = strchr(word,',');
  if(comma)
    {
      *comma++= '\0';
      int x = atoi(word);
      int y = atoi(comma);
      p = VDKPoint(x,y);
    }
  return p;
}
/*
 */
VDKRgb
VDKBParser::Color(char*object, char* colortype)
{
  char local[64],*comma;
  VDKRgb rgb(-1,-1,-1);
  int red,green,blue;
  char* word = GetParam(local,object,colortype);
  if(!word || !strcmp(word,NIHIL_PROP))
    return rgb;
  comma = strchr(word,',');
  if(comma)
    {
      *comma++ = '\0';
      red = atoi(word);
      word = comma;
      comma = strchr(word,',');
      if(comma)
	{
	  *comma++= '\0';
	  green = atoi(word);
	  blue = atoi(comma);
	  rgb = VDKRgb(red,green,blue);
	  return rgb;
	}
    }
  return rgb;
}
/////////////////////////////////////////////////
//           CODE GENERATION
/////////////////////////////////////////////////
/*
 */
bool
VDKBParser::GetNameAndParent(char* pars_buff,			
			     char* obj_name,
			     char* obj_parent)
{
  if (
      !GetParam(obj_name,pars_buff,PARSER_THIS) ||
      !GetParam(obj_parent,pars_buff, PARSER_PARENT)
      )
    // this or parent not found
    return false;
  // no parent widget
  else  if(!strcmp(obj_parent,NIHIL_PROP))
    return false;
  return true;
}
/*

 */
void
VDKBParser::WriteCodeToPack(
			    char* obj_parent,
			    char* obj_name,
			    char* source,
			    char* buffer,
			    char* tmp)
{
 char justify[16],expand[16],fill[16],padding[16];

 if(GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
    GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
    GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
    GetParam(padding,buffer,PROP_PADDING_INTERNAL))
   {
     sprintf(tmp,"\n%s->%s(%s,%s,%s,%s,%s);",
	     obj_parent,
	     STATEMENT_ADD,
	     obj_name,justify,expand,fill,padding);
     strcat(source,tmp);
   }
 else
   {
     sprintf(tmp,"\n%s->%s(%s);",
	     obj_parent,
	     STATEMENT_ADD,
	     obj_name);
     strcat(source,tmp);
   }
}

/*
  visible property must be wrote after adding it to a parent
  container. That's the reason why is written here and not
  in vdkb_object class as should be. Written only if == false
 */
void
VDKBParser::WriteVisible(char* obj_name, char* arg,
			 char* source,	 char* buffer,
			 char* tmp)
{
  if(
     GetParam(arg,buffer,PROP_VISIBLE) &&
     !strcmp(arg,CHECK_FALSE)
     )
    {
      sprintf(tmp,"\n%s->%s = %s;",
	      obj_name,
	      STATEMENT_VISIBLE,
	      arg);
      strcat(source,tmp);
   }
}
