/*
 * ===========================
 * VDK Builder
 * Version 1.0.3
 * November 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include <vdkb/vdkb_orderdlg.h>

DEFINE_SIGNAL_MAP(Vdkb_reorderdlgForm,VDKForm)
  ON_SIGNAL(insertBtn,clicked_signal,OninsertBtnClick),
  ON_SIGNAL(cancelBtn,clicked_signal,OncancelBtnClick)
  END_SIGNAL_MAP
/*
main form setup
*/
void
Vdkb_reorderdlgForm::GUISetup(void)
{
  SetSize(150,210);
  Title = "Reordering widgets";
  vbox1 = new VDKBox(this,v_box);
  Add(vbox1,0,1,1,0);
  char* widgetListTitles[] = { "Contained widgets" };
  widgetList = new VDKCustomList(this,1,widgetListTitles,(GtkSelectionMode) 0);
    widgetList->SetSize(138,173);
  widgetList->BorderShadow = (GtkShadowType) shadow_in;
  vbox1->Add(widgetList,0,1,1,0);
  separator0 = new VDKSeparator(this,h_separator);
  separator0->Enabled = false;
  vbox1->Add(separator0,0,0,0,0);
  separator0->Visible = false;
  hbox2 = new VDKBox(this,h_box);
  vbox1->Add(hbox2,0,1,1,0);
  hbox2->BorderWidth(0);
  insertBtn = new VDKCustomButton(this,(char*) NULL,
				  "_Insert",16,(GtkPositionType) 0);
  insertBtn->SetTip(
"Select a widget, new widget will be inserted in that position");
  hbox2->Add(insertBtn,0,1,1,0);
  cancelBtn = new VDKCustomButton(this,(char*) NULL,
				  "_Cancel",16,(GtkPositionType) 0);
  hbox2->Add(cancelBtn,0,1,1,0);
}

/*
form constructor
*/
Vdkb_reorderdlgForm::Vdkb_reorderdlgForm(VDKForm* owner,
					 EventBoxList* boxlist,
					 int* pos,
					 char* title):
	VDKForm(owner,title),boxlist(boxlist),pos(pos)
{
}

/*
form destructor
*/
Vdkb_reorderdlgForm::~Vdkb_reorderdlgForm()
{
}


/*
form setup
*/
void
Vdkb_reorderdlgForm::Setup(void)
{
  GUISetup(); // vdkb gui setup
  // put your code below here
  EventBoxListIterator li(*boxlist);
  for(;li;li++)
    {
      VDKObject* obj = li.current();
      VDKBObject* vdkbobj = dynamic_cast<VDKBObject*>(obj);
      if(vdkbobj)
	{
	  char* widgetName = (char*) vdkbobj->Name();
	  widgetList->AddRow(&widgetName);
	}
    }
}

// signal response method 
bool
Vdkb_reorderdlgForm::OninsertBtnClick(VDKObject* sender)
{
  int selected = widgetList->Selected.Row();
  if(selected >= 0)
    *pos = selected;
  else
    *pos = -1;
  Close();
  return true;
}

// signal response method 
bool
Vdkb_reorderdlgForm::OncancelBtnClick(VDKObject* sender)
{
  *pos = -1;
  Close();
  return true;
}
