/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_menuitem_h
#define _vdkb_menuitem_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_widpopmenu.h>
#include <vdkb/vdkb_menubar.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBMenuItem: public VDKMenuItem,  public VDKBObject
{

 protected:
  VDKMenu* popmenu;
  //  VDKMenuItem *setsize,*delwidget;
  VDKEntry *pixfile,*caption;
  VDKCheckButton *checked;
  VDKLabelButton *shortname;
  VDKBObjectInspector* inspector; // object inspector
  bool DelBox(VDKObject* sender);
  bool SetBoxSize(VDKObject* sender);
  void InvokeMenuItemInspector();
 public:
  // weird here isn't a container but can have childs !!
  EventBoxList boxlist;
  bool Locked;
  static int Counter;
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  void AddWidget(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs);

  VDKBMenuItem(char* name, VDKForm* owner, char* prompt = NULL);
  virtual ~VDKBMenuItem() {}
  virtual int Type() { return vdkbclass_menuitem; }
  virtual char* VDKName() { return "VDKMenuItem"; }
  virtual int isA() { return vdkbclass_menuitem; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  bool DelWidget(VDKObject*);
  bool SetWidgetSize(VDKObject* sender);
  bool AddMenu(VDKObject* sender);
  void PopMenu() { popmenu->Popup(); }
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  bool OnSetGlyph(VDKObject*);
  bool OnSetShortName(VDKObject*);
  bool OnSetCaption(VDKObject*);
  bool OnSetChecked(VDKObject*);
  bool RepackWidget(VDKObject*);
  bool OnEnter(VDKObject* sender,GdkEvent* ev);
  bool OnLeave(VDKObject* sender,GdkEvent* ev);
  bool UnlockMenu(VDKObject* sender);
  bool ButtonPressed(VDKObject* sender,GdkEvent* ev);
  bool ButtonReleased(VDKObject* sender, GdkEvent* ev);
  bool SetProperties(VDKObject*);
  DECLARE_SIGNAL_LIST(VDKBMenuItem);
  DECLARE_EVENT_LIST(VDKBMenuItem);
};
#endif
