/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  SCTEXT_H
#define  SCTEXT_H
#include <vdkb/gtksctext.h>
#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>

/*
 */
class VDKSCTextFont
{
 public:
  GdkColor *foreground, *background;
  VDKFont* font;
  VDKSCTextFont(): foreground((GdkColor*) NULL),
    background((GdkColor*) NULL),
    font((VDKFont*) NULL) {}
  ~VDKSCTextFont() {}
};


class VDKSCText: public VDKObject
{
 protected:
 static int KeyEvent(GtkWidget *wid, GdkEventKey* ev,gpointer gp);
 protected:
  GtkWidget *text,*scrollbar;
 public:
  // properties
VDKSCTextFont TextFont;
VDKReadWriteValueProp<VDKSCText,bool>  WordWrap;
VDKReadWriteValueProp<VDKSCText,bool>  Editable;
VDKReadWriteValueProp<VDKSCText,int>   Pointer;
VDKReadOnlyValueProp<VDKSCText,unsigned int> Length;
bool Changed;
  VDKSCText(VDKForm* owner,bool editable = false, bool override = false);
  virtual ~VDKSCText();
  int LoadFromFile(char* filename);
  int SaveToFile(char* filename);
  virtual void SetBackground(VDKRgb color, 
			     GtkStateType state = GTK_STATE_NORMAL);
  virtual void SetFont(VDKFont* font);
  void TextInsert(char* text, int nchars = -1);
  void Freeze() { gtk_sctext_freeze(GTK_SCTEXT(text)); }
  void Thaw() { gtk_sctext_thaw(GTK_SCTEXT(text)); }
  void Eol() { TextInsert("\n"); }
  int  BackwardDelete(int nchars)
    { 
      Changed = true;
      return gtk_sctext_backward_delete(GTK_SCTEXT(text),nchars); 
    }
  int  ForwardDelete(int nchars)
    { 
      Changed = true;
      return gtk_sctext_forward_delete(GTK_SCTEXT(text),nchars); 
    }
  char* GetChars(int start, int end = -1)
    { return gtk_editable_get_chars(GTK_EDITABLE(text),start,end); }
  int GetPointer() { return gtk_sctext_get_point(GTK_SCTEXT(text)); }
  void SetPointer(int pos) { gtk_sctext_set_point(GTK_SCTEXT(text),pos); }
  bool GetWordWrap() { return WordWrap; }
  void SetWordWrap(bool flag)
    { gtk_sctext_set_word_wrap(GTK_SCTEXT(text),flag); }
  bool GetEditable () { return Editable; }
  void SetEditable(bool flag)
    { gtk_sctext_set_editable(GTK_SCTEXT(text),flag); }
  void Clear();
  unsigned int GetLength() 
    { return gtk_sctext_get_length(GTK_SCTEXT(text)); }
  
  
};
#endif
