/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: arraydef.c,v 1.43 1998/01/05 01:18:30 tiggr Exp $  */

tom_object
C4 (c_tom_, CP, ARRAY, _r_with_x)
  (tom_object self, selector cmd, ...)
{
  tom_object r;
  va_list ap;

  va_start (ap, cmd);
  r = array_with_elts (self, cmd, ap, ETD, sizeof (ET));
  va_end (ap);

  return r;
}

ET
C6 (i_tom_, CP, ARRAY, _, F, _at_i)
  (tom_object self, selector cmd, tom_int index)
{
  struct _es_i_tom_Array *this = trt_ext_address (self, _ei_i_tom_Array);

  check_index (self, index, this->length);

  return CONTENTS (this)[index];
}

tom_object
C4 (i_tom_Mutable, CP, ARRAY, _r_initWithCapacity_i)
  (tom_object self, selector cmd, tom_int cap)
{
  struct _es_i_tom_Array *this;
  struct _es_i_tom_MutableArray *that;

  this = trt_ext_address (self, _ei_i_tom_Array);
  that = trt_ext_address (self, _ei_i_tom_MutableArray);

  if (cap)
    CONTENTS (this) = xmalloc (cap * sizeof (ET));
  that->capacity = cap;

  return self;
}

ET
C6 (i_tom_Mutable, CP, ARRAY, _, F, _removeAt_i)
  (tom_object self, selector cmd, tom_int index)
{
  struct _es_i_tom_Array *this = trt_ext_address (self, _ei_i_tom_Array);
  ET previous;

  check_index (self, index, this->length);

  previous = CONTENTS (this)[index];
  if (this->length - index - 1)
    memmove (CONTENTS (this) + index, CONTENTS (this) + index + 1,
	     this->length - index - 1);
  this->length--;

  return previous;
}

void
C4 (i_tom_Mutable, CP, ARRAY, _v_removeElements__ii_)
  (tom_object self, selector cmd, tom_int start, tom_int length)
{
  array_remove_elements (self, start, length, sizeof (ET));
}

void
C4 (i_tom_Mutable, CP, ARRAY, _v_resize__ii_)
  (tom_object self, selector cmd, tom_int start, tom_int num)
{
  tom_int new_len;
  struct _es_i_tom_Array *this;
  struct _es_i_tom_MutableArray *that;

  this = trt_ext_address (self, _ei_i_tom_Array);
  that = trt_ext_address (self, _ei_i_tom_MutableArray);

  if (start < 0 || start > this->length || num < 0)
    trt_raise (0, self, cmd, c_tom_Conditions_program_condition,
	       "bad resize (%d, %d)", (int) start, (int) num);

  new_len = this->length + num;
  if (new_len > that->capacity)
    {
      this->contents = xrealloc (this->contents, new_len * sizeof (ET));
      that->capacity = new_len;
    }
  memmove (CONTENTS (this) + start + num, CONTENTS (this) + start,
	   (this->length - start) * sizeof (ET));
  BZERO (CONTENTS (this) + start, num * sizeof (ET));
  this->length = new_len;
}

void
C4 (i_tom_Mutable, CP, ARRAY, _v_swap__ii_)
  (tom_object self, selector cmd, tom_int i, tom_int j)
{
  struct _es_i_tom_Array *this;

  this = trt_ext_address (self, _ei_i_tom_Array);

  check_index (self, i, this->length);
  check_index (self, j, this->length);

  if (i != j)
    {
      ET a_i = CONTENTS (this)[i];
      ET a_j = CONTENTS (this)[j];

      CONTENTS (this)[i] = a_j;
      CONTENTS (this)[j] = a_i;
    }
}

void
C6 (i_tom_Mutable, CP, ARRAY, _v_set_, F, _at_i)
  (tom_object self, selector cmd, ET elt, tom_int index)
{
  struct _es_i_tom_MutableArray *that;
  struct _es_i_tom_Array *this;

  this = trt_ext_address (self, _ei_i_tom_Array);
  that = trt_ext_address (self, _ei_i_tom_MutableArray);

  check_index (self, index, this->length + 1);

  if (index >= that->capacity)
    {
      tom_int new_cap = that->capacity ? 2 * that->capacity : 4;
      VOID_CONTENTS (this) = xrealloc (CONTENTS (this), new_cap * sizeof (ET));
      BZERO (CONTENTS (this) + that->capacity,
	     (new_cap - that->capacity) * sizeof (ET));
      that->capacity = new_cap;
    }

#ifdef DO_ARRAY_METHODS
  elt = trt_assign_object_var (self, elt);
#endif

  CONTENTS (this)[index] = elt;
  if (index == this->length)
    this->length++;
}

void *
C4 (i_tom_, CP, ARRAY, __pi__pointerToElements__ii_)
     (tom_object self, selector cmd, tom_int start, tom_int len,
      tom_int *actual)
{
  struct _es_i_tom_Array *this = trt_ext_address (self, _ei_i_tom_Array);

  start = TRT_SEND ((int_imp), self, SEL (_ii__adjustRange__ii_),
		    start, len, &len);
  *actual = len;

  return len ? CONTENTS (this) + start : NULL;
}

tom_int
C3 (i_tom_, CP, Array_i_elementByteSize) (tom_object self, selector cmd)
{
  return sizeof (ET);
}

#ifndef NO_INIT_WITH_ENUMERATOR

tom_object
C4 (i_tom_, CP, ARRAY, _r_initWithEnumerator_r)
  (tom_object self, selector cmd, tom_object e)
{
  struct _es_i_tom_Array *this = trt_ext_address (self, _ei_i_tom_Array);
  int cap = 0;
  tom_byte b;
  ET o;

  for (;;)
    {
      b = TRT_SEND ((int_imp), e, SEL (C3 (_o, F, __next)), &o);
      if (!b)
	break;

      if (this->length == cap)
	{
	  int new_cap = cap ? cap * 2 : 8;

	  VOID_CONTENTS (this) = xrealloc (CONTENTS (this),
					   new_cap * sizeof (ET));
	  BZERO (CONTENTS (this) + cap, (new_cap - cap) * sizeof (ET));
	  cap = new_cap;
	}
      CONTENTS (this)[this->length++] = o;
    }

  return self;
}

#endif
