/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMVariable.m,v 1.25 1998/01/05 01:14:12 tiggr Exp $  */

#define OTMVARIABLE_DECLARE_PRIVATE_METHODS
#import "OTMVariable.h"
#import "OTMDynamicType.h"
#import "OTMMethod.h"
#import "OTMType.h"
#import "OTMTuple.h"
#import "OTMTypeTuple.h"
#import "global.h"

int next_tmp;

@implementation OTMVariable

+(OTMVariable *) variableWithName: (OTMTop *) n type: (OTMType *) t
{
  return [[self gcAlloc] initWithName: n type: t];
}

+(OTMVariable *) temporaryVariableWithType: (OTMType *) t
{
  return [self variableWithName: formac (nil, @"_%d_", next_tmp++) type: t];
}

-(BOOL) argumentp
{
  return NO;
}

-(BOOL) checkProperArgument: (OTMMethod *) m
{
  id p = [m argumentNamed: name];
  if (p)
    {
      error_for (self, @"redeclaration of `%@'", name);
      cerror_for (p, @"previous declaration was here");
    }
    
  if ([type isObjectType])
    [m setHaveStackReferences: self];

  return (type == the_dynamic_type);
}

-(void) compileAddressListWithFirst: (id <TLString>) f
			  separator: (id <TLString>) s
{
  formac (of, @"%@&%@", f, [self outputReference]);
}

-(void) compileAssignment: (OTMExpr *) rhs
{
  if ([(OTMType *) type isTuple])
    {
      /* We can not have a tuple type.  */
      ABORT ();
    }
  else
    formac (of, @"%@%@ = %@;", [self nlPlain], [self outputReference],
	    [rhs result]);
}

-(void) description: (id <TLMutableStream>) stream
{
  [super description: stream];
  formac (stream, @" name=%# type=%@", name, type_name ((id) type));
}

-(void) gcReference
{
  MARK (name);
  [super gcReference];
}

-(id) initWithName: (id) n type: (OTMType *) t
{
  if (![super initWithType: t])
    return nil;

  name = n;

  return self;
}

-(OTMExpr *) lhsInvalid
{
  return nil;
}

-(id <TLString>) variableName
{
  return name;
}

-(id) outputDeclaration: (id) stream;
{
  return formac (stream, @"%@ %@", [(OTMType *) type outputTypeName],
		 [self outputName]);
}

-(id <TLString>) outputName
{
  return quote (name);
}

-(id) outputReference
{
  return quote (name);
}

-(BOOL) residesInRefStruct
{
  return NO;
}

-(id <TLString>) result
{
  return [self outputReference];
}

@end
