/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMUnwind.m,v 1.5 1998/01/05 01:14:07 tiggr Exp $  */

#define OTMUNWIND_DECLARE_PRIVATE_METHODS
#import "OTMUnwind.h"
#import "OTMBasic.h"

@implementation OTMUnwind

+(OTMUnwind *) unwindWithProtection: (OTMExpr *) t container: (OTMCompound *) c
{
  return [[self gcAlloc] initWithProtection: t container: c];
}

-(void) compileCondition: (BOOL) end_not_start
{
  if (!end_not_start)
    {
      formac (of, @"%@/* BEGIN START OF UNWIND  */", [self nl]);
      formac (of, @"%@void%@_unwind (void)%@{",
	      [self nl], [self nl], [self nl]);
      indent_level++;
      [protection compile];
      indent_level--;
      formac (of, @"%@}%@struct trt_unwind _unwind_info;",
	      [self nl], [self nl]);
      formac (of, @"%@_unwind_info.c.kind = TRT_CONDITION_KIND_UNWIND;",
	      [self nl]);
      formac (of, @"%@_unwind_info.protect = _unwind;", [self nl]);

      formac (of, @"%@trt_register (&_unwind_info.c);", [self nl]);
      formac (of, @"%@/* FINISH START OF UNWIND  */", [self nl]);
    }
  else
    {
      formac (of, @"%@/* BEGIN END OF UNWIND  */", [self nl]);
      formac (of, @"%@trt_unwind (&_unwind_info.c);", [self nl]);
      formac (of, @"%@_unwind ();", [self nl]);
      formac (of, @"%@/* FINISH END OF UNWIND  */", [self nl]);
    }
}

-(void) gcReference
{
  MARK (protection);

  [super gcReference];
}

-(id) initWithProtection: (OTMExpr *) p container: (OTMCompound *) c;
{
  [super initWithContainer: c];

  protection = p;

  return self;
}

@end
