/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMType.m,v 1.32 1998/04/06 11:56:41 tiggr Exp $  */

#import "OTMType.h"
#import "OTMTypeTuple.h"

@implementation OTMType

-(BOOL) allowedTypeForArgumentRedeclaration: (OTMType *) t
				 inSubclass: (BOOL) subclass_p
{
  return NO;
}

-(void) compileDeclaration
{
}

-(int) elementCount
{
  return 1;
}

-equal: (OTMType *) o
{
  return self == o ? self : nil;
}

-equalTypeTuple: (OTMTypeTuple *) t
{
  TLVector *v = [t elements];

  /* A singleton tuple matches the type of its single element.  */
  if ([v length] == 1)
    return [[v _elementAtIndex: 0] equal: self];
  return nil;
}

-(int) flatElementCount
{
  return 1;
}

-(id <TLString>) flatFrobnicatedName
{
  return [self frobnicatedName];
}

-(BOOL) isFullyDefinedType
{
  return YES;
}

-(BOOL) isObjectType
{
  return NO;
}

-(BOOL) isTuple
{
  return NO;
}

-(BOOL) matches: (OTMType *) t
{
  return NO;
}

-(OTMType *) matchesExactly: (OTMType *) t
{
  return self == t ? self : nil;
}

-(OTMType *) matchesExactlyMeta: (OTMMeta *) t
{
  return nil;
}

-(int) minimumAlignment
{
  return 0;
}

-(id <TLString>) outputCastName
{
  return [self outputTypeName];
}

-(id <TLString>) outputTypeEncoding
{
  return nil;
}

-(id) precompile
{
  return self;
}

-(OTMType *) tupleSingleElement
{
  return self;
}

-(OTMType *) tupleFirstFlatElement
{
  return self;
}

-(OTMType *) typeAt: (int) index in: (int *) indices
{
  return index < 0 ? self : nil;
}

-(id <TLString>) typeInfo
{
  ABORT ();
}

-(id <TLString>) typeName
{
    ABORT ();
}

-(BOOL) validCastTo: (OTMType *) type
{
  return type == self;
}

-(id <TLString>) outputTypeName
{
  [self subclassResponsibility: _cmd];
}

-(id <TLString>) frobnicatedName
{
  [self subclassResponsibility: _cmd];
}

-(int) matchesConvertibly: (OTMType *) t
{
  [self subclassResponsibility: _cmd];
}

@end
