/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMStringCST.m,v 1.9 1998/01/05 01:13:50 tiggr Exp $  */

#define OTMSTRINGCST_DECLARE_PRIVATE_METHODS
#import "OTMStringCST.h"
#import "OTMType.h"

@implementation LTTStringCST (Semantics)

+(id) semanticsForString: (LTTStringCST *) s
{
  return [[CO_OTMStringCST gcAlloc] initWithStructure: s];
}

@end

@implementation OTMStringCST

-(BOOL) constantp
{
  return YES;
}

-(void) gcReference
{
  MARK (structure);

  [super gcReference];
}

-initWithStructure: (LTTStringCST *) str
{
  if (![super initWithType: (OTMType *) tom_string_instance])
    return nil;

  structure = str;

  return self;
}

-outputReference
{
  return [structure outputReferenceName];
}

-(id) precompile
{
  if (![self declarationOutputp])
    {
      [self setDeclarationOutputP: YES];

      [used_strings setObject: structure forKey: [structure string]];

      [super precompile];

      formac (of, @"extern %@ %@;\n", [type outputTypeName],
	      [structure outputReferenceName]);
    }

  return self;
}

-(id <TLString>) result
{
  return [self outputReference];
}

-(LTTStringCST *) structure
{
  return structure;
}

@end
