/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMLoop.m,v 1.16 1998/01/05 01:13:17 tiggr Exp $  */

#import "OTMLoop.h"
#import "OTMLabel.h"
#import "OTMBasic.h"
#import "OTMBreak.h"
#import "OTMBuiltinMethod.h"
#import "OTMITE.h"

@implementation OTMLoop

+(OTMLoop *) loopWithContainer: (id) c
{
  return [[self gcAlloc] initWithContainer: c];
}

-(void) compile
{
  formac (of, @"%@for (;;) ", [self nl]);

  [super compile];
}

-(void) compileCondition: (BOOL) end_not_start
{
  if (condition && !end_not_start == !post_not_pre)
    [condition compile];
}

-(OTMLabel *) continueLabel
{
  return continue_label;
}

-(id) elaborate
{
  [super elaborate];

  if (!post_not_pre && result && result != void_expr)
    {
      /* Set the default value if the loop is never executed even once.  */
      emit_assignment (result, nil_something_with_type ([result type]));
    }    

  return self;
}

-(void) gcReference
{
  MARK (condition);
  MARK (continue_label);

  [super gcReference];
}

-(OTMLoop *) loopForContinue: (int) level
{
  if (level--)
    return [container loopForContinue: level];

  if (!continue_label)
    continue_label = [[OTMLabel alloc] init];

  return self;
}

-(void) setBreakValue: (OTMExpr *) e
{
  [self assignResult: e];
}

-(void) setCondition: (OTMExpr *) e
	       atEnd: (BOOL) end_not_start
{
  OTMITE *ite;

  if (e)
    {
      condition = current_compound
	= [CO_OTMCompound compoundWithContainer: self];

      ite = [CO_OTMITE iteWithCondition:
	     resolve_expr (op_invocation1 (builtin_operator_name[BO_NOT], e),
			   CONS (basic_type[BT_BOOLEAN], nil), nil,
			   [current_either semantics])];
      [ite setThen: (id) [CO_OTMBreak jumpStatement]];
      [(OTMCompound *) condition addStatement: [ite elaborate]];
      current_compound = self;
    }

  post_not_pre = end_not_start;
}

-(void) startLoopEnd
{
  if (continue_label)
    emit_statement (continue_label);
}

@end
