/*
   Written by Pieter J. Schoenmakers <tiggr@gerbil.org>

   Copyright (C) 1996, 1999 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMBind.m,v 1.13 1999/09/27 15:34:29 tiggr Exp $  */

#define OTMBIND_DECLARE_PRIVATE_METHODS
#import "OTMBind.h"
#import "OTMError.h"
#import "OTMInstance.h"
#import "OTMTuple.h"
#import "OTMTypeTuple.h"

@implementation OTMBind

+(OTMBind *) bindWithContainer: (OTMCompound *) c
{
  return [[self gcAlloc] initWithContainer: c];
}

-(void) compileCondition: (BOOL) end_not_start
{
  if (!end_not_start)
    {
      int i, n = [handlers length];

      formac (of, @"%@/* BEGIN START OF BIND  */", [self nl]);
      if (!flag_suppress_conditions)
	{
	  formac (of, @"%@void *%@_handler (int _i, void *condition)%@{",
		  [self nl], [self nl], [self nl]);
	  indent_level++;
	  formac (of, @"%@switch (_i)%@{", [self nl], [self nl]);
	  indent_level++;

	  for (i = 0; i < n; i++)
	    {
	      OTMExpr *handler = [[handlers _elementAtIndex: i] cdr];

	      indent_level--;
	      formac (of, @"%@case %d:", [self nl], i);
	      indent_level++;

	      [handler compile];
	      formac (of, @"%@return %@;", [self nl], [handler result]);
	    }

	  indent_level--;
	  formac (of, @"%@default:", [self nl]);
	  indent_level++;
	  formac (of, @"%@abort ();%@return 0;", [self nl], [self nl]);

	  indent_level--;
	  formac (of, @"%@}", [self nl]);
	  indent_level--;
	  formac (of, @"%@}", [self nl]);
	}

      formac (of, @"%@struct trt_bind *_bind_info = alloca (sizeof *_bind_info"
	      @" + %d * sizeof _bind_info->handlers[0]);", [self nl], n);
      formac (of, @"%@_bind_info->c.kind = TRT_CONDITION_KIND_BIND;"
	      @"%@_bind_info->num = %d;", [self nl], [self nl], n);
      formac (of, @"%@_bind_info->tomc_handler = %s;", [self nl],
	      flag_suppress_conditions ? "0" : "_handler");

      for (i = 0; i < n; i++)
	{
	  OTMExpr *c = [[handlers _elementAtIndex: i] car];

	  [c compile];

	  formac (of, @"%@_bind_info->handlers[%d].condition_class = %@;",
		  [self nl], i, [c result]);
	}

      formac (of, @"%@trt_register (&_bind_info->c);", [self nl]);
      formac (of, @"%@/* FINISH START OF BIND  */", [self nl]);
    }
  else
    {
      formac (of, @"%@/* BEGIN END OF BIND  */", [self nl]);
      formac (of, @"%@trt_unwind (&_bind_info->c);", [self nl]);
      formac (of, @"%@/* FINISH END OF BIND  */", [self nl]);
    }
}

-(void) gcReference
{
  MARK (handlers);

  [super gcReference];
}

-(id) precompile
{
  [tom_condition_instance precompile];

  return [super precompile];
}

-(void) setHandlers: (TLCons *) hl
{
  static TLCons *ecc_tuple;

  if (!ecc_tuple)
    ecc_tuple = CONS (([CO_OTMTypeTuple typeTupleWithSequence:
			[CO_TLVector vectorWithElements: 2,
			 tom_condition_class_instance, the_any_ref_type]]),
		      nil);

  handlers = [CO_TLVector vector];

  if (hl == (id) an_error)
    ;
  else if (!hl)
    warning (@"no handlers in bind");
  else while (hl)
    {
      OTMExpr *ch, *c, *h;
      TLVector *v;

      DECONS (hl, ch, hl);

      ch = resolve_expr (ch, ecc_tuple, nil, [current_either semantics]);
      if ([ch isTuple])
	{
	  v = [(OTMTuple *) ch elements];

	  c = [[v _elementAtIndex: 0] elaborate];

	  current_compound = [CO_OTMCompound compoundWithContainer:
			      current_compound];

	  h = [[v _elementAtIndex: 1] elaborate];
	  emit_statement (h);
	  [current_compound setValue: [h value]];

	  current_compound = [current_compound container];

	  [handlers addElement: CONS (c, h)];
	}
    }
}

@end
