/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMBasic.h,v 1.14 1998/01/05 01:12:10 tiggr Exp $  */

#import "OTMEntity.h"

enum basic_type
{
  BT_VOID,
  BT_BOOLEAN,
  BT_BYTE,
  BT_CHAR,
  BT_INT,
  BT_LONG,
  BT_FLOAT,
  BT_DOUBLE,
  BT_POINTER,
  BT_SELECTOR,
  BT_RECV,
  BT_RECV_CLASS,
  BT_RECV_INST,

  BT_NUM
};

#define BTS_VOID	(1 << BT_VOID)
#define BTS_BOOLEAN	(1 << BT_BOOLEAN)
#define BTS_BYTE	(1 << BT_BYTE)
#define BTS_CHAR	(1 << BT_CHAR)
#define BTS_INT		(1 << BT_INT)
#define BTS_LONG	(1 << BT_LONG)
#define BTS_FLOAT	(1 << BT_FLOAT)
#define BTS_DOUBLE	(1 << BT_DOUBLE)
#define BTS_POINTER	(1 << BT_POINTER)
#define BTS_SELECTOR	(1 << BT_SELECTOR)
#define BTS_RECV	(1 << BT_RECV)
#define BTS_RECV_CLASS	(1 << BT_RECV_CLASS)
#define BTS_RECV_INST	(1 << BT_RECV_INST)

#define BT_INT_SET		(BTS_BYTE | BTS_CHAR | BTS_INT | BTS_LONG)
#define BT_FLOAT_SET		(BTS_FLOAT | BTS_DOUBLE)
#define BT_NUMBER_SET		(BT_INT_SET | BT_FLOAT_SET)
#define BT_REFERENCE_SET	(BTS_RECV | BTS_RECV_CLASS | BTS_RECV_INST)

#define BT_ANY_NOT_VOID_SET	(BTS_BOOLEAN | BT_NUMBER_SET | BTS_POINTER \
				 | BTS_SELECTOR | BT_REFERENCE_SET)

#define BT_ANY_SET		(BT_ANY_NOT_VOID_SET | BTS_VOID)

@class OTMBasic;

/* The basic (builtin) types, indexed by the BASIC_TYPE enum.  */
extern OTMBasic *basic_type[BT_NUM];

@interface OTMBasic: OTMEntity
{
  enum basic_type type;
}

+(void) init;

-(enum basic_type) basicKind;

/* @protected */

-initWithName: (TLString *) n type: (enum basic_type) t;

@end
