<copyright> Number classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: numbers.t,v 1.22 1998/01/05 01:07:42 tiggr Exp $</id>  </copyright>

implementation class
ByteNumber: Number
end;

implementation instance
ByteNumber
{
  byte value;
}

extern byte
  byteValue;
extern char
  charValue;
extern double
  doubleValue;
extern float
  floatValue;
extern int
  intValue;
extern long
  longValue;

int
  compare Number n
{
  = -[n compare value];
}

int
  compare byte v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare char v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare int v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare long v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare float v
{
  = float (value) == v ? 0 : float (value) > v ? 1 : -1;
}

int
  compare double v
{
  = double (value) == v ? 0 : double (value) > v ? 1 : -1;
}

// Every XNumber class should only have an init wethod for the X type.
// Thu Mar 13 13:20:29 1997, tiggr@akebono.ics.ele.tue.nl
extern id
  init byte value;
extern id
  init char value;
extern id
  init int value;
extern id
  init long value;
extern id
  init float value;
extern id
  init double value;

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [ByteNumber self]])
    {
      [super encodeUsingCoder coder];
      [coder encode value];
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [ByteNumber self]])
    {
      [super initWithCoder coder];
      value = [coder decode];
    }
}

OutputStream
  write OutputStream s
{
  = [s print value];
}

end;

implementation class
CharNumber: Number
end;

implementation instance
CharNumber
{
  char value;
}

extern byte
  byteValue;
extern char
  charValue;
extern double
  doubleValue;
extern float
  floatValue;
extern int
  intValue;
extern long
  longValue;

int
  compare Number n
{
  = -[n compare value];
}

int
  compare byte v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare char v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare int v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare long v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare float v
{
  = float (value) == v ? 0 : float (value) > v ? 1 : -1;
}

int
  compare double v
{
  = double (value) == v ? 0 : double (value) > v ? 1 : -1;
}

extern id
  init byte value;
extern id
  init char value;
extern id
  init int value;
extern id
  init long value;
extern id
  init float value;
extern id
  init double value;

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [CharNumber self]])
    {
      [super encodeUsingCoder coder];
      [coder encode value];
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [CharNumber self]])
    {
      [super initWithCoder coder];
      value = [coder decode];
    }
}

OutputStream
  write OutputStream s
{
  = [s print value];
}

end;

implementation class
IntNumber: Number
end;

implementation instance
IntNumber
{
  int value;
}

extern byte
  byteValue;
extern char
  charValue;
extern double
  doubleValue;
extern float
  floatValue;
extern int
  intValue;
extern long
  longValue;

int
  compare Number n
{
  = -[n compare value];
}

int
  compare byte v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare char v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare int v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare long v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare float v
{
  = float (value) == v ? 0 : float (value) > v ? 1 : -1;
}

int
  compare double v
{
  = double (value) == v ? 0 : double (value) > v ? 1 : -1;
}

extern id
  init byte value;
extern id
  init char value;
extern id
  init int value;
extern id
  init long value;
extern id
  init float value;
extern id
  init double value;

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [IntNumber self]])
    {
      [super encodeUsingCoder coder];
      [coder encode value];
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [IntNumber self]])
    {
      [super initWithCoder coder];
      value = [coder decode];
    }
}

OutputStream
  write OutputStream s
{
  = [s print value];
}

end;

implementation class
LongNumber: Number
end;

implementation instance
LongNumber
{
  long value;
}

extern byte
  byteValue;
extern char
  charValue;
extern double
  doubleValue;
extern float
  floatValue;
extern int
  intValue;
extern long
  longValue;

int
  compare Number n
{
  = -[n compare value];
}

int
  compare byte v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare char v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare int v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare long v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare float v
{
  = double (value) == v ? 0 : double (value) > v ? 1 : -1;
}

int
  compare double v
{
  = double (value) == v ? 0 : double (value) > v ? 1 : -1;
}

extern id
  init byte value;
extern id
  init char value;
extern id
  init int value;
extern id
  init long value;
extern id
  init float value;
extern id
  init double value;

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [LongNumber self]])
    {
      [super encodeUsingCoder coder];
      [coder encode value];
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [LongNumber self]])
    {
      [super initWithCoder coder];
      value = [coder decode];
    }
}

OutputStream
  write OutputStream s
{
  = [s print value];
}

end;

implementation class
FloatNumber: Number
end;

implementation instance
FloatNumber
{
  float value;
}

extern byte
  byteValue;
extern char
  charValue;
extern double
  doubleValue;
extern float
  floatValue;
extern int
  intValue;
extern long
  longValue;

int
  compare Number n
{
  = -[n compare value];
}

int
  compare byte v
{
  = value == float (v) ? 0 : value > float (v) ? 1 : -1;
}

int
  compare char v
{
  = value == float (v) ? 0 : value > float (v) ? 1 : -1;
}

int
  compare int v
{
  = value == float (v) ? 0 : value > float (v) ? 1 : -1;
}

int
  compare long v
{
  = value == double (v) ? 0 : value > double (v) ? 1 : -1;
}

int
  compare float v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare double v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

extern id
  init byte value;
extern id
  init char value;
extern id
  init int value;
extern id
  init long value;
extern id
  init float value;
extern id
  init double value;

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [FloatNumber self]])
    {
      [super encodeUsingCoder coder];
      [coder encode value];
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [FloatNumber self]])
    {
      [super initWithCoder coder];
      value = [coder decode];
    }
}

OutputStream
  write OutputStream s
{
  = [s print value];
}

end;

implementation class
DoubleNumber: Number
end;

implementation instance
DoubleNumber
{
  double value;
}

extern byte
  byteValue;
extern char
  charValue;
extern double
  doubleValue;
extern float
  floatValue;
extern int
  intValue;
extern long
  longValue;

int
  compare Number n
{
  = -[n compare value];
}

int
  compare byte v
{
  = value == double (v) ? 0 : value > double (v) ? 1 : -1;
}

int
  compare char v
{
  = value == double (v) ? 0 : value > double (v) ? 1 : -1;
}

int
  compare int v
{
  = value == double (v) ? 0 : value > double (v) ? 1 : -1;
}

int
  compare long v
{
  = value == double (v) ? 0 : value > double (v) ? 1 : -1;
}

int
  compare float v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

int
  compare double v
{
  = value == v ? 0 : value > v ? 1 : -1;
}

extern id
  init byte value;
extern id
  init char value;
extern id
  init int value;
extern id
  init long value;
extern id
  init float value;
extern id
  init double value;

void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [DoubleNumber self]])
    {
      [super encodeUsingCoder coder];
      [coder encode value];
    }
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [DoubleNumber self]])
    {
      [super initWithCoder coder];
      value = [coder decode];
    }
}

OutputStream
  write OutputStream s
{
  = [s print value];
}

end;
