<copyright> Unit class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Unit.t,v 1.5 1998/01/05 01:07:28 tiggr Exp $</id>
    </copyright>

implementation class
Unit: State
{
  <doc> All units known.  </doc>
  static MutableDictionary units;
}

<doc> Return the {Unit} with the {name}, or {nil} if said unit does not
    currently exist.  </doc>
instance (id)
  named String name
{
  if (!units)
    [self fillUnits];

  = units[name];
}

<doc> Create the {units} dictionary and fill it with the currently known
    units.  </doc>
protected extern void
  fillUnits
pre
  !units;

<doc> Return the collection of units, keyed on their name.  </doc>
Mapped
  units
{
  if (!units)
    [self fillUnits];

  = units;
}

end;

implementation instance
Unit
{
  <doc> The name of this unit.  </doc>
  public String name;

  <doc> The classes in this unit, keyed on their unqualified name.  </doc>
  Dictionary classes;
}

<doc> Designated initializer.  </doc>
protected id (self)
  initWithName String n
       classes Dictionary c
{
  (name, classes) = (n, c);
}

<doc> Return the class with the given unqualified {name}, or {nil} if a
    class with that name does not exist in this unit.  </doc>
class (State)
  classNamed String name
{
  = classes[name];
}

end;
