<copyright> Set and MutableSet classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Set.t,v 1.21 1999/09/10 22:15:25 miro Exp $</id>
    </copyright>

/******************** Set ********************/

implementation class
Set: HashTable, Keyed

end;

implementation instance
Set

<doc> Invoke {HashTable}'s implementation.  </doc>
Any
  member All object
{
  return [super (HashTable) member object];
}

<doc> Invoke {HashTable}'s implementation.  </doc>
Any
  memq All object
{
  return [super (HashTable) memq object];
}

/********** Enumerable **********/

<doc> Return an enumerator on the receiving set.  </doc>
Enumerator
  enumerator
{
  = [SetEnumerator with buckets];
}

Enumerator
  keyEnumerator
{
  = [self enumerator];
}

end;

/******************** MutableSet ********************/

implementation class
MutableSet: Set, MutableHashTable, MutableKeyed, Container

end;

implementation instance
MutableSet

/********** MutableKeyed **********/

void
  add All object
{
  int inc = 1, bucket = [object hash] * GOLDEN_BITS >>> (32 - size_shift);
  BucketSetElement bucket_elt = buckets[bucket];

  if (!bucket_elt)
    buckets[bucket] = [[BucketSetElement alloc] initWith object];
  else
    inc = [bucket_elt add object];

  if (inc != 0)
    [self adjust_length inc];
}

<doc> Remove {elt} from the receiving set, if present.  </doc>
void
  remove All object
{
  int bucket = [object hash] * GOLDEN_BITS >>> (32 - size_shift);
  BucketSetElement bucket_elt = buckets[bucket];

  if (bucket_elt != nil)
    {
      BucketSetElement new_bucket_elt;
      int decrease;

      (new_bucket_elt, decrease) = [bucket_elt remove object];
      if (decrease != 0)
	{
	  // Should we shrink?
	  // Mon Dec  1 13:57:34 1997, tiggr@natlab.research.philips.com
	  length -= decrease;
	  if (new_bucket_elt != bucket_elt)
	    buckets[bucket] = new_bucket_elt;
	}
    }
}

end;

/******************** SetEnumerator ********************/

implementation class
SetEnumerator: HashTableEnumerator

end;

implementation instance
SetEnumerator
{
  redeclare BucketSetElement elt;
}

/********** Enumerator **********/

(boolean, Any) (valid, object)
  next
{
  valid = [super next];
  if (valid)
    object = [elt key];
}

end;
