<copyright> Selector class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Selector.t,v 1.11 1998/04/22 12:35:52 tiggr Exp $</id>
    </copyright>

// Map them, put them in a container, etc.
// Wed Apr 22 12:30:55 1998, tiggr@gerbil.org
<doc> A {Selector} is an object wrapper for a selector.  </doc>
implementation class
Selector: State

instance (id)
  with selector sel
{
  = [[self alloc] init sel];
}

end;

implementation instance
Selector
{
  <doc> The selector which we wrap.  </doc>
  selector sel;
}

<doc> Designated initializer.  </doc>
id (self)
  init selector s
{
  sel = s;
}

<doc> Return the identity of the selector.  </doc>
extern int
  hash;

boolean
  equal id other
{
  = [Runtime selector sel equals [other selector]];
}

<doc> Return the name of the selector.  </doc>
String
  name
{
  = [Runtime nameOfSelector sel];
}

<doc> Return the selector we wrap.  </doc>
selector
  selector
{
  = sel;
}

/********** Coding methods **********/
<doc> <h4>Coding methods</h4> </doc>

<doc> Encode the receiving {Selector} object.  This writes the name of the
    selector as the means of identifying the selector upon decoding.  (The
    selector itself can't be written since encoding a selector actually
    encodes a {Selector} object.)  </doc>
void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [Selector self]])
    {
      [super encodeUsingCoder coder];
      [coder encode [Runtime nameOfSelector sel]];
    }
}

<doc> Initialize the receiving {Selector} from the {coder}.  </doc>
void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [Selector self]])
    {
      [super initWithCoder coder];
      sel = [Runtime selectorNamed [coder decode]];
    }
}

end;
