<copyright> Dictionary and MutableDictionary classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Dictionary.t,v 1.26 1999/09/10 22:15:25 miro Exp $</id>
    </copyright>

/******************** DictionaryContainer ********************/

<doc> A {DictionaryContainer} is a class which can be inherited by
    {Dictionary}-like objects, to allow them to be a container, with
    respect to their value objects.  It is a seperate class, for
    inheritance by the {PointerDictionary} class.  </doc>
implementation class
DictionaryContainer: Container

end;

implementation instance
DictionaryContainer

end;

/******************** ObjectDictionary ********************/

<doc> An {ObjectDictionary} is a {Dictionary} mapping objects to objects.
    It is the superclass of {Dictionary} and {EqDictionary}.  The latter
    hash the key objects on their address, and uses pointer equivalence.
    </doc>
implementation class
ObjectDictionary: HashTable, Mapped, DictionaryContainer

end;

implementation instance
ObjectDictionary

<doc> Evaluate the {block} for each key.  </doc>
void
  doKeys Block block
{
  // When Tesla is the one and only TOM compiler, this is easy:
  // [buckets do |{ BucketElement b || if (b != nil) [b doKeys block]; }|];
  // Wed Sep  8 21:29:06 1999, tiggr@gerbil.org
  int i, n = 1 << size_shift;

  for (i = 0; i < n; i++)
    {
      BucketDictElement elt = buckets[i];
      if (elt != nil)
	[elt doKeys block];
    }
}

<doc> Return a {valueEnumerator}.  </doc>
Enumerator
  enumerator
{
  = [self valueEnumerator];
}

<doc> Invoke {HashTable}'s implementation.  </doc>
Any
  member All object
{
  return [super (HashTable) member object];
}

<doc> Invoke {HashTable}'s implementation.  </doc>
Any
  memq All object
{
  return [super (HashTable) memq object];
}

<doc> Return an enumerator on the keys of this dictionary.  </doc>
Enumerator
  keyEnumerator
{
  = [SetEnumerator with buckets];
}

<doc> Return an enumerator on the values of this dictionary.  </doc>
DictionaryEnumerator
  valueEnumerator
{
  = [DictionaryValueEnumerator with buckets];
}

OutputStream
  write OutputStream s
{
  Enumerator e = [self keyEnumerator];
  boolean b;
  All o;

  s = [s print ('(', [isa name])];

  while ({(b, o) = [e next]; b;})
    s = [s print (" (", o, ' ', self[o], ')')];

  = [s print ')'];
}

end;

/******************** Dictionary ********************/

implementation class
Dictionary: ObjectDictionary

end;

implementation instance
Dictionary
      
/********** Keyed **********/

/********** Mapped **********/

end;

/******************** MutableDictionary ********************/

implementation class
MutableDictionary: Dictionary, MutableHashTable, MutableMapped

end;

implementation instance
MutableDictionary

/********** MutableKeyed **********/

<doc> Remove the mapping for the {key}.  </doc>
void
  remove All key
{
  int inc = 1, bucket = [key hash] * GOLDEN_BITS >>> (32 - size_shift);
  BucketDictElement bucket_elt = buckets[bucket];

  if (!!bucket_elt)
    {
      BucketDictElement ne;
      int delta;

      (ne, delta) = [bucket_elt remove key];

      if (ne != bucket_elt)
	buckets[bucket] = ne;

      length -= delta;
    }
}

/********** MutableMapped **********/

void
  add All object
{
  [super (MutableMapped) add object];
}

void
  set All value
   at All key
pre
  value != nil && key != nil
{
  int inc = 1, bucket = [key hash] * GOLDEN_BITS >>> (32 - size_shift);
  BucketDictElement bucket_elt = buckets[bucket];

  if (!bucket_elt)
    buckets[bucket] = [[BucketDictElement alloc] initWith (key, value)];
  else
    inc = [bucket_elt add (key, value)];

  if (inc != 0)
    [self adjust_length inc];
}

end;

/******************** DictionaryEnumerator ********************/

implementation class
DictionaryEnumerator: HashTableEnumerator, MapEnumerator

end;

implementation instance
DictionaryEnumerator
{
  redeclare BucketDictElement elt;
}

(boolean, Any, Any) (valid, k, v)
  next
{
  valid = [super(HashTableEnumerator) next];
  if (valid)
    (k, v) = ([elt key], [elt value]);
}

end;

/******************** DictionaryValueEnumerator ********************/

implementation class
DictionaryValueEnumerator: DictionaryEnumerator

end;

implementation instance
DictionaryValueEnumerator

/********** Enumerator **********/

(boolean, Any) (valid, object)
  next
{
  valid = [super next];
  if (valid)
    object = [elt value];
}

end;
