<copyright> Descriptor class.  UNIX files and socket abstraction.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Descriptor.t,v 1.8 1998/02/06 14:16:47 tiggr Exp $</id>
    </copyright>

<doc> A {Descriptor} is the abstraction of the UNIX file descriptor.
    </doc>
implementation class
Descriptor: State, Conditions

end;

implementation instance
Descriptor
{
  <doc> The file descriptor.  This will be -1 if we're not actively open.
      </doc>
  public int descriptor;
}

<doc> Close this descriptor.  If it succeeds, every read, write, or other
    operation afterwards will certainly fail.  If it fails, this may not
    be the case.  </doc>
void
  close
{
  [stdio close descriptor];

  descriptor = -1;
}

<doc> Close the {descriptor} if it is not {-1}.  </doc>
void
  dealloc
{
  if (descriptor != -1)
    bind ((stream-error, nil))
      [self close];
}

<doc> Invoke {[self init -1]} to avoid ever closing file descriptor 0 by
    accident.  </doc>
id
  init
{
  = [self init -1];
}

<doc> Designated initializer: Initialize with {fd} as the {descriptor}.
    </doc>
protected id
  init int fd
{
  descriptor = fd;

  = self;
}

<doc> Return one of the {FILE_TYPE_*} constants for the receiving File.
    Signal a {file_error} and return {FILE_TYPE_NONEXISTENT} if not open.
    </doc>
extern int
  type-of-file;

end;
