<copyright> TOM unit constants.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Constants.t,v 1.8 1998/02/06 14:16:46 tiggr Exp $</id>
    </copyright>

<doc> The constants used throughout the tom unit.  </doc>
implementation class
Constants
{
  <doc><h4>{Trie} constants</h4></doc>
  <doc> The plain option indicates absence of other options.  </doc>
  const TRIE_PLAIN	   = 0;
  <doc> Reverse the string before insertion or lookup.  </doc>
  const TRIE_REVERSED      = 1;
  <doc> Ignore the case during a lookup; use lower-case characters
      during an insert.  </doc>
  const TRIE_FOLD_CASE	   = 2;
  <doc> Do not require a full match in a lookup; the longest prefix will
      match with this option specified.  </doc>
  const TRIE_LOOKUP_PREFIX = 4;

  <doc> <h4>Open flags</h4>  </doc>
  <doc> If the file exists, do nothing (and return nil).  </doc>
  const FILE_EXIST_NOTHING = 1;

  <doc> If the file exists, raise a condition.  </doc>
  const FILE_EXIST_RAISE = 2;

  <doc> If the file exists and {output_p}, truncate it to zero length.  </doc>
  const FILE_EXIST_TRUNCATE = 4;

  <doc> If the file exists and {output_p}, a new version of the file will
      be created (by unlinking the old file first).  </doc>
  const FILE_EXIST_SUPERSEDE = 8;

  <doc> If the file does not exist, do nothing (and return nil).  If only
      {input_p}, {nil} will also be returned if it can't be opened anyway.
      </doc>
  const FILE_NOT_EXIST_NOTHING = 0x10;

  <doc> If the file does not exist, raise a condition.  </doc>
  const FILE_NOT_EXIST_RAISE = 0x20;

  <doc> If the file does not exist and {output_p}, create it.  </doc>
  const FILE_NOT_EXIST_CREATE = 0x40;

  <doc> Every write will append to the end of the file.  </doc>
  const FILE_APPEND = 0x80;

  <doc> A mask for the above flags.  </doc>
  const FILE_MASK = 0xff;

  <doc> Retrieving information about a file.  </doc>
  const FILE_TYPE_NONEXISTENT = 0;
  const FILE_TYPE_OTHER = 1;
  const FILE_TYPE_SOCKET = 2;
  const FILE_TYPE_LINK = 3;
  const FILE_TYPE_REGULAR = 4;
  const FILE_TYPE_BLOCK = 5;
  const FILE_TYPE_DIRECTORY = 6;
  const FILE_TYPE_CHARACTER = 7;
  const FILE_TYPE_FIFO = 8;

  <doc> <h4>Positioning a {SeekableStream}</h4> </doc>
  <doc> Position absolute.  </doc>
  const STREAM_SEEK_SET = 0;
  <doc> Position relative to the current position.  </doc>
  const STREAM_SEEK_CUR = 1;
  <doc> Position relative to the end of the file.  </doc>
  const STREAM_SEEK_END = 2;

  <doc> <h4>{TypeDescription} types.</h4> </doc>
  /* These must match the {trt_type_encoding} in `tom/trt.h'.  */
  <doc> This value indicates the {void} type.  The other values follow the
      same naming convention.  </doc>
  const TYPEDESC_VOID = 0;
  const TYPEDESC_BOOLEAN = 1;
  const TYPEDESC_BYTE = 2;
  const TYPEDESC_CHAR = 3;
  const TYPEDESC_INT = 4;
  const TYPEDESC_LONG = 5;
  const TYPEDESC_FLOAT = 6;
  const TYPEDESC_DOUBLE = 7;
  const TYPEDESC_POINTER = 8;
  const TYPEDESC_SELECTOR = 9;
  const TYPEDESC_REFERENCE = 10;
  const TYPEDESC_DYNAMIC = 11;
  <doc> This is not a real type; it merely denotes the number of
      {TYPEDESC_} values.  </doc>
  const TYPEDESC_NUM = 12;
}

end;

implementation instance
Constants

end;
