<copyright> BucketIntDictElement class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: BucketIntDictElement.t,v 1.6 1998/01/05 01:05:00 tiggr Exp $</id>
    </copyright>

implementation class
BucketIntDictElement: BucketElement

end;

implementation instance
BucketIntDictElement
{
  <doc> This bucket element's key.  </doc>
  public int key;

  <doc> The value in this bucket element.  </doc>
  public Any value;
}

<doc> Designated initializer.  </doc>
id
  initWith (int, All) (k, v)
{
  (key, value) = (k, Any (v));
  = self;
}

<doc> Return the value associated with the key {k}, asking the {next}
    element if this element does not match.

    The implementation by {BucketIntDictElement}, considers its {key} and
    returns its {value}.  </doc>
Any
  member int k
{
  = key == k ? value : !next ? nil : [next member k];
}

Any
  memq int k
{
  = [self member k];
}

<doc> Add the {(k, v)} pair to this bucket, if the key is not already
    present.  Return the number by which this bucket's length has
    increased.  </doc>
int
  add (int, All) (k, v)
{
  if (k == key)
    value = Any (v);
  else if (!next)
    {
      next = [[isa alloc] initWith (k, v)];
      = 1;
    }
  else
    = [next add (k, v)];
}

<doc> Add the {(k, v)} pair to this bucket, if the key is not already
    present.  Return the number by which this bucket's length has
    increased.  </doc>
int
  addq (int, All) (k, v)
{
  = [self add (k, v)];
}

<doc> Return the integer key.  </doc>
int
  rehash
{
  = key;
}

<doc> Return the integer key.  </doc>
int
  rehashq
{
  = key;
}

<doc> Remove the object with the key {k}.  Return the replacement for this
    element, and the number of bucket elements that were removed from this
    bucket list (max 1).  </doc>
(id, int)
  remove int k
{
  int n;

  if (key == k)
    return (next, 1);

  if (next != nil)
    (next, n) = [next remove k];

  return (self, n);
}

<doc> Starting with this bucket element, remove the objects of which the
    {value} is {gc_dead}.  Return the replacement for this element, and
    the number of bucket elements that were removed from this bucket list.
    </doc>
(id, int)
  gc_mark_values
{
  int n;

  if (next != nil)
    (next, n) = [next gc_mark_values];

  if ([value gc_dead_p])
    return (next, n + 1);

  return (self, n);
}

end;
