/* Interface to TLSyslogStream class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLSyslogStream.h,v 1.1 1998/01/08 16:13:42 tiggr Exp $  */

#import "TLObject.h"
#import "TLStream.h"
#import <stdio.h>

@interface TLSyslogStream: TLObject <TLStream, TLOutputStream>
{
  int priority, num, cap;
  char *buf;

  /* The prefix we log before any line we output.  */
  id prefix;
}

+(void) initializeFacility: (int) fac
 ident: (id <TLString>) ident options: (int) opt;

+(id <TLStream, TLOutputStream>) streamWithPriority: (int) prio;

#ifdef TLSYSLOGSTREAM_DECLARE_PRIVATE_METHODS

-initWithPriority: (int) prio;

#endif

@end
