/* Interface to TLStringStream class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLStringStream.h,v 1.1 1998/01/08 16:13:39 tiggr Exp $  */

#import "TLObject.h"
#import "TLStream.h"
#import "TLMutableString.h"
#import <stdio.h>

/* Abstract class.  */
@interface TLStringStream: TLObject
{
  /* No instance variables declared here.  */
}

+(id <TLInputStream, TLSeekableStream>) streamWithString: (id <TLString>) s;
+(id <TLMutableStream>) mutableStreamWithString: (TLMutableString *) s;

@end

@interface TLConstantStringStream: TLStringStream <TLStream, TLSeekableStream,
						   TLInputStream>
{
  id <TLString> string;

  /* The *cached* cString and length of the STRING.  */
  char *c_string;
  int len;

  /* The offset of the next character to be read.  */
  int next;
}

-initWithString: (id <TLString>) string;

@end

@interface TLMutableStringStream: TLStringStream <TLStream, TLMutableStream>
{
  TLMutableString *string;

  /* The offset of the next character to be read.  */
  int next;
}

-initWithString: (TLMutableString *) string;

@end
