/* Interface to TLLTag class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLLTag.h,v 1.1 1998/01/08 16:13:25 tiggr Exp $  */

#import <setjmp.h>
#import "TLSymbol.h"
#import "TLLSubroutine.h"

/* Some symbols.  */
extern TLSymbol *Qerror_conditions, *Qerror, *Qno_catch, *Qeof;

/* Subroutine interface to the tags.  */
extern id Fcatch (id in_args);
extern id Fthrow (id tag, id value);
extern id Funwind_protect (id in_args);
extern id Fcondition_case (id in_args);
extern id Fsignal (id symbol, id data);

@interface TLLTag: TLObject
{
  /* The tag to be caught for a catch.  The symbol to be bound to the error
     data for a condition-case.  NIL for an unwind-protect.  */
  id tag;

  /* The unwind-protect forms.  NIL for a catch or condition-case.  */
  id unwind_forms;

  /* The condition-case handler list.  NIL for a catch or unwind-protect.  */
  id handlers;

  /* The next tag.  */
  TLLTag *next;

  /* Value to be returned after resuming normal operation.  */
  id value;

  /* The top of the binding stack the moment this tag was created.  */
  binding_stack_level binding_level;

  /* Where to jump back to if this catch is thrown.  */
  jmp_buf catch;

#if SUPPORT_DEBUG
  /* The number of invocations on the invocation stack the moment this tag
     was created.  */
  invocation_stack_level stack_level;
#endif
}

/* No user servicable parts inside.  Use the subroutines described above.  */

+protect: body tag: the_tag unwind: cleanup_form;

+protect: body symbol: var handlers: the_handlers;

#ifdef TLLTAG_DECLARE_PRIVATE_METHODS

+initialize;

-initWithBody: body_form tag: evaluated_tag
       unwind: cleanup_form handlers: list;

-(void) catch: arg_tag value: arg_value;

-(void) raise: sym context: data;

-(TLLTag *) tagCatching: sym;

-throw: arg_tag value: arg_value;

-(void) gcReference;

#endif

@end
