/* Interface to TLCons class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLCons.h,v 1.1 1998/01/08 16:13:10 tiggr Exp $  */

#import "TLObject.h"
#import "TLStream.h"
#import "TLEnumerator.h"

@class TLSymbol;

/* The cons class, cached.  */
extern id tlcons_class;

/* Easy consing.  */
#define CONS(A, B)  ([tlcons_class cons: (A) : (B)])

/* Easy dissection in the absence of a NIL object.  */
#define DECONS(CONS, CAR, CDR)  \
  do							\
    {							\
      if (CONS) [(CONS) car: &(CAR) cdr: &(CDR)];	\
      else { CAR = nil; CDR = nil; }			\
    } while (0)

@interface TLCons: TLObject
{
  id car;
  TLCons *cdr;
}

/* Return a newly allocated instance with CAR and CDR.  */
+(TLCons *) cons: car : cdr;

+(TLCons *) listWithEnumerator: (id <TLEnumerator>) e;

+(TLCons *) listWithSequence: (id) s;

/* Initialize a new instance with CAR and CDR.  */
-initWithCar: car cdr: cdr;

/* Return CAR.  */
-car;

/* Return CDR.  */
-cdr;

/* Return the CAR and CDR.  */
-(void) car: (id *) a cdr: (id *) d;

/* Set CDR to [CDR delq: O] and return CDR if (O == CAR), otherwise return
   SELF.  */
-delq: o;

/* Like `-delq:', but only delete at most N times.  */
-delq: o count: (unsigned int) n;

/* Return a TLCons enumerator.  This seems rather weird as Lisp has all
   kinds of wonderful ways to walk over lists, but this is the Objective-C
   way, which we should support.  */
-(id <TLEnumerator>) enumerator;

-eval;
-evalWithArguments: (TLCons *) args;

-(int) length;
-objectLength;

/* Return the length of this list, not counting `-memq:' members of LIST.  */
-(int) _lengthWithoutMembersOf: (TLCons *) list;

/* Apply SYM to CAR returning the result as the CAR of a new TLCons object,
   with CDR being the result of applying the same method to CDR.  */
-mapcar: (TLSymbol *) sym;

/* Return the list whose CAR is ELT.  Otherwise return NIL.  */
-memq: elt;

/* Replace the end of the list with O.  */
-nconc: o;

/* Like `-print', but precede with a space.  All other objects (through the
   root patches) will precede with ` . ').  */
-(void) printListElement: (id <TLMutableStream>) stream quoted: (BOOL) qp;

/* Direct modification.  */
-rplaca: o;
-rplacd: o;
-(void) setCar: o;
-(void) setCdr: o;

@end
