/* Interface to TLBufferedMutableStream class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLBufferedMutableStream.h,v 1.1 1998/01/08 16:13:09 tiggr Exp $  */

#ifdef TLBUFFEREDMUTABLESTREAM_DECLARE_PRIVATE_METHODS
#define TLBUFFEREDSTREAM_DECLARE_PRIVATE_METHODS
#endif

#import "TLBufferedStream.h"

@interface TLBufferedMutableStream: TLBufferedStream <TLSeekableStream>
{
  /* The offset within the STREAM corresponding to the start of the buffer.  */
  int off;
}

/* Attempt to write non-persistently the characters from range R to the
   STREAM .  Returns the number of characters written, or NIL if the write
   failed.  */
-(int) _writeRange: (id <TLRange>) r toStream: (id <TLOutputStream>) s;

#ifdef TLBUFFEREDMUTABLESTREAM_DECLARE_PRIVATE_METHODS

#endif

@end
