/* Initialization and include-everything objects for tl with GNU runtime.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: tl.m,v 1.2 1998/01/09 11:21:29 tiggr Exp $  */

#import "config.h"

/* This file is only needed to get Objective-C linker semantics on
   machines which lack such a linker.  */
#if GNU_RUNTIME

#define REFERENCE(A)  \
  do			\
    {			\
      extern int A;	\
      tl (&(A));	\
    } while (0)

#define REFERENCE_FUNCTION(A)  \
  do			\
    {			\
      extern int A ();	\
      A ();	\
    } while (0)

void
tl (void *i)
{
  if (!i)
    return;

  REFERENCE (__objc_class_name_TLBufferedStream);
  REFERENCE (__objc_class_name_TLBufferedMutableStream);
  REFERENCE (__objc_class_name_TLCons);
  REFERENCE (__objc_class_name_TLDate);
  REFERENCE (__objc_class_name_TLDictionary);
  REFERENCE (__objc_class_name_TLFDStream);
  REFERENCE (__objc_class_name_TLFILEStream);
  REFERENCE (__objc_class_name_TLLDelegate);
  REFERENCE (__objc_class_name_TLLInvocation);
  REFERENCE (__objc_class_name_TLLLambda);
  REFERENCE (__objc_class_name_TLLLex);
  REFERENCE (__objc_class_name_TLLSubroutine);
  REFERENCE (__objc_class_name_TLLTag);
  REFERENCE (__objc_class_name_TLMutableString);
  REFERENCE (__objc_class_name_TLNumber);
  REFERENCE (__objc_class_name_TLObject);
  REFERENCE (__objc_class_name_TLRange);
  REFERENCE (__objc_class_name_TLSet);
  REFERENCE (__objc_class_name_TLStack);
  REFERENCE (__objc_class_name_TLStreamStream);
  REFERENCE (__objc_class_name_TLString);
  REFERENCE (__objc_class_name_TLStringStream);
  REFERENCE (__objc_class_name_TLSymbol);
  REFERENCE (__objc_class_name_TLSymbolValue);
  REFERENCE (__objc_class_name_TLTrie);
  REFERENCE (__objc_class_name_TLVector);

#include "../TLPatchedRoots.m"
} /* tl */

#endif
