/* Implementation of TLStack class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLStack.m,v 1.3 1998/02/23 14:17:39 tiggr Exp $  */

#define TLSTACK_DECLARE_PRIVATE_METHODS

#import "tl/support.h"
#import "tl/TLStack.h"
#import "tl/TLSymbol.h"

@implementation TLStack

+(TLStack *) stack
{
  return ((id) [self vector]);
} /* +stack */

+(TLStack *) stackWithCapacity: (int) c
{
  return ((id) [self vectorWithCapacity: c]);
} /* +stackWithCapacity: */

+(TLStack *) stackWithElements: (int) n, ...
{
  va_list ap;
  id r;

  va_start (ap, n);
  r = (id) [self vectorWithElements: n : ap];
  va_end (ap);
  return (r);
} /* +stackWithElements: */

-(id) emptyp
{
  return (num ? nil : Qt);
} /* -emptyp */

-(id <TLEnumerator>) enumerator
{
  return ([super reverseEnumerator]);
} /* -enumerator */

-(id) pop
{
  if (!num)
    [self error: "pop from an empty stack"];
  return (contents[--num]);
} /* -pop */

-(id) push: (id) o
{
  return ([self addElement: o]);
} /* -push: */

-(id <TLEnumerator>) reverseEnumerator
{
  return ([super enumerator]);
} /* -reverseEnumerator */

-(id) stackp
{
  return (Qt);
} /* -stackp */

-(id) top
{
  if (!num)
    [self error: "top of empty stack"];
  return (contents[num - 1]);
} /* -top */

@end
