/* Implementation of TLFDStream class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLFDStream.m,v 1.1 1998/01/08 16:11:34 tiggr Exp $  */

#define TLFDSTREAM_DECLARE_PRIVATE_METHODS
#import "tl/support.h"
#import "tl/TLFDStream.h"
#import "tl/TLString.h"
/* Sigh.  hpux (9.05) needs this for strerror... */
#import <string.h>

@implementation TLFDStream

+(id <TLSeekableStream>) streamWithFD: (int) an_fd
{
  return ([[self gcAlloc] initWithFD: an_fd]);
} /* -streamWithFD: */

+(id <TLSeekableStream, TLMutableStream>) mutableStreamWithFD: (int) an_fd
{
  return ([[self gcAlloc] initWithFD: an_fd]);
} /* -mutableStreamWithFD: */

+(id <TLSeekableStream, TLInputStream>)
 streamWithFileNamed: (id <TLString>) name
{
  int d = open ([name cString], O_RDONLY, 0666);
  if (d < 0)
    [self error: "open %#: %s", name, ERRMSG];
  return ([self streamWithFD: d]);
} /* +streamWithFileNamed: */

+(id <TLSeekableStream, TLMutableStream>)
   mutableStreamWithFileNamed: (id <TLString>) name
			 mode: (int) mode protection: (int) prot
{
  int d = open ([name cString], mode, prot);
  if (d < 0)
    [self error: "open %# (0x%x, 0x%x): %s", name, mode, prot, ERRMSG];
  return ([self mutableStreamWithFD: d]);
} /* +mutableStreamWithFileNamed:mode:protection: */

+(id <TLSeekableStream, TLMutableStream>) mutableStreamWithFileNamed:
  (id <TLString>) name
{
  return ([self mutableStreamWithFileNamed: name
	   mode: O_RDWR | O_TRUNC | O_CREAT protection: 0666]);
} /* +mutableStreamWithFileNamed: */

-(int) compare: (id) o
{
  int ofd = [o fileDescriptor];
  return (fd == ofd ? 0 : fd < ofd ? -1 : 1);
} /* -compare: */

-initWithFD: (int) an_fd
{
  fd = an_fd;
  return (self);
} /* -initWithFD: */

/******************** TLStream ********************/

-close
{
  int f = fd;
  fd = -1;
  /* XXX Should this report an error?  */
  return ((f != -1 && close (f)) ? nil : self);
} /* -close */

-(int) fileDescriptor
{
  return (fd);
} /* -fileDescriptor */

-streamp
{
  return (self);
} /* -streamp */

/******************** TLInputStream ********************/

-flushInput
{
  return (self);
} /* -flushInput */

-(int) readByte
{
  unsigned char c;
  int r = read (fd, &c, 1);
  return (r == 1 ? c : TL_EOF);
} /* -readByte */

-(int) readBytes: (int) n intoBuffer: (char *) b
{
  int i = read (fd, b, n);

  if (i == 0)
    i = -1;
  else if (i < 0 && ERRNO == EWOULDBLOCK)
    i = 0;
    
  return (i);
} /* -readBytes:intoBuffer: */

/******************** TLOutputStream ********************/

-flushOutput
{
  return (self);
} /* -flushOutput */

-(int) writeByte: (char) c
{
  int r = write (fd, &c, 1);
  return (r == 1 ? c : TL_EOF);
} /* -writeByte: */

-(int) writeBytes: (int) n fromBuffer: (const char *) b
{
  return (write (fd, b, n));
} /* -writeBytes:fromBuffer: */

/******************** TLMutableStream ********************/

-(long) _tell
{
  return (lseek (fd, 0, SEEK_CUR));
} /* -_tell */

-(long) _seek: (long) offset from: (int) pos
{
  int r;

  switch (pos)
    {
    case TLSEEK_ABSOLUTE: r = SEEK_SET; break;
    case TLSEEK_FROM_END: r = SEEK_END; break;
    case TLSEEK_RELATIVE: r = SEEK_CUR; break;
    default: [self error: "bad TLSEEK %d", pos]; r = 0; break;
    }

  return (lseek (fd, offset, r));
} /* -_seek:from: */

@end
