/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTSelector.h,v 1.8 1998/01/05 00:58:14 tiggr Exp $  */

#import "LTTEntity.h"

@class LTTSelArgTypes;

@interface LTTSelector: LTTEntity
{
  /* The in and out argument types.  */
  LTTSelArgTypes *in, *out;
}

/* Return the selector with the frobnicated NAME and the IN and OUT args.
   This returns the unique selector with those features.  */
+(LTTSelector *) selectorWithName: (id <TLString>) name
			   inArgs: (id <TLString>) inarg
			  outArgs: (id <TLString>) outarg;

+(LTTSelector *) selectorWithMangledName: (id <TLString>) mangled_name;

/* Try to find the selector name NAME.  Return NIL if it can not be found.  */
+(LTTSelector *) searchSelectorNamed: (id <TLString>) name;

/* Return an enumerator on all used selectors.  */
+(id <TLEnumerator>) selectors;

-(void) noteUsage;

-(LTTSelArgTypes *) inArgumentTypes;
-(LTTSelArgTypes *) outArgumentTypes;

-(id <TLString>) outputDefinitionName;

#ifdef LTTSELECTOR_DECLARE_PRIVATE_METHODS

-(id) initWithName: (id <TLString>) name
	    inArgs: (id <TLString>) inarg
	   outArgs: (id <TLString>) outarg;

-(id) initWithMangledName: (id <TLString>) name;

#endif

@end

@interface LTTSelector (Semantics)

+(id) semanticsForSelector: (LTTSelector *) sel;

@end
