/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTName.h,v 1.4 1998/01/05 00:58:10 tiggr Exp $  */

#import "LTTTop.h"

@interface LTTName: TLObject
{
  /* The internal and external representation of of this name.  */
  id <TLString> internal, external;
}

/* Return a new name, with the external name obtained by quoting the
   provided internal name I.  */
+(LTTName *) nameWithInternal: (id <TLString>) i;

+(LTTName *) nameWithInternal: (id <TLString>) i external: (id <TLString>) e;

-(id) initWithInternal: (id <TLString>) i external: (id <TLString>) e;

/* Return the internal name.  */
-(id <TLString>) internal;

/* Output the internal name to the stream S.  */
-(id <TLString>) internal: (id) s;

/* Return the external name.  */
-(id <TLString>) external;

/* Output the external name to the stream S.  */
-(id <TLString>) external: (id) s;

@end
