/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIVariable.h,v 1.5 1998/01/05 00:57:18 tiggr Exp $  */

#import <ltt/ltt.h>

@interface LTIVariable: LTTVariable
{
  /* If we're static (and not thread-local), this is our static name.  */
  id <TLString> static_name;

  /* !0, iff we're local.  */
  unsigned int th_local: 1;
}

-(id <TLString>) staticName;

-(BOOL) isLocal;

-(void) setLocalName: (id <TLString>) sn;

-(void) setStaticName: (id <TLString>) sn;

#ifdef LTIVARIABLE_DECLARE_PRIVATE_METHODS

#endif

@end
