/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIExtension.m,v 1.25 1998/01/05 00:57:06 tiggr Exp $  */

#define LTIEXTENSION_DECLARE_PRIVATE_METHODS
#import "lti.h"

/* GGG This is here to avoid a bug in gcc 2.7.2.1 m68k-next-nextstep3.  */
static void
set_local_or_static_name (LTIVariable *v, BOOL local, id name)
{
  if (local)
    [v setLocalName: name];
  else
    [v setStaticName: name];
}

/* The registered extensions, on increasing identity.  */
TLVector *lti_numeric_extensions;

/* The numeric unique identity of the next extension to be allocated.  */
static int next_identity;

@implementation LTTExtension (Semantics)

+(id) semanticsForExtension: (LTTExtension *) ext
{
  return [CO_LTIExtension extensionWithStructure: ext];
}

@end

@implementation LTIExtension

+(TLVector *) extensions
{
  return lti_numeric_extensions;
}

+(id) extensionWithStructure: (LTTExtension *) str
{
  return [[self gcAlloc] initWithStructure: str];
}

+initialize
{
  if (!lti_numeric_extensions)
    {
      lti_numeric_extensions = [TLVector vector];
      [lti_numeric_extensions gcLock];
    }

  return self;
}

+(int) numExtensions
{
  return next_identity;
}

-(void) addMethod: (LTIMethod *) m
{
  [methods addElement: m];
}

-(int) alignment
{
  return alignment;
}

-(TLDictionary *) constants
{
  return constants;
}

-(void) gcReference
{
  MARK (structure);
  MARK (constants);
  MARK (methods);
  MARK (metas);

  [super gcReference];
}

-(void) digestInfo: (TLCons *) l
{
  while (l)
    {
      id entry, key;
      TLCons *args;

      DECONS (l, entry, l);

      if (![entry consp])
	{
	  warning (@"bad info entry: %#", entry);
	  continue;
	}

      DECONS (entry, key, args);

      if (key == Qfile)
	;
      else if (key == Qmethods)
	while (args)
	  {
	    TLSymbol *method;
	    TLString *selector;
	    TLCons *qualifiers;
	    LTTSelector *sel;

	    DECONS (args, qualifiers, args);
	    DECONS (qualifiers, selector, qualifiers);
	    DECONS (qualifiers, method, qualifiers);

	    sel = [LTTSelector searchSelectorNamed: selector];
	    if (!sel)
	      internal (@"no selector named %#", selector);
	    else
	      {
		LTIMethod *imp = [CO_LTIMethod withSelector: [sel semantics]
					    name: [method symbolName]
					    meta: [[structure meta] semantics]];
		[self addMethod: imp];
		if ([sel semantics] == load_selector
		    && [[[imp meta] structure] classp])
		  {
		    TLCons *c = CONS (imp, nil);
		    load_imps = load_imps ? [load_imps nconc: c] : c;
		  }
	      }

	    if (qualifiers)
	      warning (@"qualifiers ignored: %#", qualifiers);
	  }
      else if (key == Qconstants)
	while (args)
	  {
	    TLString *name, *value;
	    TLCons *l;

	    DECONS (args, l, args);
	    DECONS (l, name, l);
	    DECONS (l, value, l);
	    if (l)
	      warning (@"superfluous constant information ignored: %#", l);

	    if (!constants)
	      constants = [TLDictionary dictionary];

	    [constants setObject: value forKey: name];
	  }
      else if (key == Qsupers)
	while (args)
	  {
	    LTTMeta *str;
	    LTIMeta *m;
	    TLCons *s;
	    int q;

	    DECONS (args, s, args);

	    m = lti_retrieve_meta (s, -1, &q);
	    if (m)
	      {
		str = [m structure];

		if (!q && [[structure meta] classp])
		  str = [str itsClass];

		if (q)
		  [[structure meta] addBehaviourSuper: str];
		else
		  [[structure meta] addStateSuper: str];

		[metas addElement: [str semantics]];
	      }
	  }
      else if (key == Qsuper_refs)
	while (args)
	  {
	    LTIMeta *s;
	    TLCons *e;

	    DECONS (args, e, args);
	    s = lti_retrieve_meta (e, 1, NULL);

	    if (s)
	      {
		LTTMeta *m = [structure meta];
		[[m semantics] addSuperReference: s];
		if (ltt_current_unit)
		  [[[structure container] unit]
		    addSuperReferenceFrom: m to: [s structure]];
	      }
	  }
      else if (key == Qvariables)
	{
	  TLNumber *align;

	  DECONS (args, align, args);
	  DECONS (args, output_var_decl, args);

	  alignment = [align intValue];

	  if (!eid)
	    {
	      eid = ++next_identity;
	      [lti_numeric_extensions addElement: self];
	    }

	  while (args)
	    {
	      TLString *static_name = nil;
	      BOOL local = NO;
	      LTIVariable *v;
	      TLString *name;
	      TLCons *var;
	      id type;
	      int q;

	      DECONS (args, var, args);
	      DECONS (var, name, var);
	      DECONS (var, type, var);

	      v = (id) [CO_LTIVariable variableWithName: name
				    extension: structure];
	      if ([type consp])
		type = lti_retrieve_meta (type, 1, &q);
	      [v setType: type];

	      while (var)
		{
		  id qual;

		  DECONS (var, qual, var);

		  if (![qual consp]
		      || ([qual car] != Qstatic
			  && [qual car] != Qlocal))
		    warning (@"bad variable qualifier: %#", qual);
		  else
		    {
		      id f;

		      DECONS (qual, f, qual);

		      local = f == Qlocal;

		      DECONS (qual, static_name, f);

		      set_local_or_static_name (v, local, static_name);
		    }
		}
	      if (static_name)
		[structure addStaticVariable: v];
	      else
		[structure addVariable: v];
	    }
	}
      else
	warning (@"bad info entry: %#", entry);
    }
}

-(int) identity
{
  return eid;
}

-initWithStructure: (LTTExtension *) e
{
  if (![super init])
    return nil;

  structure = e;
  methods = [TLVector vector];
  metas = [TLVector vector];

  return self;
}

-(TLVector *) metas
{
  return metas;
}

-(TLVector *) methods
{
  return methods;
}

-(LTTExtension *) structure
{
  return structure;
}

@end

